/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@Ser
public class APKSigSchemeV2Block {
    private static final ILogger logger = GlobalLog.getLogger(APKSigSchemeV2Block.class);
    public static final int SigAlgoId_RSASSA_PSS_SHA2_256 = 257;
    public static final int SigAlgoId_RSASSA_PSS_SHA2_512 = 258;
    public static final int SigAlgoId_RSASSA_PKCS1_v1_5_SHA2_256 = 259;
    public static final int SigAlgoId_RSASSA_PKCS1_v1_5_SHA2_512 = 260;
    public static final int SigAlgoId_ECDSA_SHA2_256 = 513;
    public static final int SigAlgoId_ECDSA_SHA2_512 = 514;
    public static final int SigAlgoId_DSA_SHA2_256 = 769;
    @SerTransient
    private ByteBuffer b;
    @SerId(value=1)
    List<Signer> signers = new ArrayList<Signer>();

    public static String algoIdToString(int n2) {
        switch (n2) {
            case 257: {
                return "RSASSA-PSS-SHA2-256";
            }
            case 258: {
                return "RSASSA-PSS-SHA2-512";
            }
            case 259: {
                return "RSASSA-PKCS1-v1_5-SHA2-256";
            }
            case 260: {
                return "RSASSA-PKCS1-v1_5-SHA2-512";
            }
            case 513: {
                return "ECDSA-SHA2-256";
            }
            case 514: {
                return "ECDSA-SHA2-512";
            }
            case 769: {
                return "DSA-SHA2-256";
            }
        }
        return "Unknown-Algo-ID-" + n2;
    }

    public APKSigSchemeV2Block(ByteBuffer byteBuffer) {
        this.b = byteBuffer;
        this.parse(byteBuffer.remaining());
    }

    public List<Signer> getSigners() {
        return this.signers;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "Signers (%d):\n", this.signers.size());
        for (Signer signer : this.signers) {
            Strings.ff(stringBuilder, "%s\n", signer);
        }
        return stringBuilder.toString();
    }

    protected void parse(int n2) {
        int n3 = this.readSize();
        n2 -= 4 + n3;
        while (n3 > 0) {
            int n4;
            byte[] byArray;
            int n5;
            int n6;
            int n7;
            int n8;
            Signer signer = new Signer();
            int n9 = this.readSize();
            n3 -= 4 + n9;
            int n10 = this.readSize();
            n9 -= 4 + n10;
            int n11 = this.readSize();
            n10 -= 4 + n11;
            while (n11 > 0) {
                n8 = this.readSize();
                n11 -= 4 + n8;
                n7 = this.readInt();
                n8 -= 4;
                n6 = this.readSize();
                byte[] byArray2 = this.readBytes(n6);
                signer.digests.add(new Digest(n7, byArray2));
                this.verifyZero(n8 -= 4 + n6);
            }
            this.verifyZero(n11);
            n10 -= 4 + n8;
            for (n8 = this.readSize(); n8 > 0; n8 -= 4 + n7) {
                n7 = this.readSize();
                byte[] byArray3 = this.readBytes(n7);
                signer.certificates.add(new Certificate(byArray3));
            }
            this.verifyZero(n8);
            n10 -= 4 + n7;
            for (n7 = this.readSize(); n7 > 0; n7 -= 4 + n5) {
                n5 = this.readSize();
                int n12 = this.readInt();
                byArray = this.readBytes(n5 - 4);
                signer.attributes.add(new Attribute(n12, byArray));
            }
            this.verifyZero(n7);
            this.skipAndWarnIfNonZero(n10);
            n9 -= 4 + n6;
            for (n6 = this.readSize(); n6 > 0; n6 -= n4) {
                n4 = this.readSize();
                n6 -= 4;
                int n13 = this.readInt();
                byte[] byArray4 = this.readBytes(n4 - 4);
                signer.signatures.add(new Signature(n13, byArray4));
            }
            this.verifyZero(n6);
            int n14 = this.readSize();
            byArray = this.readBytes(n14);
            signer.publicKey = new PublicKey(byArray);
            this.signers.add(signer);
            this.verifyZero(n9 -= 4 + n14);
        }
        this.verifyZero(n3);
        this.verifyZero(n2);
    }

    protected int readSize() {
        int n2 = this.b.getInt();
        if (this.b.remaining() < n2) {
            throw new BufferUnderflowException();
        }
        return n2;
    }

    protected int readInt() {
        return this.b.getInt();
    }

    protected byte[] readBytes(int n2) {
        if (n2 < 0) {
            throw new BufferUnderflowException();
        }
        byte[] byArray = new byte[n2];
        this.b.get(byArray);
        return byArray;
    }

    protected void skipBytes(int n2) {
        if (n2 < 0) {
            throw new BufferUnderflowException();
        }
        this.b.position(this.b.position() + n2);
    }

    protected void verifyZero(int n2) {
        if (n2 != 0) {
            throw new RuntimeException("Expected end of record");
        }
    }

    protected void skipAndWarnIfNonZero(int n2) {
        if (n2 != 0) {
            logger.trace("[APK Sig v2] Unexpected slack instead of end of record; skipping %d bytes", n2);
            this.skipBytes(n2);
        }
    }

    @Ser
    public static class Signer {
        @SerId(value=1)
        List<Digest> digests = new ArrayList<Digest>();
        @SerId(value=2)
        List<Certificate> certificates = new ArrayList<Certificate>();
        @SerId(value=3)
        List<Attribute> attributes = new ArrayList<Attribute>();
        @SerId(value=4)
        List<Signature> signatures = new ArrayList<Signature>();
        @SerId(value=5)
        PublicKey publicKey;

        public List<Digest> getDigests() {
            return this.digests;
        }

        public List<Certificate> getCertificates() {
            return this.certificates;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public List<Signature> getSignatures() {
            return this.signatures;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.digests.isEmpty()) {
                Strings.ff(stringBuilder, "Digests (%d):\n", this.digests.size());
                for (Digest object : this.digests) {
                    Strings.ff(stringBuilder, "- %s\n", object);
                }
            }
            if (!this.certificates.isEmpty()) {
                Strings.ff(stringBuilder, "Certificates (%d):\n", this.certificates.size());
                for (Certificate certificate : this.certificates) {
                    Strings.ff(stringBuilder, "- %s\n", certificate);
                }
            }
            if (!this.attributes.isEmpty()) {
                Strings.ff(stringBuilder, "Attributes (%d):\n", this.attributes.size());
                for (Attribute attribute : this.attributes) {
                    Strings.ff(stringBuilder, "- %s\n", attribute);
                }
            }
            if (!this.signatures.isEmpty()) {
                Strings.ff(stringBuilder, "Signatures (%d):\n", this.signatures.size());
                for (Signature signature : this.signatures) {
                    Strings.ff(stringBuilder, "- %s\n", signature);
                }
            }
            Strings.ff(stringBuilder, "Public Key:\n- %s\n", this.publicKey);
            return stringBuilder.toString();
        }
    }

    @Ser
    public static class PublicKey {
        @SerId(value=1)
        byte[] bytes;

        PublicKey(byte[] byArray) {
            this.bytes = byArray;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return Strings.ff("%s", Formatter.byteArrayToHex(this.bytes));
        }
    }

    @Ser
    public static class Signature {
        @SerId(value=1)
        int algoId;
        @SerId(value=2)
        byte[] signatureBytes;

        Signature(int n2, byte[] byArray) {
            this.algoId = n2;
            this.signatureBytes = byArray;
        }

        public int getSignatureAlgorithmId() {
            return this.algoId;
        }

        public byte[] getSignatureBytes() {
            return this.signatureBytes;
        }

        public String toString() {
            return Strings.ff("%s:%s", APKSigSchemeV2Block.algoIdToString(this.algoId), Formatter.byteArrayToHex(this.signatureBytes));
        }
    }

    @Ser
    public static class Attribute {
        @SerId(value=1)
        int id;
        @SerId(value=2)
        byte[] value;

        Attribute(int n2, byte[] byArray) {
            this.id = n2;
            this.value = byArray;
        }

        public int getId() {
            return this.id;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String toString() {
            return Strings.ff("id=%d,value=%s", this.id, Formatter.byteArrayToHex(this.value));
        }
    }

    @Ser
    public static class Certificate {
        @SerId(value=1)
        byte[] bytes;

        Certificate(byte[] byArray) {
            this.bytes = byArray;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return Strings.ff("%s", Formatter.byteArrayToHex(this.bytes));
        }
    }

    @Ser
    public static class Digest {
        @SerId(value=1)
        int algoId;
        @SerId(value=2)
        byte[] digestBytes;

        Digest(int n2, byte[] byArray) {
            this.algoId = n2;
            this.digestBytes = byArray;
        }

        public int getSignatureAlgorithmId() {
            return this.algoId;
        }

        public byte[] getDigestBytes() {
            return this.digestBytes;
        }

        public String toString() {
            return Strings.ff("%s:%s", APKSigSchemeV2Block.algoIdToString(this.algoId), Formatter.byteArrayToHex(this.digestBytes));
        }
    }
}

