/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class Pointer {
    private static final int POINTER = 4;
    public static final int UNKNOWN = 0;
    public static final int CODE = 1;
    public static final int DATA = 2;
    public static final int PTRCODE = 5;
    public static final int PTRDATA = 6;
    @SerId(value=1)
    protected long address;
    @SerId(value=2)
    protected int size;
    @SerId(value=3)
    protected int type;

    public Pointer(long l2, int n2, int n3) {
        this.address = l2;
        this.size = n2;
        this.type = n3;
    }

    public Pointer(long l2) {
        this(l2, 0, 0);
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (int)(this.address ^ this.address >>> 32);
        n2 = 31 * n2 + this.size;
        n2 = 31 * n2 + this.type;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Pointer pointer = (Pointer)object;
        if (this.address != pointer.address) {
            return false;
        }
        if (this.size != pointer.size) {
            return false;
        }
        return this.type == pointer.type;
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n2) {
        this.size = n2;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        Object object;
        switch (this.getType()) {
            case 1: {
                object = "CODE";
                break;
            }
            case 2: {
                object = "DATA";
                break;
            }
            case 5: {
                object = "PTRCODE";
                break;
            }
            case 6: {
                object = "PTRDATA";
                break;
            }
            default: {
                object = "" + this.getType();
            }
        }
        return Strings.ff("%Xh/%d(%s)", this.getAddress(), this.getSize(), object);
    }
}

