/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.CodeCommentManager;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class NativeCommentManager
extends CodeCommentManager<INativeCodeUnit<?>> {
    @SerId(value=1)
    private INativeCodeUnit<?> pbcu;

    public NativeCommentManager(INativeCodeUnit<?> iNativeCodeUnit) {
        super(iNativeCodeUnit);
        this.pbcu = iNativeCodeUnit;
    }

    public long addressToMemory(String string) {
        return this.pbcu.getCanonicalMemoryAddress(string);
    }

    public String memoryToAddress(long l2) {
        return this.pbcu.getSymbolicStringAddress(l2, 2);
    }

    public long coordToMemory(ICodeCoordinates iCodeCoordinates) {
        String string = this.pbcu.getAddressFromCodeCoordinates(iCodeCoordinates);
        return string == null ? -1L : this.pbcu.getCanonicalMemoryAddress(string);
    }

    public ICodeCoordinates memoryToCoord(long l2) {
        String string = this.pbcu.getSymbolicStringAddress(l2, 2);
        return string == null ? null : this.pbcu.getCodeCoordinatesFromAddress(string);
    }
}

