/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IVariable;
import com.pnfsoftware.jeb.util.collect.IntegerSegment;
import com.pnfsoftware.jeb.util.collect.SegmentMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

@Ser
public class IdRanges {
    @SerId(value=1)
    private Map<Integer, Integer> fullVars = new HashMap<Integer, Integer>();
    @SerId(value=2)
    private Map<Integer, SegmentMap<Integer, IntegerSegment>> rangesFull = new HashMap<Integer, SegmentMap<Integer, IntegerSegment>>();

    public IdRanges() {
    }

    public IdRanges(IdRanges idRanges) {
        this.fullVars.putAll(idRanges.fullVars);
        for (Integer n2 : idRanges.rangesFull.keySet()) {
            SegmentMap<Integer, IntegerSegment> segmentMap = idRanges.rangesFull.get(n2);
            if (segmentMap == null) {
                this.rangesFull.put(n2, null);
                continue;
            }
            this.rangesFull.put(n2, new SegmentMap<Integer, IntegerSegment>(segmentMap));
        }
    }

    public void clear() {
        this.fullVars.clear();
        this.rangesFull.clear();
    }

    public int bsize() {
        int n2 = 0;
        for (SegmentMap<Integer, IntegerSegment> segmentMap : this.rangesFull.values()) {
            for (IntegerSegment integerSegment : segmentMap.values()) {
                n2 += integerSegment.getSize();
            }
        }
        return n2;
    }

    public int size() {
        return this.fullVars.size();
    }

    public boolean isEmpty() {
        return this.fullVars.isEmpty();
    }

    public void remove(IVariable iVariable) {
        this.remove(iVariable.getId());
    }

    public void remove(int n2) {
        this.fullVars.remove(n2);
        this.rangesFull.remove(n2);
    }

    public void addAll(Collection<? extends IVariable> collection, Collection<? extends IVariable> collection2) {
        for (IVariable iVariable : collection) {
            if (collection2.contains(iVariable)) continue;
            this.add(iVariable);
        }
    }

    public void addAll(Collection<? extends IVariable> collection, IdRanges idRanges) {
        for (IVariable iVariable : collection) {
            if (idRanges.fullVars.containsKey(iVariable.getId())) continue;
            this.add(iVariable);
        }
    }

    public void addAll(Collection<? extends IVariable> collection) {
        for (IVariable iVariable : collection) {
            this.add(iVariable);
        }
    }

    public void add(IVariable iVariable) {
        this.add(iVariable.getId(), iVariable.getBitsize(), iVariable.getId(), iVariable.getBitsize());
    }

    public void add(IVariable iVariable, int n2, int n3) {
        this.add(iVariable.getId(), iVariable.getBitsize(), n2, n3);
    }

    public void add(int n2, int n3) {
        this.add(n2, n3, 0, n3);
    }

    private void add(int n2, int n3, int n4, int n5) {
        ArrayList<IntegerSegment> arrayList;
        SegmentMap<Integer, IntegerSegment> segmentMap = this.rangesFull.get(n2);
        if (segmentMap == null) {
            segmentMap = new SegmentMap();
            segmentMap.setRemoveSegmentsOnOverlap(true);
            this.rangesFull.put(n2, segmentMap);
        }
        if (n4 < 0) {
            n4 = n4 - n5 + 1;
        }
        int n6 = n4 + n5;
        SortedMap<Integer, IntegerSegment> sortedMap = segmentMap.getOverlappingSegmentsMap(n4, true, n6, true);
        if (!sortedMap.isEmpty()) {
            arrayList = new ArrayList<IntegerSegment>(sortedMap.values());
            IntegerSegment integerSegment = (IntegerSegment)arrayList.get(0);
            if (integerSegment.getBegin().compareTo(n4) < 0) {
                n4 = integerSegment.getBegin();
            }
            if ((integerSegment = (IntegerSegment)arrayList.get(arrayList.size() - 1)).getEnd().compareTo(n6) > 0) {
                n6 = integerSegment.getEnd();
            }
            for (Integer n7 : sortedMap.keySet()) {
                segmentMap.remove(n7);
            }
        }
        arrayList = new IntegerSegment(n4, n6 - n4);
        segmentMap.add((IntegerSegment)((Object)arrayList));
        this.fullVars.put(n2, n3);
    }

    public boolean containsVarPart(IVariable iVariable) {
        SegmentMap<Integer, IntegerSegment> segmentMap = this.rangesFull.get(iVariable.getId());
        return segmentMap != null && !segmentMap.isEmpty();
    }

    public boolean containsVarFull(int n2, int n3) {
        SegmentMap<Integer, IntegerSegment> segmentMap = this.rangesFull.get(n2);
        return segmentMap != null && segmentMap.size() == 1 && ((IntegerSegment)segmentMap.values().iterator().next()).getSize() == n3;
    }

    public boolean containsVarFull(int n2) {
        Integer n3 = this.fullVars.get(n2);
        if (n3 != null) {
            return this.containsVarFull(n2, n3);
        }
        return false;
    }

    public List<Integer> getVarIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.collectVarIds(arrayList);
        return arrayList;
    }

    public void collectVarIds(Collection<Integer> collection) {
        collection.addAll(this.fullVars.keySet());
    }

    public List<Integer> getBits() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.collectBits(arrayList);
        return arrayList;
    }

    public void collectBits(List<Integer> list) {
        for (Map.Entry<Integer, SegmentMap<Integer, IntegerSegment>> entry : this.rangesFull.entrySet()) {
            for (IntegerSegment integerSegment : entry.getValue().values()) {
                int n2 = integerSegment.getBegin();
                int n3 = integerSegment.getEnd();
                while (n2 < n3) {
                    list.add(n2++);
                }
            }
        }
    }

    public IdRanges intersection(IdRanges idRanges) {
        Map<Integer, SegmentMap<Integer, IntegerSegment>> map = this.intersect(this.rangesFull, idRanges.rangesFull);
        if (map.size() == 0) {
            return null;
        }
        IdRanges idRanges2 = new IdRanges();
        for (Map.Entry<Integer, SegmentMap<Integer, IntegerSegment>> entry : map.entrySet()) {
            int n2 = entry.getKey();
            Integer n3 = this.fullVars.get(n2);
            if (n3 == null) {
                throw new RuntimeException(Strings.ff("Error with intersection of var %d", entry.getKey()));
            }
            for (IntegerSegment integerSegment : entry.getValue().values()) {
                int n4 = integerSegment.getBegin();
                if (integerSegment.getBegin() < 0) {
                    n4 = n4 + integerSegment.getSize() - 1;
                }
                idRanges2.add(n2, n3, n4, integerSegment.getSize());
            }
        }
        return idRanges2;
    }

    private Map<Integer, SegmentMap<Integer, IntegerSegment>> intersect(Map<Integer, SegmentMap<Integer, IntegerSegment>> map, Map<Integer, SegmentMap<Integer, IntegerSegment>> map2) {
        HashMap<Integer, SegmentMap<Integer, IntegerSegment>> hashMap = new HashMap<Integer, SegmentMap<Integer, IntegerSegment>>();
        for (Map.Entry<Integer, SegmentMap<Integer, IntegerSegment>> entry : map.entrySet()) {
            int n2 = entry.getKey();
            SegmentMap<Integer, IntegerSegment> segmentMap = entry.getValue();
            SegmentMap<Integer, IntegerSegment> segmentMap2 = map2.get(n2);
            if (segmentMap == null || segmentMap2 == null) continue;
            SegmentMap<Integer, IntegerSegment> segmentMap3 = new SegmentMap<Integer, IntegerSegment>();
            segmentMap3.setRemoveSegmentsOnOverlap(true);
            for (IntegerSegment integerSegment : segmentMap.values()) {
                for (IntegerSegment integerSegment2 : segmentMap2.values()) {
                    if (integerSegment.getBegin() >= integerSegment2.getEnd() || integerSegment2.getBegin() >= integerSegment.getEnd()) continue;
                    int n3 = Math.max(integerSegment.getBegin(), integerSegment2.getBegin());
                    int n4 = Math.min(integerSegment.getEnd(), integerSegment2.getEnd());
                    segmentMap3.put(n3, new IntegerSegment(n3, n4 - n3));
                }
            }
            if (segmentMap3.isEmpty()) continue;
            hashMap.put(n2, segmentMap3);
        }
        return hashMap;
    }

    public boolean hasIntersection(IdRanges idRanges) {
        return this.intersection(idRanges) != null;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.fullVars == null ? 0 : this.fullVars.hashCode());
        n2 = 31 * n2 + (this.rangesFull == null ? 0 : this.rangesFull.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IdRanges idRanges = (IdRanges)object;
        if (this.fullVars == null ? idRanges.fullVars != null : !this.fullVars.equals(idRanges.fullVars)) {
            return false;
        }
        return !(this.rangesFull == null ? idRanges.rangesFull != null : !this.rangesFull.equals(idRanges.rangesFull));
    }

    public String toString() {
        return this.fullVars.keySet().toString();
    }
}

