/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.exceptions.NotImplementedException;
import com.pnfsoftware.jeb.core.units.code.DefUseInfo;
import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.InstructionFlags;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ACS;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.Collection;
import java.util.List;

@Ser
public interface IInstruction {
    public int getProcessorMode();

    public int getSize();

    public byte[] getCode();

    public String getPrefix();

    public String getMnemonic();

    public IInstructionOperand[] getOperands();

    default public IInstructionOperand getOperand(int n2) {
        return this.getOperands()[n2];
    }

    default public int getCountOfOperands() {
        return this.getOperands().length;
    }

    public IFlowInformation getBreakingFlow(long var1);

    public IFlowInformation getRoutineCall(long var1);

    public IFlowInformation collectIndirectCallReferences(long var1);

    default public long getPrimaryBranchAddress(long l2) {
        ICodePointer iCodePointer = null;
        IFlowInformation iFlowInformation = this.getBreakingFlow(l2);
        if (iFlowInformation.isBroken()) {
            if (iFlowInformation.getTargets().size() == 1) {
                iCodePointer = iFlowInformation.getTargets().get(0);
            } else if (iFlowInformation.getTargets().size() >= 2) {
                iCodePointer = iFlowInformation.getTargets().get(1);
            }
        } else {
            iFlowInformation = this.getRoutineCall(l2);
            if (iFlowInformation.isBroken() && iFlowInformation.getTargets().size() >= 1) {
                iCodePointer = iFlowInformation.getTargets().get(0);
            }
        }
        if (iCodePointer == null) {
            return -1L;
        }
        return iCodePointer.getAddress();
    }

    public void getDefUse(List<Integer> var1, List<Integer> var2, Object var3);

    default public void getDefUse(List<Integer> list, List<Integer> list2) {
        this.getDefUse(list, list2, null);
    }

    default public DefUseInfo getDefUseInfo(long l2, int n2) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public Collection<InstructionFlags> getInstructionFlags();

    public boolean canThrow();

    public String format(Object var1);

    default public ACS getACS() {
        return null;
    }
}

