/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Ser
public class FlowInformation
implements IFlowInformation {
    public static final int FLAG_COMPUTE_FT = 1;
    public static final int FLAG_NO_FT = 2;
    public static final FlowInformation NONE = new FlowInformation(true, 0, 0);
    public static final FlowInformation EMPTY = new FlowInformation(false, 0, 0);
    public static final FlowInformation EMPTY_NO_FT = new FlowInformation(false, 0, 2);
    @SerId(value=1)
    private List<ICodePointer> targets;
    @SerId(value=2, deprecated=true)
    private boolean computeFallThrough;
    @SerId(value=3)
    private int delaySlotCount;
    @SerId(value=4)
    private int flags;

    @SerCustomInitPostGraph
    private void init() {
        if (this.computeFallThrough) {
            this.flags |= 1;
            this.computeFallThrough = false;
        }
    }

    private FlowInformation(boolean bl, int n2, int n3) {
        if (!bl) {
            this.targets = new ArrayList<ICodePointer>();
        }
        this.delaySlotCount = n2;
        this.flags = n3;
    }

    public FlowInformation() {
        this(false, 0, 0);
    }

    public FlowInformation(boolean bl, int n2) {
        this.targets = new ArrayList<ICodePointer>();
        this.setComputeFallThrough(bl);
        this.setDelaySlotCount(n2);
    }

    public void addTarget(ICodePointer iCodePointer) {
        if (this.targets == null) {
            throw new IllegalArgumentException("NONE flow information can not contain targets");
        }
        this.targets.add(iCodePointer);
    }

    public void addTargets(Collection<? extends ICodePointer> collection) {
        if (this.targets == null) {
            throw new IllegalArgumentException("NONE flow information can not contain targets");
        }
        this.targets.addAll(collection);
    }

    @Override
    public boolean isBroken() {
        return this.targets != null;
    }

    @Override
    public boolean isBrokenUnknown() {
        return this.targets != null && (this.targets.isEmpty() || this.areAllTargetsUnknown());
    }

    @Override
    public boolean isBrokenKnown() {
        return this.targets != null && !this.targets.isEmpty() && !this.hasUnknownTargets();
    }

    private boolean hasUnknownTargets() {
        for (ICodePointer iCodePointer : this.targets) {
            if (!iCodePointer.isUnknownAddress()) continue;
            return true;
        }
        return false;
    }

    private boolean areAllTargetsUnknown() {
        for (ICodePointer iCodePointer : this.targets) {
            if (iCodePointer.isUnknownAddress()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ICodePointer> getTargets() {
        return this.targets;
    }

    public void setComputeFallThrough(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    @Override
    public boolean mustComputeFallThrough() {
        return (this.flags & 1) != 0;
    }

    public void setNoFallThrough(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public boolean noFallThrough() {
        return (this.flags & 2) != 0;
    }

    public void setDelaySlotCount(int n2) {
        if (n2 < 0 || n2 > 255) {
            throw new RuntimeException("Delay slot must be in [0, 255]");
        }
        this.delaySlotCount = n2;
    }

    @Override
    public int getDelaySlotCount() {
        return this.delaySlotCount;
    }

    public String toString() {
        if (this.targets == null) {
            return "NON-BREAKING";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "targets=%s", this.targets);
        if (this.mustComputeFallThrough()) {
            Strings.ff(stringBuilder, ",computeFallThrough=true", new Object[0]);
        }
        if (this.getDelaySlotCount() != 0) {
            Strings.ff(stringBuilder, ",delaySlotCount=%d", this.getDelaySlotCount());
        }
        return stringBuilder.toString();
    }

    public static boolean isAddressInTargets(IFlowInformation iFlowInformation, long l2) {
        for (ICodePointer iCodePointer : iFlowInformation.getTargets()) {
            if (iCodePointer.getAddress() != l2) continue;
            return true;
        }
        return false;
    }
}

