/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IdRanges;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Collections;
import java.util.List;

public class DefUseInfo {
    public static final int FLAG_INCLUDE_POTENTIALS = 1;
    public static final int FLAG_INCLUDE_SPOILED = 2;
    public static final int CONSERVATIVE = 3;
    public Long insnAddress;
    public IdRanges def = new IdRanges();
    public IdRanges use = new IdRanges();
    public IdRanges defpot;
    public IdRanges usepot;
    public IdRanges spoiled;

    public DefUseInfo() {
        this(0);
    }

    public DefUseInfo(int n2) {
        if ((n2 & 1) != 0) {
            this.defpot = new IdRanges();
            this.usepot = new IdRanges();
        }
        if ((n2 & 2) != 0) {
            this.spoiled = new IdRanges();
        }
    }

    public Long getInstructionAddress() {
        return this.insnAddress;
    }

    public void setInstructionAddress(long l2) {
        if (this.insnAddress != null) {
            if (this.insnAddress == l2) {
                return;
            }
            throw new IllegalStateException();
        }
        this.insnAddress = l2;
    }

    public void clear() {
        this.insnAddress = null;
        this.def.clear();
        this.use.clear();
        if (this.defpot != null) {
            this.defpot.clear();
        }
        if (this.usepot != null) {
            this.usepot.clear();
        }
        if (this.spoiled != null) {
            this.spoiled.clear();
        }
    }

    public boolean shouldCollectPotentials() {
        return this.defpot != null && this.usepot != null;
    }

    public boolean shouldCollectSpoiled() {
        return this.spoiled != null;
    }

    public IdRanges getDef() {
        return this.def;
    }

    public IdRanges getUse() {
        return this.use;
    }

    public List<Integer> getDefinedVarIds() {
        return this.def.getVarIds();
    }

    public List<Integer> getUsedVarIds() {
        return this.use.getVarIds();
    }

    public List<Integer> getPotentiallyDefinedVarIds() {
        return this.defpot == null ? Collections.emptyList() : this.defpot.getVarIds();
    }

    public List<Integer> getPotentiallyUsedVarIds() {
        return this.usepot == null ? Collections.emptyList() : this.usepot.getVarIds();
    }

    public List<Integer> getSpoiledVarIds() {
        return this.spoiled == null ? Collections.emptyList() : this.spoiled.getVarIds();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "@%s:", this.insnAddress == null ? "?" : Long.toHexString(this.insnAddress));
        Strings.ff(stringBuilder, " def=%s use=%s", this.def, this.use);
        if (this.defpot != null) {
            Strings.ff(stringBuilder, " def-pot=%s", this.defpot);
        }
        if (this.usepot != null) {
            Strings.ff(stringBuilder, " use-pot=%s", this.usepot);
        }
        if (this.spoiled != null) {
            Strings.ff(stringBuilder, " spoiled=%s", this.spoiled);
        }
        return stringBuilder.toString();
    }
}

