/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.core.exceptions.DemoLimitationException;
import com.pnfsoftware.jeb.core.units.code.DecompilationOptions;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public abstract class DecompilerExporter {
    protected static final ILogger logger = GlobalLog.getLogger(DecompilerExporter.class);
    protected IDecompilerUnit decomp;
    protected File outputFolder;
    protected String headerString;
    protected Pattern pattern;
    protected long methodTimeoutMs;
    protected long totalTimeoutMs;
    protected IProgressCallback callback;
    protected boolean discardDecompiledItemsAfterProcessing;
    protected boolean usesCustomDecompWriter;
    protected AtomicInteger writeCount;
    protected AtomicInteger writeErrorCount;
    protected Map<String, String> errormap;

    public DecompilerExporter(IDecompilerUnit iDecompilerUnit) {
        if (iDecompilerUnit == null) {
            throw new IllegalArgumentException("Provide a decompiler");
        }
        this.decomp = iDecompilerUnit;
        this.setHeaderString("Decompiled by JEB v" + AbstractContext.app_ver);
    }

    protected void reset() {
        this.writeCount = new AtomicInteger();
        this.writeErrorCount = new AtomicInteger();
        this.errormap = null;
    }

    public IDecompilerUnit getDecompiler() {
        return this.decomp;
    }

    public void setOutputFolder(File file) throws IOException {
        this.setOutputFolder(file, null);
    }

    public void setOutputFolder(File file, Boolean bl) throws IOException {
        if (file == null) {
            this.outputFolder = null;
        } else {
            if (file.exists()) {
                if (file.isFile()) {
                    throw new IOException("The specified output exists already and is not a folder");
                }
            } else if (!IO.createDirectory(file)) {
                throw new IOException("Cannot create output directory");
            }
            this.outputFolder = file;
        }
        if (bl != null) {
            this.setDiscardDecompiledItemsAfterProcessing(bl);
        }
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setHeaderString(String string) {
        this.headerString = string == null || Strings.isBlank(string) ? null : "// " + Strings.replaceNewLines(string, " / ") + Strings.LINESEP + Strings.LINESEP;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setSignaturePattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getSignaturePattern() {
        return this.pattern;
    }

    public void setMethodTimeout(long l2) {
        this.methodTimeoutMs = l2;
    }

    public long getMethodTimeout() {
        return this.methodTimeoutMs;
    }

    public void setTotalTimeout(long l2) {
        this.totalTimeoutMs = l2;
    }

    public long getTotalTimeout() {
        return this.totalTimeoutMs;
    }

    public void setCallback(IProgressCallback iProgressCallback) {
        this.callback = iProgressCallback;
    }

    public IProgressCallback getCallback() {
        return this.callback;
    }

    public void setDiscardDecompiledItemsAfterProcessing(boolean bl) {
        this.discardDecompiledItemsAfterProcessing = bl;
    }

    public boolean isKeepDecompiledItemsAfterProcessing() {
        return this.discardDecompiledItemsAfterProcessing;
    }

    public final boolean export() {
        return this.process();
    }

    public abstract boolean process();

    protected void customizeOptions(boolean bl, DecompilationOptions.Builder builder) {
    }

    public boolean processTopLevelClasses() {
        throw new DemoLimitationException("The decompiler exporter is not available in the demo version");
    }

    public boolean processMethods() {
        throw new DemoLimitationException("The decompiler exporter is not available in the demo version");
    }

    protected String generateMethodFileName(String string) {
        return string + this.decomp.getOutputType().getPreferredExtension();
    }

    protected void writeMethodDecompilation(String string) {
        if (this.outputFolder == null) {
            throw new IllegalStateException();
        }
        Object object = this.decomp.getDecompiledMethodText(string);
        if (object == null) {
            return;
        }
        if (this.headerString != null) {
            object = this.headerString + (String)object;
        }
        String string2 = this.generateMethodFileName(string);
        File file = new File(this.outputFolder, string2);
        try {
            IO.writeFile(file, Strings.encodeLocal((String)object), true);
            this.writeCount.incrementAndGet();
        }
        catch (IOException iOException) {
            logger.error("Cannot write output file: %s. Error: %s", file, iOException.getMessage());
            this.writeErrorCount.incrementAndGet();
        }
    }

    protected String generateClassFileName(String string) {
        return string + this.decomp.getOutputType().getPreferredExtension();
    }

    protected void writeClassDecompilation(String string) {
        if (this.outputFolder == null) {
            throw new IllegalStateException();
        }
        ISourceUnit iSourceUnit = this.decomp.getDecompiledUnit(string);
        Object object = iSourceUnit != null ? iSourceUnit.getSource() : this.decomp.getDecompiledClassText(string);
        if (object == null) {
            return;
        }
        if (this.headerString != null) {
            object = this.headerString + (String)object;
        }
        String string2 = this.generateClassFileName(string);
        File file = new File(this.outputFolder, string2);
        try {
            IO.writeFile(file, Strings.encodeLocal((String)object), true);
            this.writeCount.incrementAndGet();
        }
        catch (IOException iOException) {
            logger.error("Cannot write output file: %s. Error: %s", file, iOException.getMessage());
            this.writeErrorCount.incrementAndGet();
        }
    }

    public Integer getGeneratedFileCount() {
        return this.writeCount.get();
    }

    public Map<String, String> getErrors() {
        if (this.errormap == null) {
            throw new IllegalStateException();
        }
        return this.errormap;
    }
}

