/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import java.util.function.Consumer;

public class DecompilationOptions {
    public static final DecompilationOptions DEFAULT = new DecompilationOptions(0, null, null, null);
    private final int flags;
    private final Long maxTimePerMethod;
    private final Long maxTimeTotal;
    private final Consumer<String> postDecompilationCallback;

    public static DecompilationOptions safe(DecompilationOptions decompilationOptions) {
        return decompilationOptions != null ? decompilationOptions : DEFAULT;
    }

    DecompilationOptions(int n2, Long l2, Long l3, Consumer<String> consumer) {
        this.flags = n2;
        this.maxTimePerMethod = l2;
        this.maxTimeTotal = l3;
        this.postDecompilationCallback = consumer;
    }

    public int getFlags() {
        return this.flags;
    }

    public Long getMaxTimePerMethod() {
        return this.maxTimePerMethod;
    }

    public Long getMaxTimeTotal() {
        return this.maxTimeTotal;
    }

    public Consumer<String> getPostDecompilationCallback() {
        return this.postDecompilationCallback;
    }

    public Builder asBuilder() {
        Builder builder = new Builder();
        builder.flags = this.flags;
        builder.maxTimePerMethod = this.maxTimePerMethod;
        builder.maxTimeTotal = this.maxTimeTotal;
        builder.postDecompilationCallback = this.postDecompilationCallback;
        return builder;
    }

    public static class Builder {
        private int flags;
        private Long maxTimePerMethod;
        private Long maxTimeTotal;
        private Consumer<String> postDecompilationCallback;

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder flags(int n2) {
            this.flags = n2;
            return this;
        }

        public Builder maxTimePerMethod(Long l2) {
            this.maxTimePerMethod = l2;
            return this;
        }

        public Builder maxTimeTotal(Long l2) {
            this.maxTimeTotal = l2;
            return this;
        }

        public Builder postDecompilationCallback(Consumer<String> consumer) {
            this.postDecompilationCallback = consumer;
            return this;
        }

        public DecompilationOptions build() {
            return new DecompilationOptions(this.flags, this.maxTimePerMethod, this.maxTimeTotal, this.postDecompilationCallback);
        }
    }
}

