/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.DecompilationOptions;
import com.pnfsoftware.jeb.core.units.code.DecompilationResult;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DecompilationContext {
    private DecompilationOptions opt;
    private IProgressCallback[] acallback = new IProgressCallback[1];
    private AtomicBoolean interruptionRequested = new AtomicBoolean();
    private Map<String, Object> datamap = new ConcurrentHashMap<String, Object>();
    private Map<String, String> errormap = new ConcurrentHashMap<String, String>();
    private Map<String, DecompilationResult> resmap = new ConcurrentHashMap<String, DecompilationResult>();
    private AtomicInteger deferredRequestCount = new AtomicInteger();
    private Map<String, Object> map1 = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> map2 = new ConcurrentHashMap<String, Object>();
    private AtomicInteger counter1 = new AtomicInteger();
    private AtomicInteger counter2 = new AtomicInteger();

    public static DecompilationContext safe(DecompilationContext decompilationContext) {
        return decompilationContext != null ? decompilationContext : new DecompilationContext(DecompilationOptions.DEFAULT);
    }

    public DecompilationContext() {
        this(null);
    }

    public DecompilationContext(DecompilationOptions decompilationOptions) {
        this.opt = DecompilationOptions.safe(decompilationOptions);
    }

    public DecompilationContext(int n2, Long l2, Long l3) {
        this.opt = new DecompilationOptions(n2, l2, l3, null);
    }

    public DecompilationContext(int n2) {
        this(n2, null, null);
    }

    public DecompilationContext fork() {
        DecompilationContext decompilationContext = new DecompilationContext();
        decompilationContext.opt = this.opt;
        decompilationContext.acallback = this.acallback;
        decompilationContext.interruptionRequested = this.interruptionRequested;
        decompilationContext.datamap = this.datamap;
        decompilationContext.errormap = this.errormap;
        decompilationContext.resmap = this.resmap;
        decompilationContext.deferredRequestCount = this.deferredRequestCount;
        decompilationContext.map1 = this.map1;
        decompilationContext.map2 = this.map2;
        decompilationContext.counter1 = this.counter1;
        decompilationContext.counter2 = this.counter2;
        return decompilationContext;
    }

    public DecompilationOptions getOptions() {
        return this.opt;
    }

    public DecompilationOptions setOptions(DecompilationOptions decompilationOptions) {
        if (decompilationOptions == null) {
            throw new IllegalArgumentException();
        }
        DecompilationOptions decompilationOptions2 = this.opt;
        this.opt = decompilationOptions;
        return decompilationOptions2;
    }

    public IProgressCallback getCallback() {
        return this.acallback[0];
    }

    public void setCallback(IProgressCallback iProgressCallback) {
        this.acallback[0] = iProgressCallback;
    }

    public DecompilationOptions addFlags(int n2) {
        return this.setOptions(this.opt.asBuilder().flags(this.opt.getFlags() | n2).build());
    }

    public DecompilationOptions removeFlags(int n2) {
        return this.setOptions(this.opt.asBuilder().flags(this.opt.getFlags() & ~n2).build());
    }

    public int getFlags() {
        return this.opt.getFlags();
    }

    public boolean hasFlags(int n2) {
        return (this.opt.getFlags() & n2) == n2;
    }

    public Long getMaxTimePerMethod() {
        return this.opt.getMaxTimePerMethod();
    }

    public Long getMaxTimeTotal() {
        return this.opt.getMaxTimeTotal();
    }

    public void requestInterruption() {
        this.interruptionRequested.set(true);
    }

    public boolean isInterruptionRequested() {
        return this.interruptionRequested.get();
    }

    public void recordResult(String string, DecompilationResult decompilationResult) {
        if (decompilationResult == null) {
            this.resmap.remove(string);
        } else {
            this.resmap.put(string, decompilationResult);
        }
    }

    public DecompilationResult getResults(String string) {
        return this.resmap.get(string);
    }

    public Map<String, DecompilationResult> getResultMap() {
        return Collections.unmodifiableMap(this.resmap);
    }

    public void recordError(String string, String string2) {
        if (string2 == null) {
            this.errormap.remove(string);
        } else {
            this.errormap.put(string, string2);
        }
    }

    public String getError(String string) {
        return this.errormap.get(string);
    }

    public Map<String, String> getErrorMap() {
        return Collections.unmodifiableMap(this.errormap);
    }

    public boolean hasErrors() {
        return !this.errormap.isEmpty();
    }

    public void putData(String string, Object object) {
        if (object == null) {
            this.datamap.remove(string);
        } else {
            this.datamap.put(string, object);
        }
    }

    public Object getData(String string) {
        return this.datamap.get(string);
    }

    public int recordDeferredRequest() {
        return this.deferredRequestCount.incrementAndGet();
    }

    public boolean recordAndCheckDeferredRequests(int n2, int n3) {
        n2 = this.deferredRequestCount.addAndGet(n2);
        return n3 < 0 || n2 <= n3;
    }

    public Map<String, Object> getMap1() {
        return this.map1;
    }

    public Map<String, Object> getMap2() {
        return this.map2;
    }

    public int getCounter1() {
        return this.counter1.get();
    }

    public int incrementCounter1() {
        return this.counter1.incrementAndGet();
    }

    public int getCounter2() {
        return this.counter2.get();
    }

    public int incrementCounter2() {
        return this.counter2.incrementAndGet();
    }
}

