/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.ICFGOwnerContext;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DFAUtil {
    public static <T extends Number> String formatChain(IDFA<?> iDFA, Map<Integer, Collection<T>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        ICFGOwnerContext iCFGOwnerContext = iDFA.getVariableInformationProvider();
        Map<Integer, Collection<T>> map2 = map instanceof HashMap ? new TreeMap<Integer, Collection<T>>(map) : map;
        int n2 = 0;
        for (int n3 : map2.keySet()) {
            if (n2 > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("(");
            if (iCFGOwnerContext != null) {
                stringBuilder.append(iCFGOwnerContext.getName(n3));
            } else {
                stringBuilder.append((String)(n3 >= 0 ? Integer.toHexString(n3) : "-" + Integer.toHexString(-n3)));
            }
            stringBuilder.append(")={");
            ArrayList<T> arrayList = new ArrayList<T>(map2.get(n3));
            Collections.sort(arrayList, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return Long.compare(((Number)t).longValue(), ((Number)t2).longValue());
                }
            });
            int n4 = 0;
            for (Number number : arrayList) {
                String string;
                if (n4 >= 1) {
                    stringBuilder.append(",");
                }
                if (number instanceof Integer) {
                    string = number.intValue() == -1 ? "other_block" : Integer.toHexString(number.intValue()).toUpperCase();
                    stringBuilder.append(string);
                } else if (number instanceof Long) {
                    string = number.longValue() == -1L ? "init" : Long.toHexString(number.longValue()).toUpperCase();
                    stringBuilder.append("@").append(string);
                }
                ++n4;
            }
            stringBuilder.append("}");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static <T extends Number> String formatVars(IDFA<?> iDFA, Collection<Integer> collection) {
        return DFAUtil.formatVars(iDFA, collection, false);
    }

    public static <T extends Number> String formatVars(IDFA<?> iDFA, Collection<Integer> collection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        ICFGOwnerContext iCFGOwnerContext = iDFA.getVariableInformationProvider();
        Collection<Integer> collection2 = collection;
        if (bl) {
            collection2 = new ArrayList<Integer>();
            ((ArrayList)collection2).sort(null);
        }
        int n2 = 0;
        for (int n3 : collection2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            if (iCFGOwnerContext != null) {
                stringBuilder.append(iCFGOwnerContext.getName(n3));
            } else {
                stringBuilder.append((String)(n3 >= 0 ? Integer.toHexString(n3) : "-" + Integer.toHexString(-n3)));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }
}

