/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.DUI;
import com.pnfsoftware.jeb.core.units.code.DefUseInfo;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.ICFGOwnerContext;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.InstructionFlags;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ArrayList1;
import com.pnfsoftware.jeb.util.collect.CacheMap;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DFA4<InsnType extends IInstruction>
implements IDFA<InsnType> {
    public static final int CACHE_NONE = 0;
    public static final int CACHE_DUI = 1;
    public static final int CACHE_DUI_UDC_DUC = 2;
    private IControlFlowGraph<InsnType, IBasicBlock<InsnType>> cfg;
    private int cachecfg;
    private Map<Long, DUI> duimap;
    private CacheMap<Couple<Long, Integer>, Collection<Long>> cache_getUseDefs;
    private CacheMap<Couple<Long, Integer>, Collection<Long>> cache_getDefUses;
    private int varCollectionFlags;
    private boolean integrateCalculatedInputRegisters;
    private ICFGOwnerContext varInfoProvider;
    private final boolean recordIrrFlows = true;
    private final boolean defaultRecordLiveIn = true;
    private final boolean defaultRecordReachOut = false;
    private boolean alwaysExamineIrregularFlows = false;
    private int defaultMaxBlocks = -1;

    public DFA4(IControlFlowGraph<InsnType, ? extends IBasicBlock<InsnType>> iControlFlowGraph) {
        this(iControlFlowGraph, 3, 1);
    }

    public DFA4(IControlFlowGraph<InsnType, ? extends IBasicBlock<InsnType>> iControlFlowGraph, int n2, int n3) {
        this.cfg = iControlFlowGraph;
        this.varCollectionFlags = n2;
        this.cachecfg = n3;
    }

    @Override
    public void perform() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void invalidate() {
        this.duimap = null;
        this.cache_getDefUses = null;
        this.cache_getUseDefs = null;
    }

    @Override
    public void notifyInstructionUpdate(long l2) {
        if (this.duimap != null) {
            this.duimap.remove(l2);
        }
        this.cache_getDefUses = null;
        this.cache_getUseDefs = null;
    }

    @Override
    public IControlFlowGraph<InsnType, IBasicBlock<InsnType>> getCfg() {
        return this.cfg;
    }

    @Override
    public void setVariableCollectionFlags(int n2) {
        if (n2 != this.varCollectionFlags) {
            this.invalidate();
            this.varCollectionFlags = n2;
        }
    }

    @Override
    public int getVariableCollectionFlags() {
        return this.varCollectionFlags;
    }

    public void setCacheConfiguration(int n2) {
        if (n2 == this.cachecfg) {
            return;
        }
        switch (n2) {
            case 0: {
                this.duimap = null;
                this.cache_getDefUses = null;
                this.cache_getUseDefs = null;
                break;
            }
            case 1: {
                this.cache_getDefUses = null;
                this.cache_getUseDefs = null;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal cache configuration value: " + n2);
            }
        }
        this.cachecfg = n2;
    }

    public int getCacheConfiguration() {
        return this.cachecfg;
    }

    @Override
    public void setIntegrateCalculatedInputRegisters(boolean bl) {
        if (bl != this.integrateCalculatedInputRegisters) {
            this.invalidate();
            this.integrateCalculatedInputRegisters = bl;
        }
    }

    @Override
    public boolean isIntegrateCalculatedInputRegisters() {
        return this.integrateCalculatedInputRegisters;
    }

    public void setAlwaysExamineIrregularFlows(boolean bl) {
        if (bl != this.alwaysExamineIrregularFlows) {
            this.invalidate();
            this.alwaysExamineIrregularFlows = bl;
        }
    }

    public boolean isAlwaysExamineIrregularFlows() {
        return this.alwaysExamineIrregularFlows;
    }

    @Override
    public void setVariableInformationProvider(ICFGOwnerContext iCFGOwnerContext) {
        if (iCFGOwnerContext != this.varInfoProvider) {
            this.invalidate();
            this.varInfoProvider = iCFGOwnerContext;
        }
    }

    @Override
    public ICFGOwnerContext getVariableInformationProvider() {
        return this.varInfoProvider;
    }

    @Override
    public int setMaxBlocks(int n2) {
        int n3 = this.defaultMaxBlocks;
        if (n2 < 0) {
            n2 = -1;
        }
        if (this.defaultMaxBlocks != n2) {
            this.defaultMaxBlocks = n2;
            this.cache_getUseDefs = null;
            this.cache_getDefUses = null;
        }
        return n3;
    }

    @Override
    public int getMaxBlocks() {
        return this.defaultMaxBlocks;
    }

    public String formatDUI(DUI dUI) {
        StringBuilder stringBuilder = new StringBuilder();
        this.formatVars("uses", dUI.getUse(), stringBuilder);
        this.formatVars("uses-maybe", dUI.getUsePot(), stringBuilder);
        this.formatVars("defs", dUI.getDef(), stringBuilder);
        this.formatVars("defs-maybe", dUI.getDefPot(), stringBuilder);
        this.formatVars("spoiled", dUI.getSpoiled(), stringBuilder);
        return stringBuilder.toString();
    }

    private void formatVars(String string, Collection<Integer> collection, StringBuilder stringBuilder) {
        stringBuilder.append(string).append(": ");
        for (int n2 : collection) {
            if (this.varInfoProvider == null) {
                Strings.ff("r%X", n2);
            } else {
                stringBuilder.append(this.varInfoProvider.getName(n2));
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append('\n');
    }

    @Override
    public DUI getDUI(long l2) {
        return this.getDUI(l2, null);
    }

    @Override
    public DUI getDUI(AddressableInstruction<InsnType> addressableInstruction) {
        return this.getDUI(addressableInstruction.getOffset(), addressableInstruction.getInstruction());
    }

    @Override
    public DUI getDUI(long l2, InsnType InsnType) {
        ArrayList<Integer> arrayList;
        Object object;
        List<Integer> list;
        if (this.cachecfg >= 1) {
            if (this.duimap == null) {
                this.duimap = new HashMap<Long, DUI>();
            }
            if ((list = this.duimap.get(l2)) != null) {
                return list;
            }
        }
        if (InsnType == null) {
            InsnType = this.cfg.getInstruction(l2);
        }
        List<Object> list2 = Collections.emptyList();
        List<Integer> list3 = Collections.emptyList();
        List<Integer> list4 = Collections.emptyList();
        try {
            object = InsnType.getDefUseInfo(l2, this.varCollectionFlags);
            list = ((DefUseInfo)object).def.getVarIds();
            arrayList = ((DefUseInfo)object).use.getVarIds();
            if (((DefUseInfo)object).defpot != null) {
                list2 = ((DefUseInfo)object).defpot.getVarIds();
                list2.removeAll(list);
            }
            if (((DefUseInfo)object).usepot != null) {
                list3 = ((DefUseInfo)object).usepot.getVarIds();
                list3.removeAll(arrayList);
            }
            if (((DefUseInfo)object).spoiled != null) {
                list4 = ((DefUseInfo)object).spoiled.getVarIds();
                list4.removeAll(list);
                list4.removeAll(list2);
            }
        }
        catch (Exception exception) {
            if (Licensing.isDebugBuild()) {
                throw new RuntimeException("getDefUse() failed!", exception);
            }
            list = new ArrayList();
            arrayList = new ArrayList();
            InsnType.getDefUse(list, arrayList);
        }
        object = new DUI(list, arrayList, list2, list3, list4);
        if (this.duimap != null) {
            this.duimap.put(l2, (DUI)object);
        }
        return object;
    }

    public Collection<Long> getUseDefs(long l2, int n2, int n3, boolean bl, boolean bl2, IBasicBlock<InsnType> iBasicBlock, int n4, boolean[] blArray, boolean bl3, int n5, boolean bl4) {
        DUI dUI;
        Object object;
        Couple<IBasicBlock<InsnType>, Integer> couple;
        int n6;
        IBasicBlock iBasicBlock2;
        if (iBasicBlock != null) {
            Assert.a(!bl);
            Assert.a(!bl4);
            if (n4 < 0 || n4 > iBasicBlock.size()) {
                throw new IllegalArgumentException("Invalid instruction index for block: " + n4);
            }
            iBasicBlock2 = iBasicBlock;
            n6 = n4;
        } else {
            couple = this.cfg.getInstructionLocation(l2);
            if (couple == null) {
                throw new IllegalArgumentException(Strings.ff("Address does not refer to an instruction: %X", l2));
            }
            iBasicBlock2 = couple.getFirst();
            n6 = couple.getSecond();
            if (bl) {
                object = iBasicBlock2.get(n6);
                dUI = this.getDUI(l2, object);
                if (!dUI.use.contains(n2) && !dUI.usepot.contains(n2)) {
                    return null;
                }
            }
        }
        if (n3 <= 0) {
            n3 = Integer.MAX_VALUE;
        }
        couple = new ArrayList();
        object = new HashSet();
        ArrayList arrayList = new ArrayList();
        HashSet<Long> hashSet = new HashSet<Long>();
        boolean bl5 = true;
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
        boolean bl6 = false;
        IBasicBlock<InsnType> iBasicBlock3 = this.cfg.getEntryBlock();
        block0: while (true) {
            boolean bl7;
            int n7;
            int n8;
            IBasicBlock iBasicBlock4;
            if (bl5) {
                bl5 = false;
                iBasicBlock4 = iBasicBlock2;
                n8 = n6 - 1;
                n7 = 0;
                bl7 = false;
            } else if (!couple.isEmpty()) {
                iBasicBlock4 = (IBasicBlock)couple.remove(0);
                if (!object.add(iBasicBlock4.getBase())) continue;
                n8 = iBasicBlock4.size() - 1;
                n7 = iBasicBlock4 == iBasicBlock2 ? n6 : 0;
                bl7 = false;
            } else {
                if (arrayList == null || arrayList.isEmpty()) break;
                iBasicBlock4 = (IBasicBlock)arrayList.remove(0);
                if (!hashSet.add(iBasicBlock4.getBase())) continue;
                n8 = iBasicBlock4.size() - 1;
                n7 = iBasicBlock4 == iBasicBlock2 ? n6 : 0;
                bl7 = true;
            }
            if (n5-- == 0) {
                linkedHashSet.add(-2L);
                break;
            }
            if (n8 >= n7) {
                int n9;
                int n10;
                boolean bl8 = false;
                boolean[] blArray2 = new boolean[n8 + 1];
                for (n10 = n8; n10 >= n7; --n10) {
                    n9 = iBasicBlock4.get(n10).canThrow();
                    if (n9 == 0) continue;
                    bl8 = true;
                    blArray2[n10] = true;
                }
                n10 = 0;
                if (!bl8 && this.alwaysExamineIrregularFlows) {
                    n10 = 1;
                }
                l2 = iBasicBlock4.getAddressOfInstruction(n8) + (long)iBasicBlock4.get(n8).getSize();
                for (n9 = n8; n9 >= n7; --n9) {
                    Object InsnType = iBasicBlock4.get(n9);
                    dUI = this.getDUI(l2 -= (long)InsnType.getSize(), InsnType);
                    if (!bl7) {
                        if (dUI.def.contains(n2)) {
                            if (bl4 && iBasicBlock4 != iBasicBlock2) {
                                linkedHashSet.add(-2L);
                                break block0;
                            }
                            linkedHashSet.add(l2);
                            if (linkedHashSet.size() < n3) continue block0;
                            break block0;
                        }
                        if (dUI.defpot.contains(n2)) {
                            if (bl4 && iBasicBlock4 != iBasicBlock2) {
                                linkedHashSet.add(-2L);
                                break block0;
                            }
                            linkedHashSet.add(l2);
                            if (linkedHashSet.size() >= n3) break block0;
                        }
                        if (!dUI.spoiled.contains(n2)) continue;
                        if (blArray != null) {
                            blArray[0] = true;
                            break block0;
                        }
                        if (bl3) {
                            if (bl4 && iBasicBlock4 != iBasicBlock2) {
                                linkedHashSet.add(-2L);
                                break block0;
                            }
                            linkedHashSet.add(l2);
                        }
                        if (linkedHashSet.size() < n3) continue block0;
                        break block0;
                    }
                    if (n10 != 0) {
                        if (!dUI.def.contains(n2) && !dUI.defpot.contains(n2) && (!bl3 || !dUI.spoiled.contains(n2))) continue;
                        if (bl4 && iBasicBlock4 != iBasicBlock2) {
                            linkedHashSet.add(-2L);
                            break block0;
                        }
                        linkedHashSet.add(l2);
                        if (linkedHashSet.size() >= n3) break block0;
                        n10 = blArray2[n9];
                        continue;
                    }
                    if (!blArray2[n9]) continue;
                    n10 = 1;
                }
                if (bl7 && n10 == 0) continue;
            }
            if ((iBasicBlock4.insize() == 0 && iBasicBlock4.irrinsize() == 0 || iBasicBlock4 == iBasicBlock3) && bl2 && !bl6) {
                bl6 = true;
                linkedHashSet.add(-1L);
                if (linkedHashSet.size() >= n3) break;
            }
            couple.addAll(iBasicBlock4.getInputs());
            arrayList.addAll(iBasicBlock4.getIrregularInputs());
        }
        return linkedHashSet;
    }

    @Override
    public Collection<Long> getUseDefs(long l2, int n2) {
        Collection<Long> collection;
        Couple<Long, Integer> couple = null;
        if (this.cachecfg >= 2) {
            couple = new Couple<Long, Integer>(l2, n2);
            if (this.cache_getUseDefs == null) {
                this.cache_getUseDefs = new CacheMap(100);
            } else {
                collection = this.cache_getUseDefs.get(couple);
                if (collection != null) {
                    return collection;
                }
            }
        }
        collection = this.getUseDefs(l2, n2, -1, true, true, null, -1, null, false, this.defaultMaxBlocks, false);
        if (couple != null) {
            this.cache_getUseDefs.put(couple, collection);
        }
        return collection;
    }

    @Override
    public Collection<Long> getUseDefs(long l2, int n2, int n3) {
        return this.getUseDefs(l2, n2, n3, true, true, null, -1, null, false, this.defaultMaxBlocks, false);
    }

    @Override
    public Collection<Long> getBlockUseDefs(long l2, int n2) {
        return this.getUseDefs(l2, n2, -1, true, false, null, -1, null, false, -1, true);
    }

    @Override
    public boolean isTerminator(IBasicBlock<InsnType> iBasicBlock) {
        return iBasicBlock.outsize() == 0 && iBasicBlock.getLast().getInstructionFlags().contains((Object)InstructionFlags.ROUTINE_TERMINATOR);
    }

    public Collection<Long> getDefUses(long l2, int n2, int n3, boolean bl, boolean bl2, IBasicBlock<InsnType> iBasicBlock, int n4, int n5, boolean bl3) {
        DUI dUI;
        Object object;
        Couple<IBasicBlock<InsnType>, Integer> couple;
        int n6;
        IBasicBlock iBasicBlock2;
        if (iBasicBlock != null) {
            Assert.a(!bl);
            Assert.a(!bl3);
            if (n4 < 0 || n4 > iBasicBlock.size()) {
                throw new IllegalArgumentException("Invalid instruction index for block: " + n4);
            }
            iBasicBlock2 = iBasicBlock;
            n6 = n4 - 1;
        } else {
            couple = this.cfg.getInstructionLocation(l2);
            if (couple == null) {
                throw new IllegalArgumentException(Strings.ff("Address does not refer to an instruction: %X", l2));
            }
            iBasicBlock2 = couple.getFirst();
            n6 = couple.getSecond();
            if (bl) {
                object = iBasicBlock2.get(n6);
                dUI = this.getDUI(l2, object);
                if (!dUI.def.contains(n2) && !dUI.defpot.contains(n2)) {
                    return null;
                }
            }
        }
        if (n3 <= 0) {
            n3 = Integer.MAX_VALUE;
        }
        couple = new ArrayList();
        object = new HashSet();
        boolean bl4 = true;
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
        boolean bl5 = false;
        block0: while (bl4 || !couple.isEmpty()) {
            int n7;
            int n8;
            IBasicBlock iBasicBlock3;
            if (bl4) {
                bl4 = false;
                iBasicBlock3 = iBasicBlock2;
                n8 = n6 + 1;
                n7 = iBasicBlock3.size() - 1;
            } else {
                iBasicBlock3 = (IBasicBlock)couple.remove(0);
                if (!object.add(iBasicBlock3.getBase())) continue;
                n8 = 0;
                n7 = iBasicBlock3 == iBasicBlock2 ? n6 : iBasicBlock3.size() - 1;
            }
            if (n5-- == 0) {
                linkedHashSet.add(-2L);
                break;
            }
            boolean bl6 = false;
            boolean bl7 = false;
            if (n8 <= n7) {
                int n9;
                boolean bl8 = false;
                boolean[] blArray = new boolean[n7 + 1];
                for (n9 = n8; n9 <= n7; ++n9) {
                    boolean bl9 = iBasicBlock3.get(n9).canThrow();
                    if (!bl9) continue;
                    bl8 = true;
                    blArray[n9] = true;
                }
                if (!bl8 && this.alwaysExamineIrregularFlows) {
                    bl7 = true;
                }
                l2 = iBasicBlock3.getAddressOfInstruction(n8);
                for (n9 = n8; n9 <= n7; ++n9) {
                    Object InsnType = iBasicBlock3.get(n9);
                    dUI = this.getDUI(l2, InsnType);
                    if (dUI.use.contains(n2) || dUI.usepot.contains(n2)) {
                        if (bl3 && iBasicBlock3 != iBasicBlock2) {
                            linkedHashSet.add(-2L);
                            break block0;
                        }
                        linkedHashSet.add(l2);
                        if (linkedHashSet.size() >= n3) break block0;
                    }
                    if (!bl7 && blArray[n9]) {
                        bl7 = true;
                    }
                    if (dUI.def.contains(n2) || dUI.spoiled.contains(n2)) {
                        if (!bl7 || iBasicBlock3.irroutsize() == 0) continue block0;
                        bl6 = true;
                        break;
                    }
                    l2 += (long)InsnType.getSize();
                }
            }
            if (!bl6) {
                if (iBasicBlock3.outsize() == 0) {
                    if (bl2 && !this.isTerminator(iBasicBlock3) && !bl5) {
                        bl5 = true;
                        linkedHashSet.add(-1L);
                        if (linkedHashSet.size() >= n3) {
                            break;
                        }
                    }
                } else {
                    couple.addAll(iBasicBlock3.getOutputs());
                }
            }
            if (!bl7) continue;
            couple.addAll(iBasicBlock3.getIrregularOutputs());
        }
        return linkedHashSet;
    }

    @Override
    public Collection<Long> getDefUses(long l2, int n2) {
        Collection<Long> collection;
        Couple<Long, Integer> couple = null;
        if (this.cachecfg >= 2) {
            couple = new Couple<Long, Integer>(l2, n2);
            if (this.cache_getDefUses == null) {
                this.cache_getDefUses = new CacheMap(100);
            } else {
                collection = this.cache_getDefUses.get(couple);
                if (collection != null) {
                    return collection;
                }
            }
        }
        collection = this.getDefUses(l2, n2, -1, true, false, null, -1, this.defaultMaxBlocks, false);
        if (couple != null) {
            this.cache_getDefUses.put(couple, collection);
        }
        return collection;
    }

    @Override
    public Collection<Long> getDefUses(long l2, int n2, int n3) {
        return this.getDefUses(l2, n2, n3, true, false, null, -1, this.defaultMaxBlocks, false);
    }

    @Override
    public Collection<Long> getDefUses(long l2, int n2, int n3, boolean bl) {
        return this.getDefUses(l2, n2, n3, true, bl, null, -1, this.defaultMaxBlocks, false);
    }

    @Override
    public Collection<Long> getBlockDefUses(long l2, int n2) {
        return this.getDefUses(l2, n2, -1, true, false, null, -1, -1, true);
    }

    @Override
    public int checkNoUse(long l2, int n2, boolean bl, int n3) {
        Collection<Long> collection = this.getDefUses(l2, n2, 1, true, bl, null, -1, n3, false);
        if (collection == null) {
            return -3;
        }
        if (collection.isEmpty()) {
            return 0;
        }
        Assert.a(collection.size() == 1);
        long l3 = collection.iterator().next();
        if (l3 == -1L) {
            return -1;
        }
        if (l3 == -2L) {
            return -2;
        }
        return 1;
    }

    @Override
    public boolean checkNoUse(long l2, int n2, boolean bl) {
        return this.checkNoUse(l2, n2, bl, this.defaultMaxBlocks) == 0;
    }

    @Override
    public boolean checkNoUse(long l2, int n2) {
        return this.checkNoUse(l2, n2, true, this.defaultMaxBlocks) == 0;
    }

    public Long checkSingleUse(long l2, int n2, boolean bl) {
        Collection<Long> collection = this.getDefUses(l2, n2, 2, true, bl, null, -1, this.defaultMaxBlocks, false);
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    @Override
    public Long checkSingleUse(long l2, int n2) {
        return this.checkSingleUse(l2, n2, true);
    }

    public Long checkSingleDef(long l2, int n2, boolean bl) {
        Collection<Long> collection = this.getUseDefs(l2, n2, 2, true, bl, null, -1, null, false, this.defaultMaxBlocks, false);
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    @Override
    public Long checkSingleDefNoInput(long l2, int n2) {
        return this.checkSingleDef(l2, n2, false);
    }

    @Override
    public Long checkSingleDef(long l2, int n2) {
        return this.checkSingleDef(l2, n2, true);
    }

    @Override
    public Long checkSingleSource(long l2, int n2, boolean bl) {
        Collection<Long> collection = this.getUseDefs(l2, n2, 2, false, bl, null, -1, null, false, this.defaultMaxBlocks, false);
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    @Override
    public Long checkSingleSource(long l2, int n2) {
        return this.checkSingleSource(l2, n2, true);
    }

    @Override
    public void collectInstructionAllDefs(long l2, Collection<Integer> collection) {
        DUI dUI = this.getDUI(l2);
        collection.addAll(dUI.def);
        collection.addAll(dUI.defpot);
        collection.addAll(dUI.spoiled);
    }

    @Override
    public void collectInstructionAllUses(long l2, Collection<Integer> collection) {
        DUI dUI = this.getDUI(l2);
        collection.addAll(dUI.use);
        collection.addAll(dUI.usepot);
    }

    public Set<Integer> getInstructionAllDefs(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.def);
        hashSet.addAll(dUI.defpot);
        hashSet.addAll(dUI.spoiled);
        return hashSet;
    }

    public Set<Integer> getInstructionAllUses(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.use);
        hashSet.addAll(dUI.usepot);
        return hashSet;
    }

    public Set<Integer> getInstructionDefs(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.def);
        return hashSet;
    }

    public Set<Integer> getInstructionUses(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.use);
        return hashSet;
    }

    public Set<Integer> getInstructionPotentialDefs(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.defpot);
        return hashSet;
    }

    public Set<Integer> getInstructionPotentialUses(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.usepot);
        return hashSet;
    }

    public Set<Integer> getInstructionSpoiledDefs(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.spoiled);
        return hashSet;
    }

    private Set<Integer> collectVarUses(IBasicBlock<InsnType> iBasicBlock) {
        LinkedHashSet<Integer> linkedHashSet;
        if (iBasicBlock != null) {
            linkedHashSet = new LinkedHashSet();
            ArrayList arrayList = new ArrayList();
            arrayList.add(iBasicBlock);
            HashSet<Long> hashSet = new HashSet<Long>();
            while (!arrayList.isEmpty()) {
                IBasicBlock iBasicBlock2 = (IBasicBlock)arrayList.remove(0);
                if (!hashSet.add(iBasicBlock2.getBase())) continue;
                long l2 = iBasicBlock2.getBase();
                for (int i = 0; i < iBasicBlock2.size(); ++i) {
                    Object InsnType = iBasicBlock2.get(i);
                    DUI dUI = this.getDUI(l2, InsnType);
                    linkedHashSet.addAll(dUI.use);
                    linkedHashSet.addAll(dUI.usepot);
                    l2 += (long)InsnType.getSize();
                }
                arrayList.addAll(iBasicBlock2.getOutputs());
                arrayList.addAll(iBasicBlock2.getIrregularOutputs());
            }
        } else {
            linkedHashSet = new HashSet();
            for (AddressableInstruction<InsnType> addressableInstruction : this.cfg.addressableInstructions()) {
                DUI dUI = this.getDUI(addressableInstruction);
                linkedHashSet.addAll(dUI.use);
                linkedHashSet.addAll(dUI.usepot);
            }
        }
        return linkedHashSet;
    }

    private Set<Integer> collectVarUses() {
        return this.collectVarUses(null);
    }

    private Set<Integer> collectVarDefs(IBasicBlock<InsnType> iBasicBlock) {
        LinkedHashSet<Integer> linkedHashSet;
        if (iBasicBlock != null) {
            linkedHashSet = new LinkedHashSet();
            ArrayList arrayList = new ArrayList();
            arrayList.add(iBasicBlock);
            HashSet<Long> hashSet = new HashSet<Long>();
            while (!arrayList.isEmpty()) {
                IBasicBlock iBasicBlock2 = (IBasicBlock)arrayList.remove(0);
                if (!hashSet.add(iBasicBlock2.getBase())) continue;
                long l2 = iBasicBlock2.getEndAddress();
                for (int i = iBasicBlock2.size() - 1; i >= 0; --i) {
                    Object InsnType = iBasicBlock2.get(i);
                    DUI dUI = this.getDUI(l2 -= (long)InsnType.getSize(), InsnType);
                    linkedHashSet.addAll(dUI.def);
                    linkedHashSet.addAll(dUI.defpot);
                    linkedHashSet.addAll(dUI.spoiled);
                }
                arrayList.addAll(iBasicBlock2.getInputs());
                arrayList.addAll(iBasicBlock2.getIrregularInputs());
            }
        } else {
            linkedHashSet = new HashSet();
            for (AddressableInstruction<InsnType> addressableInstruction : this.cfg.addressableInstructions()) {
                DUI dUI = this.getDUI(addressableInstruction);
                linkedHashSet.addAll(dUI.def);
                linkedHashSet.addAll(dUI.defpot);
                linkedHashSet.addAll(dUI.spoiled);
            }
        }
        return linkedHashSet;
    }

    private Set<Integer> collectVarDefs() {
        return this.collectVarDefs(null);
    }

    public Map<Integer, Collection<Long>> getUseDefChains(long l2, boolean bl) {
        Collection collection = this.getInstructionAllUses(l2);
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Collection<Long> collection2 = this.getUseDefs(l2, n2, -1, false, bl, null, -1, null, false, this.defaultMaxBlocks, false);
            hashMap.put(n2, collection2);
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Collection<Long>> getUseDefChains(long l2) {
        return this.getUseDefChains(l2, true);
    }

    public Map<Integer, Collection<Long>> getDefUseChains(long l2, boolean bl) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.def);
        hashSet.addAll(dUI.defpot);
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Collection<Long> collection = this.getDefUses(l2, n2, -1, false, bl, null, -1, this.defaultMaxBlocks, false);
            hashMap.put(n2, collection);
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Collection<Long>> getDefUseChains(long l2) {
        return this.getDefUseChains(l2, false);
    }

    public Map<Integer, Collection<Long>> getLiveChains(IBasicBlock<InsnType> iBasicBlock, int n2, Collection<Integer> collection) {
        if (collection == null) {
            collection = this.collectVarUses();
        }
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        for (int n3 : collection) {
            Collection<Long> collection2 = this.getDefUses(-1L, n3, -1, false, false, iBasicBlock, n2, this.defaultMaxBlocks, false);
            if (collection2.isEmpty()) continue;
            hashMap.put(n3, collection2);
        }
        return hashMap;
    }

    @Override
    public Collection<Long> getLiveChains(IBasicBlock<InsnType> iBasicBlock, int n2, int n3) {
        return this.getLiveChains(iBasicBlock, n2, new ArrayList1<Integer>(n3)).getOrDefault(n3, Collections.emptySet());
    }

    @Override
    public Map<Integer, Collection<Long>> getLiveChains(IBasicBlock<InsnType> iBasicBlock, int n2) {
        return this.getLiveChains(iBasicBlock, n2, null);
    }

    @Override
    public boolean isAlive(IBasicBlock<InsnType> iBasicBlock, int n2, int n3) {
        return !this.getDefUses(-1L, n3, 1, false, false, iBasicBlock, n2, this.defaultMaxBlocks, false).isEmpty();
    }

    public Map<Integer, Collection<Long>> getReachChains(IBasicBlock<InsnType> iBasicBlock, int n2, Collection<Integer> collection) {
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        if (n2 == iBasicBlock.size() && this.isTerminator(iBasicBlock)) {
            return hashMap;
        }
        Collection<Integer> collection2 = null;
        if (this.integrateCalculatedInputRegisters) {
            collection2 = this.getInputs();
        }
        if (collection == null) {
            collection = this.collectVarDefs();
            if (collection2 != null) {
                collection.addAll(collection2);
            }
        }
        for (int n3 : collection) {
            boolean bl;
            Collection<Long> collection3 = this.getUseDefs(-1L, n3, -1, false, bl = collection2 != null && collection2.contains(n3), iBasicBlock, n2, null, false, this.defaultMaxBlocks, false);
            if (collection3.isEmpty()) continue;
            hashMap.put(n3, collection3);
        }
        return hashMap;
    }

    @Override
    public Collection<Long> getReachChains(IBasicBlock<InsnType> iBasicBlock, int n2, int n3) {
        return this.getReachChains(iBasicBlock, n2, new ArrayList1<Integer>(n3)).getOrDefault(n3, Collections.emptySet());
    }

    @Override
    public Map<Integer, Collection<Long>> getReachChains(IBasicBlock<InsnType> iBasicBlock, int n2) {
        return this.getReachChains(iBasicBlock, n2, null);
    }

    @Override
    public boolean isReaching(IBasicBlock<InsnType> iBasicBlock, int n2, int n3) {
        throw new RuntimeException("TO BE IMPLEMENTED");
    }

    @Override
    public Collection<Integer> getUseDiscrepancies(long l2) {
        DUI dUI = this.getDUI(l2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(dUI.use);
        hashSet.addAll(dUI.usepot);
        boolean[] blArray = new boolean[1];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            blArray[0] = false;
            Collection<Long> collection = this.getUseDefs(l2, n2, -1, false, true, null, -1, blArray, false, this.defaultMaxBlocks, false);
            if (!blArray[0] && !collection.isEmpty()) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public boolean isUseDiscrepancy(long l2, int n2) {
        boolean[] blArray = new boolean[1];
        Collection<Long> collection = this.getUseDefs(l2, n2, -1, true, true, null, -1, blArray, false, this.defaultMaxBlocks, false);
        return blArray[0] || collection.isEmpty();
    }

    public boolean checkInput(int n2) {
        return this.filterInputs(new ArrayList1<Integer>(n2)).contains(n2);
    }

    @Override
    public Collection<Integer> getInputs() {
        return this.filterInputs(null);
    }

    public Collection<Integer> filterInputs(Collection<Integer> collection) {
        IBasicBlock<InsnType> iBasicBlock = this.cfg.getEntryBlock();
        if (collection == null) {
            collection = this.collectVarUses(iBasicBlock);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : collection) {
            Collection<Long> collection2 = this.getDefUses(-1L, n2, 1, false, false, iBasicBlock, 0, this.defaultMaxBlocks, false);
            if (collection2.isEmpty()) continue;
            arrayList.add(0, n2);
        }
        return arrayList;
    }

    public Map<Integer, Collection<Long>> getInputsWithUses() {
        return this.filterInputsWithUses(null);
    }

    public Collection<Long> checkInputWithUses(int n2) {
        return this.filterInputsWithUses(new ArrayList1<Integer>(n2)).getOrDefault(n2, Collections.emptySet());
    }

    public Map<Integer, Collection<Long>> filterInputsWithUses(Collection<Integer> collection) {
        IBasicBlock<InsnType> iBasicBlock = this.cfg.getEntryBlock();
        if (collection == null) {
            collection = this.collectVarUses();
        }
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        for (int n2 : collection) {
            Collection<Long> collection2 = this.getDefUses(-1L, n2, -1, false, false, iBasicBlock, 0, this.defaultMaxBlocks, false);
            if (collection2.isEmpty()) continue;
            hashMap.put(n2, collection2);
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Collection<Long>> getInputMap() {
        return this.getInputsWithUses();
    }

    @Override
    public Collection<Long> getInputMap(int n2) {
        return this.checkInputWithUses(n2);
    }

    public boolean checkOutput(IBasicBlock<InsnType> iBasicBlock, int n2) {
        return this.filterOutputs(iBasicBlock, new ArrayList1<Integer>(n2)).contains(n2);
    }

    @Override
    public Collection<Integer> getOutputs(IBasicBlock<InsnType> iBasicBlock) {
        return this.filterOutputs(iBasicBlock, null);
    }

    public Collection<Integer> filterOutputs(IBasicBlock<InsnType> iBasicBlock, Collection<Integer> collection) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.isTerminator(iBasicBlock)) {
            return arrayList;
        }
        Collection<Integer> collection2 = null;
        if (this.integrateCalculatedInputRegisters) {
            collection2 = this.getInputs();
        }
        if (collection == null) {
            collection = this.collectVarDefs(iBasicBlock);
            if (collection2 != null) {
                collection.addAll(collection2);
            }
        }
        for (int n2 : collection) {
            boolean bl;
            Collection<Long> collection3 = this.getUseDefs(-1L, n2, 1, false, bl = collection2 != null && collection2.contains(n2), iBasicBlock, iBasicBlock.size(), null, true, this.defaultMaxBlocks, false);
            if (collection3.isEmpty()) continue;
            arrayList.add(0, n2);
        }
        return arrayList;
    }

    public Map<Integer, Collection<Long>> getOutputsWithDefs(IBasicBlock<InsnType> iBasicBlock) {
        return this.filterOutputsWithDefs(iBasicBlock, null);
    }

    public Collection<Long> checkOutputsWithDefs(IBasicBlock<InsnType> iBasicBlock, int n2) {
        return this.filterOutputsWithDefs(iBasicBlock, new ArrayList1<Integer>(n2)).getOrDefault(n2, Collections.emptySet());
    }

    public Map<Integer, Collection<Long>> filterOutputsWithDefs(IBasicBlock<InsnType> iBasicBlock, Collection<Integer> collection) {
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        if (this.isTerminator(iBasicBlock)) {
            return hashMap;
        }
        Collection<Integer> collection2 = null;
        if (this.integrateCalculatedInputRegisters) {
            collection2 = this.getInputs();
        }
        if (collection == null) {
            collection = this.collectVarDefs();
            if (collection2 != null) {
                collection.addAll(collection2);
            }
        }
        for (int n2 : collection) {
            boolean bl;
            Collection<Long> collection3 = this.getUseDefs(-1L, n2, -1, false, bl = collection2 != null && collection2.contains(n2), iBasicBlock, iBasicBlock.size(), null, true, this.defaultMaxBlocks, false);
            if (collection3.isEmpty()) continue;
            hashMap.put(n2, collection3);
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Collection<Long>> getOutputMap(IBasicBlock<InsnType> iBasicBlock) {
        return this.getOutputsWithDefs(iBasicBlock);
    }

    @Override
    public Collection<Long> getOutputMap(IBasicBlock<InsnType> iBasicBlock, int n2) {
        return this.checkOutputsWithDefs(iBasicBlock, n2);
    }

    public boolean checkOutput(int n2) {
        return this.filterOutputs(new ArrayList1<Integer>(n2)).contains(n2);
    }

    @Override
    public Collection<Integer> getOutputs() {
        return this.filterOutputs(null);
    }

    public Collection<Integer> filterOutputs(Collection<Integer> collection) {
        Collection<Integer> collection2 = null;
        if (this.integrateCalculatedInputRegisters) {
            collection2 = this.getInputs();
        }
        if (collection == null) {
            collection = this.collectVarDefs();
            if (collection2 != null) {
                collection.addAll(collection2);
            }
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (IBasicBlock<InsnType> iBasicBlock : this.cfg.getExitBlocks()) {
            if (this.isTerminator(iBasicBlock)) continue;
            for (int n2 : collection) {
                boolean bl;
                Collection<Long> collection3 = this.getUseDefs(-1L, n2, 1, false, bl = collection2 != null && collection2.contains(n2), iBasicBlock, iBasicBlock.size(), null, true, this.defaultMaxBlocks, false);
                if (collection3.isEmpty()) continue;
                hashSet.add(n2);
            }
            if (!collection.removeAll(hashSet) || !collection.isEmpty()) continue;
            break;
        }
        return hashSet;
    }

    public Map<Integer, Collection<Long>> getOutputsWithDefs() {
        return this.filterOutputsWithDefs(null);
    }

    public Collection<Long> checkOutputsWithDefs(int n2) {
        return this.filterOutputsWithDefs(new ArrayList1<Integer>(n2)).getOrDefault(n2, Collections.emptySet());
    }

    public Map<Integer, Collection<Long>> filterOutputsWithDefs(Collection<Integer> collection) {
        Collection<Integer> collection2 = null;
        if (this.integrateCalculatedInputRegisters) {
            collection2 = this.getInputs();
        }
        if (collection == null) {
            collection = this.collectVarDefs();
            if (collection2 != null) {
                collection.addAll(collection2);
            }
        }
        HashMap<Integer, Collection<Long>> hashMap = new HashMap<Integer, Collection<Long>>();
        for (IBasicBlock<InsnType> iBasicBlock : this.cfg.getExitBlocks()) {
            if (this.isTerminator(iBasicBlock)) continue;
            for (Integer n2 : collection) {
                boolean bl;
                boolean bl2 = bl = collection2 != null && collection2.contains(n2);
                Collection<Long> collection3 = this.getUseDefs(-1L, n2, -1, false, bl, iBasicBlock, iBasicBlock.size(), null, true, this.defaultMaxBlocks, false);
                if (collection3.isEmpty()) continue;
                HashSet<Long> hashSet = (HashSet<Long>)hashMap.get(n2);
                if (hashSet == null) {
                    hashSet = new HashSet<Long>();
                    hashMap.put(n2, hashSet);
                }
                hashSet.addAll(collection3);
            }
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Collection<Long>> getOutputMap() {
        return this.getOutputsWithDefs();
    }

    @Override
    public Collection<Long> getOutputMap(int n2) {
        return this.checkOutputsWithDefs(n2);
    }

    @Override
    public boolean isNotRedefined(int n2, long l2, long l3) {
        Couple<IBasicBlock<InsnType>, Integer> couple = this.cfg.getInstructionLocation(l2);
        Couple<IBasicBlock<InsnType>, Integer> couple2 = this.cfg.getInstructionLocation(l3);
        return this.isNotRedefined(n2, couple.getFirst(), couple.getSecond(), couple2.getFirst(), couple2.getSecond());
    }

    @Override
    public boolean isNotRedefined(int n2, IBasicBlock<InsnType> iBasicBlock, int n3, IBasicBlock<InsnType> iBasicBlock2, int n4) {
        return this.isVarReachingFromTo(n2, iBasicBlock, n3, iBasicBlock2, n4, false, -1);
    }

    @Override
    public Boolean isVarReachingFromTo(int n2, long l2, long l3) {
        Couple<IBasicBlock<InsnType>, Integer> couple = this.cfg.getInstructionLocation(l2);
        Couple<IBasicBlock<InsnType>, Integer> couple2 = this.cfg.getInstructionLocation(l3);
        return this.isVarReachingFromTo(n2, couple.getFirst(), couple.getSecond(), couple2.getFirst(), couple2.getSecond());
    }

    @Override
    public Boolean isVarReachingFromTo(int n2, IBasicBlock<InsnType> iBasicBlock, int n3, IBasicBlock<InsnType> iBasicBlock2, int n4) {
        return this.isVarReachingFromTo(n2, iBasicBlock, n3, iBasicBlock2, n4, true, -1);
    }

    private Boolean isVarReachingFromTo(int n2, IBasicBlock<InsnType> iBasicBlock, int n3, IBasicBlock<InsnType> iBasicBlock2, int n4, boolean bl, int n5) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(iBasicBlock);
        HashSet<Long> hashSet = new HashSet<Long>();
        ArrayList<IBasicBlock<InsnType>> arrayList2 = new ArrayList<IBasicBlock<InsnType>>();
        int n6 = 0;
        int n7 = n3 + 1;
        while (!arrayList.isEmpty()) {
            long l2;
            IBasicBlock iBasicBlock3 = (IBasicBlock)arrayList.remove(0);
            if (n6 > 0 && !hashSet.add(iBasicBlock3.getBase())) continue;
            if (n5-- == 0) {
                return null;
            }
            int n8 = iBasicBlock3.size();
            if (iBasicBlock3 == iBasicBlock2) {
                n8 = n4;
            }
            long l3 = l2 = n7 < n8 ? iBasicBlock3.getAddressOfInstruction(n7) : -1L;
            while (n7 < n8) {
                Object InsnType = iBasicBlock3.get(n7);
                DUI dUI = this.getDUI(l2, InsnType);
                if (dUI.def.contains(n2) || dUI.defpot.contains(n2) || dUI.spoiled.contains(n2)) {
                    if (!bl || iBasicBlock3 == iBasicBlock || iBasicBlock3 == iBasicBlock2) {
                        return false;
                    }
                    arrayList2.add(iBasicBlock3);
                    break;
                }
                l2 += (long)InsnType.getSize();
                ++n7;
            }
            n7 = 0;
            if (iBasicBlock3 != iBasicBlock2) {
                arrayList.addAll(iBasicBlock3.getOutputs());
                arrayList.addAll(iBasicBlock3.getIrregularOutputs());
            }
            ++n6;
        }
        if (!arrayList2.isEmpty() && !this.verifyRedef(iBasicBlock, iBasicBlock2, arrayList2)) {
            return false;
        }
        return true;
    }

    private boolean verifyRedef(IBasicBlock<InsnType> iBasicBlock, IBasicBlock<InsnType> iBasicBlock2, List<IBasicBlock<InsnType>> list) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (IBasicBlock<InsnType> iBasicBlock3 : list) {
            ArrayList<IBasicBlock> arrayList = new ArrayList<IBasicBlock>();
            arrayList.add(iBasicBlock3);
            hashSet.add(iBasicBlock3.getBase());
            while (!arrayList.isEmpty()) {
                List[] listArray;
                IBasicBlock iBasicBlock4 = (IBasicBlock)arrayList.remove(0);
                for (List list2 : listArray = new List[]{iBasicBlock4.getOutputs(), iBasicBlock4.getIrregularOutputs()}) {
                    if (list2 == null) continue;
                    for (IBasicBlock iBasicBlock5 : list2) {
                        if (iBasicBlock5 == iBasicBlock) continue;
                        if (iBasicBlock5 == iBasicBlock2) {
                            return false;
                        }
                        if (!hashSet.add(iBasicBlock5.getBase())) continue;
                        arrayList.add(iBasicBlock5);
                    }
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DFA{");
        Strings.ff(stringBuilder, "settings:collFlags=%s,integrateInputs=%b", this.collectionFlagsAsString(), this.isIntegrateCalculatedInputRegisters());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String collectionFlagsAsString() {
        switch (this.varCollectionFlags) {
            case 1: {
                return "POTENTIALS";
            }
            case 2: {
                return "SPOILED";
            }
            case 3: {
                return "CONSERVATIVE";
            }
        }
        return Strings.ff("0x%X", this.varCollectionFlags);
    }
}

