/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionXrefsData;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.DalvikCallgraphBuilder;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.asm.NativeCallgraphBuilder;
import com.pnfsoftware.jeb.util.graph.IAddressableDigraphBuilder;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CodeUtil {
    private static final ILogger logger = GlobalLog.getLogger(CodeUtil.class);

    public static String findCodeItemReference(ICodeUnit iCodeUnit, ICodeItem iCodeItem, int n2) {
        List<String> list;
        ActionXrefsData actionXrefsData;
        ActionContext actionContext;
        if (n2 < 0) {
            return null;
        }
        String string = iCodeItem.getAddress();
        if (string != null && n2 == 0) {
            return string;
        }
        long l2 = iCodeItem.getItemId();
        if (l2 != 0L && iCodeUnit.prepareExecution(actionContext = new ActionContext(iCodeUnit, 4, l2), actionXrefsData = new ActionXrefsData()) && (list = actionXrefsData.getAddresses()) != null && n2 < list.size()) {
            string = list.get(n2);
        }
        return string;
    }

    public static ICodeMethod getMethodByName(ICodeUnit iCodeUnit, String string, boolean bl) {
        ICodeMethod iCodeMethod = null;
        ArrayList<ICodeMethod> arrayList = new ArrayList<ICodeMethod>();
        for (ICodeMethod iCodeMethod2 : iCodeUnit.getMethods()) {
            String string2 = iCodeMethod2.getName(true);
            if (string2 == null) continue;
            if (string2.equals(string)) {
                if (iCodeMethod != null) {
                    logger.error("Unit '%s': Two or more methods have the name '%s'", iCodeUnit, string2);
                    return null;
                }
                iCodeMethod = iCodeMethod2;
                continue;
            }
            if (!string2.contains(string)) continue;
            arrayList.add(iCodeMethod2);
        }
        if (iCodeMethod == null && !arrayList.isEmpty()) {
            if (arrayList.size() >= 2 && bl) {
                return null;
            }
            iCodeMethod = (ICodeMethod)arrayList.get(0);
        }
        return iCodeMethod;
    }

    public static ICodeField getFieldByName(ICodeUnit iCodeUnit, String string, boolean bl) {
        ICodeField iCodeField = null;
        ArrayList<ICodeField> arrayList = new ArrayList<ICodeField>();
        for (ICodeField iCodeField2 : iCodeUnit.getFields()) {
            String string2 = iCodeField2.getName(true);
            if (string2 == null) continue;
            if (string2.equals(string)) {
                if (iCodeField != null) {
                    logger.error("Unit '%s': Two or more fields have the name '%s'", iCodeUnit, string2);
                    return null;
                }
                iCodeField = iCodeField2;
                continue;
            }
            if (!string2.contains(string)) continue;
            arrayList.add(iCodeField2);
        }
        if (iCodeField == null && !arrayList.isEmpty()) {
            if (arrayList.size() >= 2 && bl) {
                return null;
            }
            iCodeField = (ICodeField)arrayList.get(0);
        }
        return iCodeField;
    }

    public static List<ICodeClass> collectClasses(ICodeUnit iCodeUnit, boolean bl, boolean bl2, Pattern pattern) {
        ArrayList<ICodeClass> arrayList = new ArrayList<ICodeClass>();
        for (ICodeClass iCodeClass : iCodeUnit.getClasses()) {
            if (bl && !iCodeClass.isInternal() || bl2 && (iCodeClass.getGenericFlags() & 0x100000) != 0) continue;
            String string = iCodeClass.getAddress();
            if (pattern != null && !pattern.matcher(string).matches()) continue;
            arrayList.add(iCodeClass);
        }
        return arrayList;
    }

    public static List<ICodeMethod> collectMethods(ICodeUnit iCodeUnit, boolean bl, boolean bl2, Pattern pattern) {
        ArrayList<ICodeMethod> arrayList = new ArrayList<ICodeMethod>();
        List<? extends ICodeMethod> list = iCodeUnit instanceof INativeCodeUnit ? ((INativeCodeUnit)iCodeUnit).getInternalMethodsLeafFirst() : iCodeUnit.getMethods();
        for (ICodeMethod iCodeMethod : list) {
            if (bl && !iCodeMethod.isInternal() || bl2 && iCodeMethod.getClassType() != null) continue;
            String string = iCodeMethod.getAddress();
            if (pattern != null && !pattern.matcher(string).matches()) continue;
            arrayList.add(iCodeMethod);
        }
        return arrayList;
    }

    public static IAddressableDigraphBuilder createCallgraphBuilder(ICodeUnit iCodeUnit) {
        if (iCodeUnit instanceof IDexUnit) {
            return new DalvikCallgraphBuilder((IDexUnit)iCodeUnit);
        }
        if (iCodeUnit instanceof INativeCodeUnit) {
            return new NativeCallgraphBuilder((INativeCodeUnit)iCodeUnit);
        }
        return null;
    }
}

