/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.core.units.code.Pointer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeModel;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class CodePointer
extends Pointer
implements ICodePointer {
    @SerId(value=1)
    int processorMode;

    public CodePointer(long l2, int n2) {
        super(l2, 0, 1);
        this.processorMode = n2;
    }

    public CodePointer(long l2) {
        this(l2, 0);
    }

    public CodePointer(ICodePointer iCodePointer) {
        this(iCodePointer.getAddress(), iCodePointer.getMode());
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.processorMode;
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CodePointer codePointer = (CodePointer)object;
        return this.processorMode == codePointer.processorMode;
    }

    public boolean almostEquals(Object object) {
        return super.equals(object);
    }

    @Override
    public int getMode() {
        return this.processorMode;
    }

    public void setMode(int n2) {
        this.processorMode = n2;
    }

    @Override
    public boolean isUnknownAddress() {
        return this.address == -1L;
    }

    @Override
    public String toString() {
        if (this.processorMode == 0) {
            return Strings.ff("0x%X", this.address);
        }
        return Strings.ff("0x%X(%d)", this.address, this.processorMode);
    }

    public static CodePointer createFrom(String string) {
        String string2 = string;
        if (string2 == null || !string2.startsWith("0x")) {
            throw new IllegalArgumentException(Strings.f("Address @%s must start with 0x", string));
        }
        try {
            int n2 = string2.indexOf(40);
            if (n2 >= 0) {
                int n3 = string.indexOf(41);
                long l2 = Long.parseLong(string2.substring(2, n2), 16);
                int n4 = Integer.parseInt(string2.substring(n3 + 1));
                return new CodePointer(l2, n4);
            }
            long l3 = Long.parseLong(string2.substring(2), 16);
            return new CodePointer(l3);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(Strings.f("Invalid address @%s", string), runtimeException);
        }
    }

    public static CodePointer createFrom(long l2, INativeCodeModel<?> iNativeCodeModel) {
        INativeContinuousItem iNativeContinuousItem = iNativeCodeModel.getItemAt(l2);
        if (!(iNativeContinuousItem instanceof INativeInstructionItem)) {
            throw new IllegalArgumentException(Strings.f("invalid address @%xh -- no instruction here", l2));
        }
        return new CodePointer(l2, ((INativeInstructionItem)iNativeContinuousItem).getInstruction().getProcessorMode());
    }

    public static CodePointer createFrom(ILocatedInstruction iLocatedInstruction) {
        return new CodePointer(iLocatedInstruction.getOffset(), iLocatedInstruction.getProcessorMode());
    }

    public static CodePointer createFrom(INativeMethodDataItem iNativeMethodDataItem) {
        long l2;
        CFG<? extends IInstruction> cFG = iNativeMethodDataItem.getCFG();
        IInstruction iInstruction = cFG.getInstruction(l2 = cFG.getEntryAddress());
        if (iInstruction == null) {
            throw new RuntimeException(Strings.f("Cannot find instruction @%s", iNativeMethodDataItem.getAddress()));
        }
        return new CodePointer(l2, iInstruction.getProcessorMode());
    }

    public static CodePointer createFrom(INativeMethodItem iNativeMethodItem) {
        INativeMethodDataItem iNativeMethodDataItem = iNativeMethodItem.getData();
        if (iNativeMethodDataItem == null) {
            throw new IllegalArgumentException();
        }
        return CodePointer.createFrom(iNativeMethodDataItem);
    }

    public static CodePointer createUnknown() {
        return CodePointer.createUnknown(0);
    }

    public static CodePointer createUnknown(int n2) {
        return new CodePointer(-1L, n2);
    }
}

