/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.util.collect.IdentityHashSet;
import com.pnfsoftware.jeb.util.collect.Sets;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CFGUtil {
    private static final ILogger logger = GlobalLog.getLogger(CFGUtil.class);

    public static void verify(IControlFlowGraph<?, ?> iControlFlowGraph) {
        CFGUtil.verify(iControlFlowGraph, true, true, true, true, true);
    }

    public static void verify(IControlFlowGraph<?, ?> iControlFlowGraph, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (iControlFlowGraph.size() == 0) {
            throw new IllegalArgumentException("Empty graph");
        }
        try {
            Object object;
            int n2;
            Object object22;
            for (int i = 0; i < iControlFlowGraph.size(); ++i) {
                object22 = iControlFlowGraph.get(i);
                if (!object22.isEmpty()) continue;
                throw new IllegalArgumentException("Empty node: " + object22);
            }
            if (bl2) {
                long l2 = iControlFlowGraph.get(0).getEndAddress();
                for (n2 = 1; n2 < iControlFlowGraph.size(); ++n2) {
                    object = iControlFlowGraph.getBlock(n2);
                    long l3 = object.getFirstAddress();
                    if (l3 != l2) {
                        throw new IllegalArgumentException(Strings.ff("Gap before block %s: 0x%X", object, l3 - l2));
                    }
                    l2 = object.getEndAddress();
                }
            }
            if (bl) {
                IdentityHashSet<Object> identityHashSet = new IdentityHashSet<Object>();
                object22 = new ArrayList();
                Object obj = iControlFlowGraph.getEntryBlock();
                identityHashSet.add(obj);
                object22.add(obj);
                while (!object22.isEmpty()) {
                    object = (IBasicBlock)object22.remove(0);
                    for (IBasicBlock iBasicBlock : object.getAllOutputBlocks()) {
                        if (!identityHashSet.add(iBasicBlock)) continue;
                        object22.add(iBasicBlock);
                    }
                }
                if (identityHashSet.size() != iControlFlowGraph.size()) {
                    object = iControlFlowGraph.getBlocks();
                    object.removeAll(identityHashSet);
                    throw new IllegalArgumentException("Not all nodes can be reached from block #0: " + (List)object);
                }
            }
            if (bl3) {
                for (Object object22 : iControlFlowGraph.getBlocks()) {
                    object = object22.getLast().getBreakingFlow(object22.getLastAddress());
                    n2 = object.isBroken() ? object.getTargets().size() : 1;
                    List list = object22.getOutputBlocks();
                    if (list.size() == n2) continue;
                    throw new IllegalArgumentException(Strings.ff("Duplicate out-edges from block %s: insn:%d, cfg:%d, %s", object22, n2, list.size(), list));
                }
            }
            if (bl4) {
                for (Object object22 : iControlFlowGraph.getBlocks()) {
                    List list = object22.getInputBlocks();
                    if (list.size() != new HashSet(list).size()) {
                        throw new IllegalArgumentException(Strings.ff("Duplicate in-edges to block %s: %s", object22, list));
                    }
                    list = object22.getOutputBlocks();
                    if (list.size() == new HashSet(list).size()) continue;
                    throw new IllegalArgumentException(Strings.ff("Duplicate out-edges from block %s: %s", object22, list));
                }
            }
            if (bl5) {
                for (Object object22 : iControlFlowGraph.getBlocks()) {
                    List list = object22.getIrregularInputBlocks();
                    if (list.size() != new HashSet(list).size()) {
                        throw new IllegalArgumentException(Strings.ff("Duplicate irregular-in-edges to block %s: %s", object22, list));
                    }
                    list = object22.getIrregularOutputBlocks();
                    if (list.size() == new HashSet(list).size()) continue;
                    throw new IllegalArgumentException(Strings.ff("Duplicate irregular-out-edges to block %s: %s", object22, list));
                }
            }
        }
        catch (Exception exception) {
            try {
                CFGUtil.toDot(iControlFlowGraph, IO.createTempFile("failed0.dot"), "FAILED VERIFICATION: " + exception.getMessage());
            }
            catch (IOException iOException) {}
            throw exception;
        }
    }

    public static void toTempDot(IControlFlowGraph<?, ?> iControlFlowGraph, String string) {
        CFGUtil.toTempDot(iControlFlowGraph, string, null, null, -1);
    }

    public static void toTempDot(IControlFlowGraph<?, ?> iControlFlowGraph, String object, String string, Map<Long, String> map, int n2) {
        try {
            if (!((String)object).endsWith(".dot")) {
                object = (String)object + ".dot";
            }
            CFGUtil.toDot(iControlFlowGraph, IO.createTempFile((String)object), string, map, n2);
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
        }
    }

    public static void toDot(IControlFlowGraph<?, ?> iControlFlowGraph, File file) throws IOException {
        CFGUtil.toDot(iControlFlowGraph, file, null, null);
    }

    public static void toDot(IControlFlowGraph<?, ?> iControlFlowGraph, File file, String string) throws IOException {
        CFGUtil.toDot(iControlFlowGraph, file, string, null);
    }

    public static void toDot(IControlFlowGraph<?, ?> iControlFlowGraph, File file, String string, Map<Long, String> map) throws IOException {
        CFGUtil.toDot(iControlFlowGraph, file, string, map, -1);
    }

    public static void toDot(IControlFlowGraph<?, ?> iControlFlowGraph, File file, String string, Map<Long, String> map, int n2) throws IOException {
        DotFileGenerator dotFileGenerator = new DotFileGenerator(iControlFlowGraph);
        dotFileGenerator.setTitle(string);
        dotFileGenerator.setBlockHeaders(map);
        dotFileGenerator.setLineLimit(n2);
        String string2 = dotFileGenerator.generate();
        IO.writeFile(file, Strings.encodeUTF8(string2));
    }

    public static int countDeepInputs(IBasicBlock<? extends IInstruction> iBasicBlock, int n2) {
        int n3 = iBasicBlock.insize();
        if (n3 == 0 || n2 <= 1) {
            return n3;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i = 2; i <= n2; ++i) {
            arrayList.clear();
            hashSet.clear();
            CFGUtil.collectDeepInputsInternal(iBasicBlock, n2, arrayList, hashSet);
            if (hashSet.size() <= n3) continue;
            n3 = hashSet.size();
        }
        return n3;
    }

    private static void collectDeepInputsInternal(IBasicBlock<? extends IInstruction> iBasicBlock, int n2, List<Long> list, Set<Long> set) {
        long l2 = iBasicBlock.getBase();
        if (list.contains(l2)) {
            return;
        }
        if (n2 == 0 || iBasicBlock.insize() == 0) {
            set.add(l2);
            return;
        }
        list.add(l2);
        for (IBasicBlock<? extends IInstruction> iBasicBlock2 : iBasicBlock.getInputs()) {
            CFGUtil.collectDeepInputsInternal(iBasicBlock2, n2 - 1, list, set);
        }
        list.remove(list.size() - 1);
    }

    public static boolean canReach(IBasicBlock<? extends IInstruction> iBasicBlock, IBasicBlock<? extends IInstruction> iBasicBlock2) {
        return CFGUtil.canReach(iBasicBlock, iBasicBlock2, false);
    }

    public static boolean canReach(IBasicBlock<? extends IInstruction> iBasicBlock, IBasicBlock<? extends IInstruction> iBasicBlock2, boolean bl) {
        return CFGUtil.canReach(iBasicBlock, iBasicBlock2, bl, null);
    }

    public static boolean canReach(IBasicBlock<? extends IInstruction> iBasicBlock, IBasicBlock<? extends IInstruction> iBasicBlock2, boolean bl, Collection<IBasicBlock<? extends IInstruction>> collection) {
        return new ReachabilityChecker(iBasicBlock, iBasicBlock2, bl, collection).check();
    }

    public static class RegionFinder {
        private CFG<? extends IInstruction> cfg;
        private long entry;
        private Set<Long> outputs;
        private boolean canLoopBackToEntry;
        private LinkedHashSet<Long> regionBlocks = new LinkedHashSet();

        public RegionFinder(CFG<? extends IInstruction> cFG, long l2, Set<Long> set, boolean bl) {
            this.cfg = cFG;
            this.entry = l2;
            this.outputs = set;
            this.canLoopBackToEntry = bl;
        }

        public RegionFinder(CFG<? extends IInstruction> cFG, long l2, long l3) {
            this.cfg = cFG;
            this.entry = l2;
            this.outputs = Sets.newHashSet(l3);
            this.canLoopBackToEntry = false;
        }

        public Collection<Long> getRegionBlocks() {
            return this.regionBlocks;
        }

        public boolean process() {
            boolean bl = true;
            ArrayDeque<Long> arrayDeque = new ArrayDeque<Long>();
            arrayDeque.add(this.entry);
            LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
            HashSet<Long> hashSet = new HashSet<Long>();
            int n2 = 0;
            while (!arrayDeque.isEmpty()) {
                long l2 = (Long)arrayDeque.remove();
                if (!linkedHashSet.add(l2) || this.outputs.contains(l2)) continue;
                IBasicBlock iBasicBlock = this.cfg.getBlockAt(l2);
                this.regionBlocks.add(l2);
                if (l2 != this.entry) {
                    for (BasicBlock basicBlock : ((BasicBlock)iBasicBlock).getAllInputs()) {
                        hashSet.add(basicBlock.getAddress());
                    }
                } else if (n2 > 0 && !this.canLoopBackToEntry) {
                    bl = false;
                }
                for (BasicBlock basicBlock : ((BasicBlock)iBasicBlock).getAllOutputs()) {
                    arrayDeque.add(basicBlock.getAddress());
                }
                ++n2;
            }
            hashSet.removeAll(linkedHashSet);
            if (!hashSet.isEmpty()) {
                bl = false;
            }
            return bl;
        }
    }

    public static class BlockGroup {
        private CFG<? extends IInstruction> cfg;
        private BasicBlock<? extends IInstruction> blkStart;
        private BasicBlock<? extends IInstruction> blkStopper;
        private Set<Long> blocks;
        private Set<Long> exitpoints;
        private Set<Long> entrypoints;
        private List<Long> tmppath = new ArrayList<Long>();

        public BlockGroup(CFG<? extends IInstruction> cFG, long l2, long l3) {
            if (cFG == null) {
                throw new IllegalArgumentException();
            }
            this.cfg = cFG;
            this.blkStart = cFG.getBlockAt(l2);
            if (this.blkStart == null) {
                throw new IllegalArgumentException();
            }
            this.blkStopper = cFG.getBlockAt(l3);
            if (this.blkStopper == null) {
                throw new IllegalArgumentException();
            }
        }

        public Set<Long> getBlocksInGroup() {
            if (this.blocks == null) {
                throw new IllegalStateException();
            }
            return this.blocks;
        }

        public Set<Long> getExitPoints() {
            if (this.exitpoints == null) {
                throw new IllegalStateException();
            }
            return this.exitpoints;
        }

        public Set<Long> getEntryPoints() {
            if (this.entrypoints == null) {
                throw new IllegalStateException();
            }
            return this.entrypoints;
        }

        public Set<Long> determine() {
            long l2;
            Object object;
            Iterable<Long> iterable;
            if (this.blocks != null) {
                throw new IllegalStateException();
            }
            this.blocks = new LinkedHashSet<Long>();
            this.exitpoints = new LinkedHashSet<Long>();
            this.entrypoints = new LinkedHashSet<Long>();
            HashSet<Long> hashSet = new HashSet<Long>();
            ArrayList arrayList = new ArrayList();
            arrayList.add(this.blkStart);
            while (!arrayList.isEmpty()) {
                iterable = (BasicBlock)arrayList.remove(0);
                if (!hashSet.add(((BasicBlock)iterable).getBase()) || !this.checkBlock((BasicBlock<? extends IInstruction>)iterable)) continue;
                arrayList.addAll(((BasicBlock)iterable).getOutputBlocks());
            }
            iterable = new LinkedHashSet();
            arrayList.add(this.blkStart);
            while (!arrayList.isEmpty()) {
                object = (BasicBlock)arrayList.remove(0);
                l2 = ((BasicBlock)object).getBase();
                if (!this.blocks.contains(l2) || !iterable.add(l2)) continue;
                arrayList.addAll(((BasicBlock)object).getOutputBlocks());
            }
            this.blocks = iterable;
            object = this.blocks.iterator();
            while (object.hasNext()) {
                l2 = (Long)object.next();
                IBasicBlock iBasicBlock = this.cfg.getBlockAt(l2);
                for (long l3 : ((BasicBlock)iBasicBlock).getOutputOffsets()) {
                    if (this.blocks.contains(l3)) continue;
                    this.exitpoints.add(l2);
                }
                for (long l3 : ((BasicBlock)iBasicBlock).getInputOffsets()) {
                    if (this.blocks.contains(l3)) continue;
                    this.entrypoints.add(l2);
                }
            }
            if (this.blkStart == this.cfg.getEntryBlock() && this.blocks.contains(this.blkStart.getBase())) {
                this.entrypoints.add(this.blkStart.getBase());
            }
            return this.blocks;
        }

        private boolean checkBlock(BasicBlock<? extends IInstruction> basicBlock) {
            if (basicBlock == this.blkStopper) {
                return false;
            }
            long l2 = basicBlock.getBase();
            if (this.tmppath.contains(l2)) {
                return true;
            }
            if (!this.blocks.contains(l2)) {
                this.tmppath.add(l2);
                for (BasicBlock<? extends IInstruction> basicBlock2 : basicBlock.getInputs()) {
                    if (this.blocks.contains(basicBlock2.getBase()) || this.checkBlock(basicBlock2)) continue;
                    this.tmppath.remove(l2);
                    return false;
                }
                this.tmppath.remove(l2);
                this.blocks.add(l2);
            }
            return true;
        }
    }

    static class ReachabilityChecker {
        private IBasicBlock<? extends IInstruction> from;
        private IBasicBlock<? extends IInstruction> to;
        private boolean alsoFollowIrregularFlow;
        private Collection<IBasicBlock<? extends IInstruction>> stopperBlocks;
        private Set<Long> seen = new HashSet<Long>();

        ReachabilityChecker(IBasicBlock<? extends IInstruction> iBasicBlock, IBasicBlock<? extends IInstruction> iBasicBlock2, boolean bl, Collection<IBasicBlock<? extends IInstruction>> collection) {
            this.from = iBasicBlock;
            this.to = iBasicBlock2;
            this.alsoFollowIrregularFlow = bl;
            this.stopperBlocks = collection;
        }

        boolean check() {
            return this.check(this.from, 0);
        }

        private boolean check(IBasicBlock<? extends IInstruction> iBasicBlock, int n2) {
            if (this.stopperBlocks != null && this.stopperBlocks.contains(iBasicBlock)) {
                return false;
            }
            if (iBasicBlock == this.to && n2 >= 1) {
                return true;
            }
            if (!this.seen.add(iBasicBlock.getBase())) {
                return false;
            }
            for (IBasicBlock<? extends IInstruction> iBasicBlock2 : iBasicBlock.getOutputs()) {
                if (!this.check(iBasicBlock2, n2 + 1)) continue;
                return true;
            }
            if (this.alsoFollowIrregularFlow) {
                for (IBasicBlock<? extends IInstruction> iBasicBlock2 : iBasicBlock.getIrregularOutputs()) {
                    if (!this.check(iBasicBlock2, n2 + 1)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class DotFileGenerator {
        private IControlFlowGraph<?, ?> cfg;
        private String title;
        private Map<Long, String> blockHeaders;
        private int lineLimit;
        private int nodeIndexingStartValue = 1;

        public DotFileGenerator(IControlFlowGraph<?, ?> iControlFlowGraph) {
            this.cfg = iControlFlowGraph;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setBlockHeaders(Map<Long, String> map) {
            this.blockHeaders = map;
        }

        public void setLineLimit(int n2) {
            this.lineLimit = n2;
        }

        public void setGenerateBlockIndices(int n2) {
            this.nodeIndexingStartValue = n2;
        }

        public String generate() {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("digraph G {\n");
            if (this.title != null) {
                stringBuilder.append("labelloc=\"t\"\n");
                stringBuilder.append("labelfontname=\"Consolas\"\n");
                Strings.ff(stringBuilder, "label=\"%s\"\n", DotFileGenerator.dotEscape(this.title));
            }
            int n2 = Integer.MAX_VALUE;
            boolean bl = false;
            if (this.lineLimit > 0) {
                n2 = this.lineLimit;
            } else if (this.lineLimit < 0) {
                n2 = -this.lineLimit;
                bl = true;
            }
            int n3 = 0;
            for (IBasicBlock iBasicBlock : this.cfg) {
                String string;
                Object object22;
                Object object3 = "";
                if (this.nodeIndexingStartValue >= 0) {
                    object3 = "(" + (n3 + this.nodeIndexingStartValue) + ")";
                }
                if (this.blockHeaders != null && (object = this.blockHeaders.get(iBasicBlock.getFirstAddress())) != null) {
                    object3 = (String)object3 + " " + (String)object;
                }
                object = new StringBuilder((String)object3);
                ((StringBuilder)object).append("\\l");
                int n4 = 0;
                for (Object object22 : iBasicBlock) {
                    long l2 = iBasicBlock.getAddressOfInstruction(n4);
                    char c2 = n4 >= 1 ? (char)':' : (iBasicBlock.getFirstAddress() == 0L ? (char)'>' : (iBasicBlock.irrinsize() == 0 ? (char)'+' : '*'));
                    String string2 = Strings.ff("%04X/%X%c ", l2, object22.getSize(), Character.valueOf(c2));
                    ((StringBuilder)object).append(DotFileGenerator.dotEscape(string2));
                    String string3 = object22.format(l2);
                    if (string3.length() <= n2) {
                        ((StringBuilder)object).append(DotFileGenerator.dotEscape(string3));
                        ((StringBuilder)object).append("\\l");
                    } else if (!bl) {
                        String string4 = string3.substring(0, n2) + "...";
                        ((StringBuilder)object).append(DotFileGenerator.dotEscape(string4));
                        ((StringBuilder)object).append("\\l");
                    } else {
                        int n5 = 0;
                        String string5 = string3;
                        while (!string5.isEmpty()) {
                            int n6 = string5.length() <= n2 ? string5.length() : n2;
                            String string6 = string5.substring(0, n6);
                            if (n5 > 0) {
                                ((StringBuilder)object).append(DotFileGenerator.dotEscape(Strings.generate("&nbsp;", string2.length())));
                            }
                            ((StringBuilder)object).append(DotFileGenerator.dotEscape(string6));
                            ((StringBuilder)object).append("\\l");
                            string5 = string5.substring(n6);
                            ++n5;
                        }
                    }
                    ++n4;
                }
                Object object4 = "";
                object22 = this.generateNodeBackgroundColor(iBasicBlock);
                if (object22 != null) {
                    object4 = (String)object4 + Strings.ff("fillcolor=\"%s\",", object22);
                }
                if ((string = this.generateNodeTextColor(iBasicBlock)) != null) {
                    object4 = (String)object4 + Strings.ff("fontcolor=\"%s\",", string);
                }
                Strings.ff(stringBuilder, "BB_%08x [shape=Mrecord,fontname=\"Consolas\",%sstyle=\"filled\",label=\"%s\"];\n", iBasicBlock.getFirstAddress(), object4, ((StringBuilder)object).toString());
                ++n3;
            }
            for (IBasicBlock iBasicBlock : this.cfg) {
                Object object5;
                if (iBasicBlock.outsize() == 2) {
                    IBasicBlock iBasicBlock2 = iBasicBlock.getOutputBlock(0);
                    object = this.generateEdgeLabel(iBasicBlock, 0);
                    if (object == null) {
                        object = "";
                    }
                    Strings.ff(stringBuilder, "BB_%08x -> BB_%08x [color=\"red\",fontname=\"Consolas\",fontsize=10,label=\"%s\"];\n", iBasicBlock.getFirstAddress(), iBasicBlock2.getFirstAddress(), object);
                    iBasicBlock2 = iBasicBlock.getOutputBlock(1);
                    String string = this.generateEdgeLabel(iBasicBlock, 1);
                    if (string == null) {
                        string = "";
                    }
                    Strings.ff(stringBuilder, "BB_%08x -> BB_%08x [color=\"green\",fontname=\"Consolas\",fontsize=10,label=\"%s\"];\n", iBasicBlock.getFirstAddress(), iBasicBlock2.getFirstAddress(), string);
                } else {
                    for (int i = 0; i < iBasicBlock.outsize(); ++i) {
                        object = iBasicBlock.getOutputBlock(i);
                        object5 = this.generateEdgeLabel(iBasicBlock, i);
                        if (object5 == null) {
                            object5 = "";
                            if (iBasicBlock.outsize() >= 3) {
                                object5 = (String)object5 + i;
                            }
                        }
                        Strings.ff(stringBuilder, "BB_%08x -> BB_%08x [fontname=\"Consolas\",fontsize=10,label=\"%s\"];\n", iBasicBlock.getFirstAddress(), object.getFirstAddress(), object5);
                    }
                }
                for (int i = 0; i < iBasicBlock.irroutsize(); ++i) {
                    object = iBasicBlock.getIrregularOutputBlock(i);
                    object5 = this.generateIrregularEdgeLabel(iBasicBlock, i);
                    if (object5 == null) {
                        object5 = "";
                        if (iBasicBlock.irroutsize() >= 2) {
                            object5 = (String)object5 + i;
                        }
                    }
                    Strings.ff(stringBuilder, "BB_%08x -> BB_%08x [style=dotted,fontname=\"Consolas\",fontsize=10,label=\"%s\"];\n", iBasicBlock.getFirstAddress(), object.getFirstAddress(), object5);
                }
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        protected String generateEdgeLabel(IBasicBlock<? extends IInstruction> iBasicBlock, int n2) {
            return null;
        }

        protected String generateIrregularEdgeLabel(IBasicBlock<? extends IInstruction> iBasicBlock, int n2) {
            return null;
        }

        protected String generateNodeBackgroundColor(IBasicBlock<? extends IInstruction> iBasicBlock) {
            return null;
        }

        protected String generateNodeTextColor(IBasicBlock<? extends IInstruction> iBasicBlock) {
            return null;
        }

        private static String dotEscape(String string) {
            string = string.replace("\\", "\\\\");
            string = string.replace("|", "\\|");
            string = string.replace("<", "\\<");
            string = string.replace(">", "\\>");
            string = string.replace("{", "\\{");
            string = string.replace("}", "\\}");
            string = string.replace("\"", "\\\"");
            return string;
        }
    }
}

