/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.ICoreContext;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.IUnitFilter;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;

public class UnitUtil {
    public static void notifyGenericChange(IUnit iUnit) {
        iUnit.notifyListeners(new JebEvent(J.UnitChange));
    }

    static void log(IUnit iUnit, String string, boolean bl, ILogger iLogger, int n2, String object, Object ... objectArray) {
        block13: {
            if (object == null) {
                object = "";
                objectArray = new Object[]{};
            }
            try {
                String string2;
                if (string != null) {
                    object = string.replace("%", "%%") + ": " + (String)object;
                }
                if (iUnit == null) break block13;
                if (bl) {
                    try {
                        NotificationType notificationType;
                        string2 = Strings.ff((String)object, objectArray);
                        switch (n2) {
                            case 50: {
                                notificationType = NotificationType.ERROR;
                                break;
                            }
                            case 40: {
                                notificationType = NotificationType.WARNING;
                                break;
                            }
                            case 30: {
                                notificationType = NotificationType.INFO;
                                break;
                            }
                            default: {
                                notificationType = NotificationType.AREA_OF_INTEREST;
                            }
                        }
                        iUnit.getNotificationManager().addNotification(new UnitNotification(notificationType, string2, string));
                    }
                    catch (NullPointerException | IllegalFormatException runtimeException) {}
                }
                if ((string2 = UnitUtil.buildFullyQualifiedUnitPath(iUnit)) != null) {
                    object = Strings.ff("{%s}: %s", string2.replace("%", "%%"), object);
                }
            }
            catch (Exception exception) {
                iLogger.catchingSilent(exception);
            }
        }
        iLogger.log(n2, false, (String)object, objectArray);
    }

    public static void logI(IUnit iUnit, String string, ILogger iLogger, String string2, Object ... objectArray) {
    }

    public static void logTrace(IUnit iUnit, String string, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, false, iLogger, 10, string2, objectArray);
    }

    public static void logInfo(IUnit iUnit, String string, boolean bl, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, bl, iLogger, 30, string2, objectArray);
    }

    public static void logWarn(IUnit iUnit, String string, boolean bl, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, bl, iLogger, 40, string2, objectArray);
    }

    public static void logError(IUnit iUnit, String string, boolean bl, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, bl, iLogger, 50, string2, objectArray);
    }

    public static void logException(IUnit iUnit, ILogger iLogger, Exception exception) {
        Object object = Strings.ff("EXCEPTION: %s", exception.getMessage());
        Throwable throwable = Throwables.getRootCause(exception);
        if (throwable != null && throwable != exception && throwable.getMessage() != null) {
            object = (String)object + Strings.ff(" (cause: %s)", throwable.getMessage());
        }
        UnitUtil.logError(iUnit, null, false, iLogger, (String)object, new Object[0]);
        iLogger.log(10, false, Throwables.formatStacktrace(exception), new Object[0]);
    }

    public static List<IUnit> filterDescendants(IUnit iUnit, int n2, IUnitFilter iUnitFilter) {
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (IUnit iUnit2 : iUnit.getChildren()) {
            UnitUtil.filterDescendantsRecurse(iUnit2, n2, iUnitFilter, arrayList);
        }
        return arrayList;
    }

    private static boolean filterDescendantsRecurse(IUnit iUnit, int n2, IUnitFilter iUnitFilter, List<IUnit> list) {
        if (iUnit != null && n2 != 0) {
            if (iUnitFilter == null) {
                list.add(iUnit);
            } else {
                int n3 = iUnitFilter.check2(iUnit);
                if ((n3 & 1) != 0) {
                    list.add(iUnit);
                }
                if ((n3 & 2) != 0) {
                    return false;
                }
            }
            if (n2 - 1 != 0) {
                for (IUnit iUnit2 : iUnit.getChildren()) {
                    if (UnitUtil.filterDescendantsRecurse(iUnit2, n2 - 1, iUnitFilter, list)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static <T extends IUnit> List<T> findDescendantsByType(IUnit iUnit, int n2, final Class<T> clazz, final boolean bl) {
        return UnitUtil.filterDescendants(iUnit, n2, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                return clazz == null || clazz == iUnit.getClass() || !bl && clazz.isInstance(iUnit);
            }
        });
    }

    public static <T extends IUnit> List<T> findChildrenByType(IUnit iUnit, Class<T> clazz, boolean bl) {
        return UnitUtil.findDescendantsByType(iUnit, 1, clazz, bl);
    }

    public static <T extends IUnit> T findChildByType(IUnit iUnit, Class<T> clazz, boolean bl, int n2) {
        List<T> list = UnitUtil.findChildrenByType(iUnit, clazz, bl);
        return (T)(n2 >= list.size() ? null : (IUnit)list.get(n2));
    }

    public static <T extends IUnit> T findFirstChildByType(IUnit iUnit, Class<T> clazz, boolean bl) {
        return UnitUtil.findChildByType(iUnit, clazz, bl, 0);
    }

    public static <T extends IUnit> List<T> findDescendantsByType(IUnit iUnit, Class<T> clazz, boolean bl) {
        return UnitUtil.findDescendantsByType(iUnit, -1, clazz, bl);
    }

    public static List<IUnit> findDescendantsByName(IUnit iUnit, int n2, final String string) {
        return UnitUtil.filterDescendants(iUnit, n2, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                return Strings.equals(iUnit.getName(), string);
            }
        });
    }

    public static List<IUnit> findDescendantsByName(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByName(iUnit, -1, string);
    }

    public static List<IUnit> findChildrenByName(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByName(iUnit, 1, string);
    }

    public static IUnit findChildByName(IUnit iUnit, String string, int n2) {
        List<IUnit> list = UnitUtil.findChildrenByName(iUnit, string);
        return n2 >= list.size() ? null : list.get(n2);
    }

    public static IUnit findFirstChildByName(IUnit iUnit, String string) {
        return UnitUtil.findChildByName(iUnit, string, 0);
    }

    public static IUnit retrieve(IUnit iUnit, String ... stringArray) {
        IUnit iUnit2 = iUnit;
        for (String string : stringArray) {
            if ((iUnit2 = UnitUtil.findFirstChildByName(iUnit2, string)) != null) continue;
            return null;
        }
        return iUnit2;
    }

    public static IUnit retrieveProcessed(boolean bl, IUnit iUnit, String ... stringArray) {
        IUnit iUnit2 = UnitUtil.retrieve(iUnit, stringArray);
        if (iUnit2 == null || !bl) {
            return null;
        }
        if (!iUnit2.isProcessed() && !iUnit2.process()) {
            return null;
        }
        return iUnit2;
    }

    public static <T extends IUnit> List<T> findDescendants(IUnit iUnit, int n2, final String string, final Class<T> clazz, final boolean bl) {
        return UnitUtil.filterDescendants(iUnit, n2, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                if (string != null && !string.equals(iUnit.getName())) {
                    return false;
                }
                return clazz == null || UnitUtil.isClassMatch(iUnit, clazz, bl);
            }
        });
    }

    public static <T extends IUnit> List<T> findChildren(IUnit iUnit, String string, Class<T> clazz, boolean bl) {
        return UnitUtil.findDescendants(iUnit, 1, string, clazz, bl);
    }

    public static <T extends IUnit> T findChild(IUnit iUnit, String string, Class<T> clazz, boolean bl, int n2) {
        List<T> list = UnitUtil.findChildren(iUnit, string, clazz, bl);
        return (T)(n2 >= list.size() ? null : (IUnit)list.get(n2));
    }

    private static boolean isClassMatch(Object object, Class<?> clazz, boolean bl) {
        return object.getClass() == clazz || !bl && clazz.isInstance(object);
    }

    public static <T extends IUnit> List<T> findDescendants(ILiveArtifact iLiveArtifact, int n2, final String string, final Class<T> clazz, final boolean bl) {
        IUnitFilter iUnitFilter = new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                if (string != null && !string.equals(iUnit.getName())) {
                    return false;
                }
                return clazz == null || UnitUtil.isClassMatch(iUnit, clazz, bl);
            }
        };
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (IUnit iUnit : iLiveArtifact.getUnits()) {
            UnitUtil.filterDescendantsRecurse(iUnit, n2, iUnitFilter, arrayList);
        }
        return arrayList;
    }

    public static <T extends IUnit> List<T> findAll(String string, Class<T> clazz, boolean bl) {
        ArrayList<T> arrayList = new ArrayList<T>();
        ICoreContext iCoreContext = JebCoreService.getExistingInstance();
        if (iCoreContext != null) {
            for (IEnginesContext iEnginesContext : iCoreContext.listEnginesContexts()) {
                for (IRuntimeProject iRuntimeProject : iEnginesContext.getProjects()) {
                    for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                        List<T> list = UnitUtil.findDescendants(iLiveArtifact, -1, string, clazz, bl);
                        if (list == null) continue;
                        arrayList.addAll(list);
                    }
                }
            }
        }
        return arrayList;
    }

    public static <T extends IUnit> List<T> findDescendantsByFormatType(IUnit iUnit, int n2, final String string) {
        return UnitUtil.filterDescendants(iUnit, n2, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                return Strings.equals(iUnit.getFormatType(), string);
            }
        });
    }

    public static List<IUnit> findDescendantsByFormatType(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByFormatType(iUnit, -1, string);
    }

    public static List<IUnit> findChildrenByFormatType(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByFormatType(iUnit, 1, string);
    }

    public static IUnit findChildByFormatType(IUnit iUnit, String string, int n2) {
        List<IUnit> list = UnitUtil.findChildrenByFormatType(iUnit, string);
        return n2 >= list.size() ? null : list.get(n2);
    }

    public static IUnit findFirstChildByFormatType(IUnit iUnit, String string) {
        return UnitUtil.findChildByFormatType(iUnit, string, 0);
    }

    public static <T extends IUnitCreator> T findAncestor(IUnit iUnit, Class<T> clazz, boolean bl) {
        if (iUnit == null || clazz == null) {
            return null;
        }
        for (IUnitCreator iUnitCreator = iUnit.getParent(); iUnitCreator != null; iUnitCreator = iUnitCreator.getParent()) {
            if (!UnitUtil.isClassMatch(iUnitCreator, clazz, bl)) continue;
            return (T)iUnitCreator;
        }
        return null;
    }

    public static boolean isAncestorOf(IUnit iUnit, IUnit iUnit2) {
        return UnitUtil.isAncestorOf(iUnit, iUnit2, false);
    }

    public static boolean isAncestorOf(IUnit iUnit, IUnit iUnit2, boolean bl) {
        if (iUnit == null || iUnit2 == null) {
            return false;
        }
        int n2 = 0;
        while (true) {
            if (!(iUnit != iUnit2 || bl && n2 <= 0)) {
                return true;
            }
            if (!(iUnit.getParent() instanceof IUnit)) break;
            iUnit = (IUnit)iUnit.getParent();
            ++n2;
        }
        return false;
    }

    public static String buildFullyQualifiedCandidateUnitPath(String string, IUnitCreator iUnitCreator, boolean bl, String string2) {
        Object object = string;
        for (IUnitCreator iUnitCreator2 = iUnitCreator; iUnitCreator2 != null && (!(iUnitCreator2 instanceof IArtifact) || bl); iUnitCreator2 = iUnitCreator2.getParent()) {
            object = iUnitCreator2.getName() + string2 + (String)object;
        }
        return object;
    }

    public static String buildFullyQualifiedUnitPath(IUnit iUnit, boolean bl, String string) {
        Object object = iUnit.getName();
        for (IUnitCreator iUnitCreator = iUnit.getParent(); iUnitCreator != null && (!(iUnitCreator instanceof IArtifact) || bl); iUnitCreator = iUnitCreator.getParent()) {
            object = iUnitCreator.getName() + string + (String)object;
        }
        return object;
    }

    public static List<String> buildFullyQualifiedUnitPathList(IUnitCreator iUnitCreator, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(iUnitCreator.getName());
        for (IUnitCreator iUnitCreator2 = iUnitCreator.getParent(); iUnitCreator2 != null && (!(iUnitCreator2 instanceof IArtifact) || bl); iUnitCreator2 = iUnitCreator2.getParent()) {
            arrayList.add(0, iUnitCreator2.getName());
        }
        return arrayList;
    }

    public static String buildFullyQualifiedUnitPath(IUnit iUnit) {
        return UnitUtil.buildFullyQualifiedUnitPath(iUnit, true, " > ");
    }

    public static boolean isTopLevelUnit(IUnit iUnit) {
        return iUnit.getParent() instanceof IArtifact;
    }

    public static String unitProperty(IUnitIdentifier iUnitIdentifier, String string) {
        return iUnitIdentifier.getPropertyDefinitionManager().getNamespace() + "." + string;
    }

    public static String unitProperty(IUnit iUnit, String string) {
        return iUnit.getPropertyDefinitionManager().getNamespace() + "." + string;
    }

    public static String unitProperty(IEnginesContext iEnginesContext, String string, String string2) {
        for (IUnitIdentifier iUnitIdentifier : iEnginesContext.getUnitIdentifiers()) {
            if (!iUnitIdentifier.getFormatType().equals(string)) continue;
            return UnitUtil.unitProperty(iUnitIdentifier, string2);
        }
        return null;
    }

    public static String decompilerProperty(IEnginesContext iEnginesContext, String string, String string2) {
        String string3 = "dcmp_" + string;
        return UnitUtil.unitProperty(iEnginesContext, string3, string2);
    }

    public static String debuggerProperty(IEnginesContext iEnginesContext, String string, String string2) {
        String string3 = "dbug_" + string;
        return UnitUtil.unitProperty(iEnginesContext, string3, string2);
    }

    public static List<IUnit> getUnitsFromPathList(IRuntimeProject iRuntimeProject, List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        String string = list.get(0);
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
            if (!string.equals(iLiveArtifact.getArtifact().getName())) continue;
            UnitUtil.getUnitsFromPathList(iLiveArtifact.getUnits(), list, 1, arrayList);
        }
        return arrayList;
    }

    private static void getUnitsFromPathList(List<? extends IUnit> list, List<String> list2, int n2, List<IUnit> list3) {
        if (list2.size() <= n2) {
            return;
        }
        String string = list2.get(n2);
        for (IUnit iUnit : list) {
            if (!string.equals(iUnit.getName()) && !string.equals(iUnit.getRealName())) continue;
            if (list2.size() == n2 + 1) {
                list3.add(iUnit);
                continue;
            }
            UnitUtil.getUnitsFromPathList(iUnit.getChildren(), list2, n2 + 1, list3);
        }
    }
}

