/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class UnitNotification
implements IUnitNotification {
    @SerId(value=1)
    private NotificationType type;
    @SerId(value=2)
    private String description;
    @SerId(value=3)
    private String address;
    @SerId(value=4)
    private String key;
    @SerId(value=5)
    private long timestampMs;

    private UnitNotification(NotificationType notificationType, String string, String string2, long l2, String string3) {
        this.type = notificationType;
        this.description = string;
        this.address = string2;
        this.timestampMs = l2;
        this.key = Strings.safe(string3, Strings.randomUniqueId());
    }

    public UnitNotification(NotificationType notificationType, String string, String string2, String string3) {
        this(notificationType, string, string2, System.currentTimeMillis(), string3);
    }

    public UnitNotification(NotificationType notificationType, String string, String string2) {
        this(notificationType, string, string2, null);
    }

    public UnitNotification(NotificationType notificationType, String string) {
        this(notificationType, string, null);
    }

    public UnitNotification(IUnitNotification iUnitNotification) {
        this(iUnitNotification.getType(), iUnitNotification.getDescription(), iUnitNotification.getAddress(), iUnitNotification.getTimestampMs(), iUnitNotification.getKey());
    }

    @Override
    public NotificationType getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long getTimestampMs() {
        return this.timestampMs;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.getType());
        if (this.getDescription() != null) {
            stringBuilder.append(": ").append(this.getDescription());
        }
        if (this.getAddress() != null) {
            stringBuilder.append(" @ ").append(this.getAddress());
        }
        return stringBuilder.toString();
    }
}

