/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.AbstractMetadataGroup;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.MetadataGroupType;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Ser
public class AddressPrefixMetadataGroup
extends AbstractMetadataGroup {
    public static final String DEFAULT_NAME = "byAddressPrefix";
    @SerId(value=1)
    IAddressableUnit unit;
    @SerId(value=2)
    private Map<String, Object> map = new HashMap<String, Object>();
    @SerId(value=3)
    List<String> blacklist = new ArrayList<String>();

    public AddressPrefixMetadataGroup(IAddressableUnit iAddressableUnit) {
        this(iAddressableUnit, null);
    }

    public AddressPrefixMetadataGroup(IAddressableUnit iAddressableUnit, String string) {
        super(string != null ? string : DEFAULT_NAME, MetadataGroupType.OPAQUE);
        this.unit = iAddressableUnit;
    }

    @Override
    public Map<String, Object> getAllData() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public boolean setData(String string, Object object) {
        if (object == null) {
            return this.map.remove(string) != null;
        }
        this.map.put(string, object);
        return true;
    }

    @Override
    public Object getData(String string) {
        return this.getData(string, AddressConversionPrecision.DEFAULT);
    }

    @Override
    public Object getData(String string, AddressConversionPrecision addressConversionPrecision) {
        if (string == null) {
            return null;
        }
        if ((string = this.unit.getCanonicalAddress(string)) == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : this.getAllData().entrySet()) {
            String string2 = entry.getKey();
            if (!string.startsWith(string2)) continue;
            for (String string3 : this.blacklist) {
                if (!string.startsWith(string3)) continue;
                return null;
            }
            return entry.getValue();
        }
        return null;
    }

    public List<String> getBlacklist() {
        return this.blacklist;
    }

    @Override
    public List<String> getSectionAnchorIds() {
        return null;
    }
}

