/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.AbstractPlugin;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class AbstractUnitIdentifier
extends AbstractPlugin
implements IUnitIdentifier {
    protected String type;
    protected double priority;
    protected IPropertyDefinitionManager pdm;
    protected IPropertyManager pm;

    public AbstractUnitIdentifier(String string, double d) {
        if (string == null) {
            throw new IllegalArgumentException("A unit identifier must have a valid type");
        }
        this.type = string;
        this.priority = d;
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        this.createPDM(iPropertyDefinitionManager, null, 0);
    }

    protected final void createPDM(IPropertyDefinitionManager iPropertyDefinitionManager, String object, int n2) {
        if (object == null) {
            object = "Properties for unit plugin: " + this.getFormatType();
        }
        this.pdm = new PropertyDefinitionManager(this.type, iPropertyDefinitionManager, (String)object, n2);
    }

    @Override
    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        return this.pdm;
    }

    @Override
    public String getFormatType() {
        return this.type;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public ITypeIdProvider getTypeIdProvider() {
        return null;
    }

    public static boolean checkBytes(byte[] byArray, int n2, byte ... byArray2) {
        return AbstractUnitIdentifier.checkBytes(byArray, n2, true, byArray2);
    }

    public static boolean checkBytes(byte[] byArray, int n2, boolean bl, byte ... byArray2) {
        if (byArray == null || n2 + byArray2.length > byArray.length) {
            return false;
        }
        for (byte by : byArray2) {
            if (bl || byArray[n2] < 65 || byArray[n2] > 90 ? byArray[n2] != by : (byArray[n2] | 0x20) != by) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean checkBytes(byte[] byArray, int n2, int ... nArray) {
        return AbstractUnitIdentifier.checkBytes(byArray, n2, true, ArrayUtil.integersToBytes(nArray));
    }

    public static boolean checkBytes(byte[] byArray, int n2, boolean bl, int ... nArray) {
        return AbstractUnitIdentifier.checkBytes(byArray, n2, bl, ArrayUtil.integersToBytes(nArray));
    }

    public static boolean checkBytes(IInput iInput, int n2, byte ... byArray) {
        boolean bl;
        block11: {
            if (iInput == null || iInput.getHeader() == null) {
                return false;
            }
            if (AbstractUnitIdentifier.checkBytes(iInput.getHeader(), n2, byArray)) {
                return true;
            }
            if (n2 + byArray.length <= iInput.getHeader().limit()) {
                return false;
            }
            InputStream inputStream = iInput.getStream();
            try {
                boolean bl2 = bl = inputStream.skip(n2) == (long)n2 && AbstractUnitIdentifier.checkBytes(inputStream, byArray);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public static boolean checkBytes(IInput iInput, int n2, int ... nArray) {
        return AbstractUnitIdentifier.checkBytes(iInput, n2, ArrayUtil.integersToBytes(nArray));
    }

    public static boolean checkBytes(IInput iInput, int n2, String string) {
        return AbstractUnitIdentifier.checkBytes(iInput, n2, Strings.encodeUTF8(string));
    }

    public static int readHeaderByte(IInput iInput, int n2) {
        if (iInput == null || iInput.getHeader() == null) {
            return -1;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer == null || n2 >= byteBuffer.limit()) {
            return -1;
        }
        return byteBuffer.get(n2);
    }

    private static boolean checkBytes(ByteBuffer byteBuffer, int n2, byte ... byArray) {
        if (byteBuffer == null || n2 + byArray.length > byteBuffer.limit()) {
            return false;
        }
        for (byte by : byArray) {
            if (byteBuffer.get(n2) != by) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean checkBytes(InputStream inputStream, byte ... byArray) throws IOException {
        if (inputStream == null || inputStream.available() < byArray.length) {
            return false;
        }
        for (byte by : byArray) {
            int n2 = inputStream.read();
            if (n2 != -1 && n2 == by) continue;
            return false;
        }
        return true;
    }

    public static byte[] getNonWhitespaceHeader(IInput iInput, int n2, char ... cArray) {
        return AbstractUnitIdentifier.getNonWhitespaceHeader(iInput, n2, false, cArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getNonWhitespaceHeader(IInput iInput, int n2, boolean bl, char ... cArray) {
        ByteBuffer byteBuffer = iInput.getHeader();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (!bl && (long)byArray.length == iInput.getCurrentSize()) {
            return byArray;
        }
        int n3 = AbstractUnitIdentifier.getTextFirstIndex(byArray, 0, cArray);
        if (!bl && n3 + n2 < byArray.length) {
            return byArray;
        }
        try (InputStream inputStream = iInput.getStream();){
            inputStream.skip(n3);
            int n4 = inputStream.read();
            while (Strings.isAsciiWhitespace(n4, cArray)) {
                if (inputStream.available() <= 0) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                n4 = inputStream.read();
            }
            if (n2 == 1) {
                byte[] byArray3 = new byte[]{(byte)n4};
                return byArray3;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(n4);
            for (int i = 1; i < n2; ++i) {
                if (inputStream.available() <= 0) {
                    byte[] byArray4 = byteArrayOutputStream.toByteArray();
                    return byArray4;
                }
                byte by = (byte)inputStream.read();
                byteArrayOutputStream.write(by);
                if (!Strings.isAsciiWhitespace(by, cArray)) continue;
                --i;
            }
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            return byArray5;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static int getTextFirstIndex(byte[] byArray, int n2, char ... cArray) {
        if (n2 == 0 && byArray.length > 4) {
            n2 = Strings.getBOMSize(byArray);
        }
        while (n2 < byArray.length) {
            if (Strings.isAsciiWhitespace(byArray[n2], cArray)) {
                ++n2;
                continue;
            }
            return n2;
        }
        return n2;
    }

    @Override
    public boolean acceptAnyInputBytes() {
        return false;
    }
}

