/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.IUnitContribution;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.IUserDataSupport;
import com.pnfsoftware.jeb.core.UserDataSupport;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.JebEventSource;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterAdapter;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyManager;
import com.pnfsoftware.jeb.core.units.IQuickStateObject;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitInterpreter;
import com.pnfsoftware.jeb.core.units.IUnitLock;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.IUnitNotificationManager;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.PassthroughUnitLock;
import com.pnfsoftware.jeb.core.units.UnitNotificationManager;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.Yl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

@Ser
public abstract class AbstractUnit
extends JebEventSource
implements IUnit {
    private static final ILogger logger = GlobalLog.getLogger(AbstractUnit.class);
    private static Random prng = new Random();
    @SerId(value=1)
    private String formatType;
    @SerId(value=2)
    private long creationTimestamp;
    @SerId(value=3)
    private String name;
    @SerId(value=4)
    private String notes;
    @SerId(value=5)
    private boolean processed;
    @SerId(value=6)
    private String status;
    @SerId(value=7)
    private List<IUnit> persistedChildren = new ArrayList<IUnit>();
    @SerId(value=9)
    private List<IUnitNotification> notifications = new ArrayList<IUnitNotification>();
    @SerId(value=10)
    private IUnitFormatter formatter = new UnitFormatterAdapter();
    @SerId(value=11)
    private IUnitNotificationManager notificationManager = new UnitNotificationManager();
    @SerId(value=12)
    private String realName;
    @SerId(value=13)
    private long uid;
    @SerId(value=14)
    private IUserDataSupport userData = new UserDataSupport();
    @SerTransient
    private List<IUnit> transientChildren = new ArrayList<IUnit>();
    @SerTransient
    private IPropertyDefinitionManager pdm;
    @SerTransient
    private IPropertyManager pm;
    @SerTransient
    private IEventListener pmListener;
    @SerTransient
    private IUnitCreator parent;
    @SerTransient
    private IUnitProcessor unitProcessor;
    @SerTransient
    private List<IUnitContribution> contributions;
    @SerTransient
    private List<IUnitInterpreter> interpreters;
    @SerTransient
    private boolean disposed;
    @SerTransient
    private boolean deserialized;
    @SerTransient
    private List<IUnit> placeholderPersistedChildren;

    private static long genUid() {
        long l2;
        while ((l2 = prng.nextLong()) <= 0L) {
        }
        return l2;
    }

    @SerCustomInitPostGraph
    private void init() {
        if (this.uid == 0L) {
            this.uid = AbstractUnit.genUid();
        }
        if (this.userData == null) {
            this.userData = new UserDataSupport();
        }
        this.transientChildren = new ArrayList<IUnit>();
        this.deserialized = true;
    }

    public AbstractUnit(String string, String string2, IUnit iUnit) {
        this(string, string2, iUnit.getUnitProcessor(), iUnit, iUnit.getPropertyDefinitionManager());
    }

    public AbstractUnit(String string, String string2, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(iUnitCreator);
        this.uid = AbstractUnit.genUid();
        this.parent = iUnitCreator;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("A unit must have a non-empty format type");
        }
        this.formatType = string;
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("A unit must have a non-empty name");
        }
        this.name = string2;
        this.creationTimestamp = System.currentTimeMillis();
        this.notes = "";
        this.unitProcessor = iUnitProcessor;
        this.initializePropertyObjects(iUnitCreator, iUnitProcessor, iPropertyDefinitionManager);
    }

    @Override
    public void initializePropertyObjects(IUnitCreator iUnitCreator, IUnitProcessor iUnitProcessor, IPropertyDefinitionManager iPropertyDefinitionManager) {
        IPropertyManager iPropertyManager;
        IPropertyManager iPropertyManager2 = iPropertyManager = iUnitCreator instanceof IUnit ? ((IUnit)iUnitCreator).getPropertyManager() : iUnitProcessor.getPropertyManager();
        if (iPropertyManager == null) {
            throw new JebRuntimeException(Strings.f("No parent property manager was found for %s", this));
        }
        this.pdm = iPropertyDefinitionManager;
        this.pm = new PropertyManager(iPropertyDefinitionManager, iPropertyManager);
        this.pmListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                if (iEvent instanceof JebEvent && iEvent.getType() == J.PropertyChange && iEvent.getData() instanceof PropertyChangeNotification) {
                    PropertyChangeNotification propertyChangeNotification = (PropertyChangeNotification)iEvent.getData();
                    for (PropertyChangeNotification.Entry entry : propertyChangeNotification.entries()) {
                        AbstractUnit.this.onPropertyChange(entry.getPropertyFullyQualifiedName());
                    }
                }
            }
        };
        this.getPropertyManager().addListener(this.pmListener);
    }

    @Override
    public void postDeserialization(IRuntimeProject iRuntimeProject) {
    }

    public void onPropertyChange(String string) {
    }

    @Override
    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        if (this.isDisposed()) {
            throw new IllegalStateException(Strings.f("%s is disposed", this));
        }
        return this.pdm;
    }

    @Override
    public IPropertyManager getPropertyManager() {
        if (this.isDisposed()) {
            throw new IllegalStateException(Strings.f("%s is disposed", this));
        }
        return this.pm;
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public String getFormatType() {
        return this.formatType;
    }

    @Override
    public byte[] getIconData() {
        return null;
    }

    @Override
    public void setUnitProcessor(IUnitProcessor iUnitProcessor) {
        this.unitProcessor = iUnitProcessor;
    }

    @Override
    public IUnitProcessor getUnitProcessor() {
        return this.unitProcessor;
    }

    @Override
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        try (ACLock aCLock = this.getLock().a();){
            if (string == null || string.length() == 0 || string.equals(this.name)) {
                return;
            }
            this.name = string;
            this.notifyListeners(new JebEvent(J.UnitPropertyChanged));
        }
    }

    @Override
    public String getRealName() {
        return this.realName;
    }

    @Override
    public void setRealName(String string) {
        if (Strings.equals(string, this.realName)) {
            return;
        }
        this.realName = string;
        this.notifyListeners(new JebEvent(J.UnitPropertyChanged));
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.notes)) {
            return;
        }
        this.notes = string;
        this.notifyListeners(new JebEvent(J.UnitPropertyChanged));
    }

    @Override
    public void setParent(IUnitCreator iUnitCreator) {
        this.parent = iUnitCreator;
    }

    @Override
    public IUnitCreator getParent() {
        return this.parent;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public final void setStatus(String string) {
        this.setStatus(string, true);
    }

    public void setStatus(String string, boolean bl) {
        this.status = string;
        if (bl) {
            this.notifyListeners(new JebEvent(J.UnitStatusChanged));
        }
    }

    @Override
    public IUnitLock getLock() {
        return PassthroughUnitLock.getInstance();
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public boolean isStale() {
        return false;
    }

    public final void setProcessed(boolean bl) {
        this.setProcessed(bl, true);
    }

    public void setProcessed(boolean bl, boolean bl2) {
        this.processed = bl;
        if (bl2 && bl) {
            this.notifyListeners(new JebEvent(J.UnitProcessed));
        }
    }

    @Override
    public boolean process() {
        boolean bl;
        if (this.isProcessed()) {
            return true;
        }
        try (ACLock aCLock = this.getLock().a();){
            bl = this.processInternal();
            if (bl) {
                if (this.getStatus() != null) {
                    this.setStatus(null, false);
                }
                this.setProcessed(true);
            } else {
                if (this.getStatus() == null) {
                    this.setStatus("Processing failed", false);
                }
                this.setProcessed(false, false);
            }
        }
        return bl;
    }

    protected boolean processInternal() {
        throw new JebRuntimeException("Override processInternal() [RECOMMENDED] or process() [FOR FINER CONTROL]");
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "%s (%s)\n", this.getName(), this.getFormatType());
        return stringBuilder.toString();
    }

    @Override
    public boolean canBePersisted() {
        return true;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public List<? extends IUnit> getChildren() {
        if (this.persistedChildren == null) {
            return new ArrayList();
        }
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>(this.persistedChildren);
        arrayList.addAll(this.transientChildren);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void addChildUnit(IUnit iUnit) {
        this.addChild(iUnit);
    }

    @Override
    public void addChild(IUnit iUnit) {
        this.addChild(iUnit, true);
    }

    @Override
    public void addChild(IUnit iUnit, boolean bl) {
        this.addChild(iUnit, bl, true);
    }

    protected void addChild(IUnit iUnit, boolean bl, boolean bl2) {
        List<IUnit> list;
        if (iUnit == null) {
            throw new IllegalArgumentException("The child unit is null");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException(Strings.f("%s is disposed", this));
        }
        List<IUnit> list2 = list = bl && iUnit.canBePersisted() ? this.persistedChildren : this.transientChildren;
        if (list.contains(iUnit)) {
            return;
        }
        if (!(iUnit.getParent() == this || iUnit.getParent() instanceof Yl && ((Yl)((Object)iUnit.getParent())).getWrap() == this)) {
            throw new IllegalArgumentException("Parent mismatch for the added unit");
        }
        list.add(iUnit);
        if (bl2) {
            this.notifyListeners(new JebEvent(J.UnitCreated, iUnit));
        }
    }

    @Override
    public boolean isTransientChild(IUnit iUnit) {
        return this.transientChildren.contains(iUnit);
    }

    public synchronized void internalSwapChildren() {
        if (this.placeholderPersistedChildren == null) {
            this.placeholderPersistedChildren = new ArrayList<IUnit>(this.persistedChildren);
            this.persistedChildren.clear();
        } else {
            Assert.a(this.persistedChildren.isEmpty());
            this.persistedChildren.addAll(this.placeholderPersistedChildren);
            this.placeholderPersistedChildren = null;
        }
    }

    @Override
    public void dispose() {
        IUnit iUnit;
        if (this.disposed) {
            return;
        }
        this.getFormatter().discardTransientPresentations();
        if (this.pmListener != null) {
            this.getPropertyManager().removeListener(this.pmListener);
            this.pmListener = null;
        }
        if (this.persistedChildren != null) {
            while (!this.persistedChildren.isEmpty()) {
                iUnit = this.persistedChildren.get(0);
                this.removeChild(iUnit);
            }
        }
        if (this.transientChildren != null) {
            while (!this.transientChildren.isEmpty()) {
                iUnit = this.transientChildren.get(0);
                this.removeChild(iUnit);
            }
        }
        this.persistedChildren = null;
        this.transientChildren = null;
        this.parent = null;
        this.pdm = null;
        this.pm = null;
        this.formatter = null;
        this.notifications = null;
        this.notificationManager = null;
        this.unitProcessor = null;
        this.contributions = null;
        this.interpreters = null;
        this.userData = null;
        this.disposed = true;
        this.notifyListeners(new JebEvent(J.UnitDisposed, this));
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    public boolean isDeserialized() {
        return this.deserialized;
    }

    @Override
    public final void removeChild(IUnit iUnit) {
        this.removeChild(iUnit, true);
    }

    protected void removeChild(IUnit iUnit, boolean bl) {
        List<IUnit> list;
        if (this.isDisposed()) {
            throw new IllegalStateException(Strings.f("%s is disposed", this));
        }
        if (this.persistedChildren.contains(iUnit)) {
            list = this.persistedChildren;
        } else if (this.transientChildren.contains(iUnit)) {
            list = this.transientChildren;
        } else {
            return;
        }
        list.remove(iUnit);
        iUnit.dispose();
        if (bl) {
            this.notifyListeners(new JebEvent(J.UnitDestroyed, iUnit));
        }
    }

    public boolean setChild(IUnit iUnit, IUnit iUnit2) {
        return this.setChild(iUnit, iUnit2, true);
    }

    protected boolean setChild(IUnit iUnit, IUnit iUnit2, boolean bl) {
        List<IUnit> list;
        if (this.isDisposed()) {
            throw new IllegalStateException(Strings.f("%s is disposed", this));
        }
        if (this.persistedChildren.contains(iUnit)) {
            list = this.persistedChildren;
        } else if (this.transientChildren.contains(iUnit)) {
            list = this.transientChildren;
        } else {
            return false;
        }
        if (iUnit2 == null) {
            throw new IllegalArgumentException("The child unit is null");
        }
        if (list == this.persistedChildren && !iUnit2.canBePersisted()) {
            return false;
        }
        if (!(iUnit2.getParent() == this || iUnit2.getParent() instanceof Yl && ((Yl)((Object)iUnit2.getParent())).getWrap() == this)) {
            throw new IllegalArgumentException("Parent mismatch for the added unit");
        }
        int n2 = list.indexOf(iUnit);
        list.set(n2, iUnit2);
        iUnit.dispose();
        if (bl) {
            this.notifyListeners(new JebEvent(J.UnitDestroyed, iUnit));
            this.notifyListeners(new JebEvent(J.UnitCreated, iUnit2));
        }
        return true;
    }

    @Override
    public IUnitFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public IUnitNotificationManager getNotificationManager() {
        if (this.notificationManager == null) {
            this.notificationManager = new UnitNotificationManager();
            if (this.notifications != null) {
                this.notificationManager.addNotifications(this.notifications);
                this.notifications = null;
            }
        }
        return this.notificationManager;
    }

    public final void addNotification(IUnitNotification iUnitNotification) {
        this.getNotificationManager().addNotification(iUnitNotification);
    }

    @Override
    public List<IUnitContribution> getContributions() {
        if (this.contributions == null) {
            this.contributions = new ArrayList<IUnitContribution>();
        }
        return this.contributions;
    }

    @Override
    public List<IUnitInterpreter> getInterpreters() {
        if (this.interpreters == null) {
            this.interpreters = new ArrayList<IUnitInterpreter>();
        }
        return this.interpreters;
    }

    @Override
    public IQuickStateObject generateQuickState() {
        return null;
    }

    public String toString() {
        return Strings.ff("Unit:name={%s},type={%s}", this.getName(), this.getFormatType());
    }

    public void logTrace(String string, Object ... objectArray) {
        UnitUtil.logTrace(this, null, logger, string, objectArray);
    }

    public void logInfo(boolean bl, String string, Object ... objectArray) {
        UnitUtil.logInfo(this, null, bl, logger, string, objectArray);
    }

    public void logWarn(boolean bl, String string, Object ... objectArray) {
        UnitUtil.logWarn(this, null, bl, logger, string, objectArray);
    }

    public void logError(boolean bl, String string, Object ... objectArray) {
        UnitUtil.logError(this, null, bl, logger, string, objectArray);
    }

    public void logException(Exception exception) {
        UnitUtil.logException(this, logger, exception);
    }

    @Override
    public void setData(Object object, Object object2, boolean bl) {
        this.userData.setData(object, object2, bl);
    }

    @Override
    public Object getData(Object object) {
        return this.userData.getData(object);
    }

    @Override
    public void clearAllData(Object object) {
        this.userData.clearAllData(object);
    }

    @Override
    public Map<Object, Object> getAllData() {
        return this.userData.getAllData();
    }
}

