/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyInputSizeHint;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PropertyUtil {
    public static String extractName(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        return string.substring(n2 + 1);
    }

    public static String extractNs(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        return string.substring(0, n2);
    }

    public static String levelUp(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.lastIndexOf(46, n2 - 1);
        if (n3 < 0) {
            return null;
        }
        return string.substring(0, n3) + string.substring(n2);
    }

    public static IPropertyDefinitionManager getRoot(IPropertyDefinitionManager iPropertyDefinitionManager) {
        IPropertyDefinitionManager iPropertyDefinitionManager2;
        while ((iPropertyDefinitionManager2 = iPropertyDefinitionManager.getParent()) != null) {
            iPropertyDefinitionManager = iPropertyDefinitionManager2;
        }
        return iPropertyDefinitionManager;
    }

    public static IPropertyDefinitionManager getNamespace(IPropertyDefinitionManager iPropertyDefinitionManager, String string) {
        if (string.isEmpty()) {
            return PropertyUtil.getRoot(iPropertyDefinitionManager);
        }
        if (string.startsWith(".")) {
            iPropertyDefinitionManager = PropertyUtil.getRoot(iPropertyDefinitionManager);
            string = string.substring(1);
        }
        for (String string2 : string.split("\\.")) {
            if ((iPropertyDefinitionManager = iPropertyDefinitionManager.getChild(string2)) != null) continue;
            return null;
        }
        return iPropertyDefinitionManager;
    }

    public static IPropertyDefinition getDefinition(IPropertyDefinitionManager iPropertyDefinitionManager, String string) {
        if (!string.startsWith(".")) {
            throw new IllegalArgumentException("Illegal fully-qualified name for perperty: " + string);
        }
        iPropertyDefinitionManager = PropertyUtil.getRoot(iPropertyDefinitionManager);
        String[] stringArray = Strings.splitall(string.substring(1), "\\.");
        for (int i = 0; i < stringArray.length - 1 && (iPropertyDefinitionManager = iPropertyDefinitionManager.getChild(stringArray[i])) != null; ++i) {
        }
        if (iPropertyDefinitionManager == null) {
            return null;
        }
        String string2 = stringArray[stringArray.length - 1];
        return iPropertyDefinitionManager.getDefinition(string2);
    }

    public static String formatList(IPropertyDefinitionManager iPropertyDefinitionManager, boolean bl) {
        TextBuilder textBuilder = new TextBuilder(2);
        ArrayList<IPropertyDefinitionManager> arrayList = new ArrayList<IPropertyDefinitionManager>();
        arrayList.add(iPropertyDefinitionManager);
        while (!arrayList.isEmpty()) {
            iPropertyDefinitionManager = (IPropertyDefinitionManager)arrayList.remove(0);
            ArrayList<IPropertyDefinition> arrayList2 = new ArrayList<IPropertyDefinition>(iPropertyDefinitionManager.getDefinitions());
            if (bl) {
                Collections.sort(arrayList2, new Comparator<IPropertyDefinition>(){

                    @Override
                    public int compare(IPropertyDefinition iPropertyDefinition, IPropertyDefinition iPropertyDefinition2) {
                        return iPropertyDefinition.getName().compareToIgnoreCase(iPropertyDefinition2.getName());
                    }
                });
            }
            for (IPropertyDefinition iPropertyDefinition : arrayList2) {
                String string = iPropertyDefinitionManager.getNamespace() + "." + iPropertyDefinition.getName();
                Strings.ff(textBuilder, "%s: %s\n", string, iPropertyDefinition.getType());
            }
            arrayList.addAll(iPropertyDefinitionManager.getChildren());
        }
        return textBuilder.toString();
    }

    public static String formatTree(IPropertyDefinitionManager iPropertyDefinitionManager, boolean bl) {
        TextBuilder textBuilder = new TextBuilder(2);
        PropertyUtil.formatTreeRecurse(textBuilder, iPropertyDefinitionManager, bl);
        return textBuilder.toString();
    }

    private static void formatTreeRecurse(TextBuilder textBuilder, IPropertyDefinitionManager iPropertyDefinitionManager, boolean bl) {
        String string = iPropertyDefinitionManager.getRegion();
        if (iPropertyDefinitionManager.isRoot()) {
            string = "<root>";
        }
        textBuilder.appendLine(string, new Object[0]);
        textBuilder.indent();
        ArrayList<IPropertyDefinition> arrayList = new ArrayList<IPropertyDefinition>(iPropertyDefinitionManager.getDefinitions());
        if (bl) {
            Collections.sort(arrayList, new Comparator<IPropertyDefinition>(){

                @Override
                public int compare(IPropertyDefinition iPropertyDefinition, IPropertyDefinition iPropertyDefinition2) {
                    return iPropertyDefinition.getName().compareToIgnoreCase(iPropertyDefinition2.getName());
                }
            });
        }
        for (IPropertyDefinition object : arrayList) {
            Strings.ff(textBuilder, "%s: %s\n", object.getName(), object.getType());
        }
        for (IPropertyDefinitionManager iPropertyDefinitionManager2 : iPropertyDefinitionManager.getChildren()) {
            PropertyUtil.formatTreeRecurse(textBuilder, iPropertyDefinitionManager2, bl);
        }
        textBuilder.unindent();
    }

    public static <V extends Enum<V>> V convertSelectionId(int n2, Class<V> clazz) {
        return PropertyUtil.convertSelectionId(n2, clazz, null);
    }

    public static <V extends Enum<V>> V convertSelectionId(int n2, Class<V> clazz, V v2) {
        if (clazz.isEnum()) {
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            if (n2 >= 0 && n2 < enumArray.length) {
                return (V)enumArray[n2];
            }
        }
        return v2;
    }

    public static boolean hasDescendants(IPropertyDefinitionManager iPropertyDefinitionManager) {
        if (iPropertyDefinitionManager.hasDefinitions()) {
            return true;
        }
        for (IPropertyDefinitionManager iPropertyDefinitionManager2 : iPropertyDefinitionManager.getChildren()) {
            if (!PropertyUtil.hasDescendants(iPropertyDefinitionManager2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDescendants(IPropertyDefinitionManager iPropertyDefinitionManager, int n2, int n3) {
        for (IPropertyDefinition object : iPropertyDefinitionManager.getDefinitions()) {
            if ((object.getFlags() & n2) != n2 || (object.getFlags() & n3) != 0) continue;
            return true;
        }
        for (IPropertyDefinitionManager iPropertyDefinitionManager2 : iPropertyDefinitionManager.getChildren()) {
            if (!PropertyUtil.hasDescendants(iPropertyDefinitionManager2, n2, n3)) continue;
            return true;
        }
        return false;
    }

    public static PropertyInputSizeHint getSizeHint(int n2) {
        if ((n2 & 0x10) != 0) {
            return PropertyInputSizeHint.TINY;
        }
        if ((n2 & 0x20) != 0) {
            return PropertyInputSizeHint.SMALL;
        }
        if ((n2 & 0x40) != 0) {
            return PropertyInputSizeHint.LARGE;
        }
        if ((n2 & 0x80) != 0) {
            return PropertyInputSizeHint.EXTRA;
        }
        return PropertyInputSizeHint.MEDIUM;
    }
}

