/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeString;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Map;
import java.util.WeakHashMap;

public final class PropertyTypeString
implements IPropertyTypeString {
    private static Map<PropertyTypeString, PropertyTypeString> map = new WeakHashMap<PropertyTypeString, PropertyTypeString>();
    private int min;
    private int max;
    private String def;

    public static PropertyTypeString create(int n2, int n3, String string) {
        if (string == null) {
            throw new RuntimeException("Default value cannot be null");
        }
        if (string.length() < n2 || string.length() > n3) {
            throw new IllegalArgumentException("Default value is out of range");
        }
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("The range is invalid");
        }
        PropertyTypeString propertyTypeString = new PropertyTypeString(n2, n3, string);
        PropertyTypeString propertyTypeString2 = map.get(propertyTypeString);
        if (propertyTypeString2 == null) {
            propertyTypeString2 = propertyTypeString;
            map.put(propertyTypeString2, propertyTypeString);
        }
        return propertyTypeString2;
    }

    public static PropertyTypeString create(String string) {
        return PropertyTypeString.create(0, Integer.MAX_VALUE, string);
    }

    public static PropertyTypeString create() {
        return PropertyTypeString.create(0, Integer.MAX_VALUE, "");
    }

    private PropertyTypeString(int n2, int n3, String string) {
        this.min = n2;
        this.max = n3;
        this.def = string;
    }

    @Override
    public String getName() {
        return "String";
    }

    @Override
    public int getMinLength() {
        return this.min;
    }

    @Override
    public int getMaxLength() {
        return this.max;
    }

    @Override
    public String getDefault() {
        return this.def;
    }

    @Override
    public boolean validate(Object object) {
        String string = object.toString();
        return string.length() >= this.min && string.length() <= this.max;
    }

    @Override
    public Object afterRead(IPropertyDefinition iPropertyDefinition, Object object) {
        if ((iPropertyDefinition.getFlags() & 4) != 0) {
            object = Strings.urldecodeUTF8(object.toString());
        }
        if (object instanceof CharSequence) {
            return object.toString();
        }
        return object;
    }

    @Override
    public Object beforeWrite(IPropertyDefinition iPropertyDefinition, Object object) {
        if ((iPropertyDefinition.getFlags() & 4) != 0) {
            object = Strings.urlencodeUTF8(object.toString());
        }
        return object;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.def == null ? 0 : this.def.hashCode());
        n2 = 31 * n2 + this.max;
        n2 = 31 * n2 + this.min;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyTypeString propertyTypeString = (PropertyTypeString)object;
        if (this.def == null ? propertyTypeString.def != null : !this.def.equals(propertyTypeString.def)) {
            return false;
        }
        if (this.max != propertyTypeString.max) {
            return false;
        }
        return this.min == propertyTypeString.min;
    }

    public String toString() {
        return this.getName() + "(\"" + this.getDefault() + "\")";
    }
}

