/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeInteger;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyTypeSelection
implements IPropertyTypeInteger {
    List<E> entries;
    E def;
    private Set<Integer> ids;

    PropertyTypeSelection(List<E> list, E e) {
        this.entries = list;
        this.def = e;
        this.ids = new HashSet<Integer>(list.size());
        for (E e2 : list) {
            if (this.ids.add(e2.id)) continue;
            throw new RuntimeException();
        }
    }

    @Override
    public String getName() {
        return "Selection";
    }

    public List<E> getEntries() {
        return this.entries;
    }

    @Override
    public int getMin() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getMax() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Integer getDefault() {
        return this.def == null ? 0 : this.def.id;
    }

    @Override
    public boolean validate(Object object) {
        try {
            int n2 = Integer.parseInt(object.toString());
            return this.ids.contains(n2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object afterRead(IPropertyDefinition iPropertyDefinition, Object object) {
        if (object instanceof Integer) {
            return object;
        }
        if (object instanceof CharSequence) {
            return Integer.parseInt(object.toString());
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        Strings.ff(stringBuilder, "(%d)", (int)this.getDefault());
        stringBuilder.append("{");
        int n2 = 0;
        for (E e : this.getEntries()) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            Strings.ff(stringBuilder, "%s(%d)", e.value, e.id);
            ++n2;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class Builder {
        List<E> entries = new ArrayList<E>();
        E def;

        public static Builder create() {
            return new Builder();
        }

        Builder() {
        }

        public Builder addDefaultEntry(int n2, String string, String string2) {
            E e;
            this.def = e = this.add(n2, string, string2);
            return this;
        }

        public Builder addEntry(int n2, String string, String string2) {
            this.add(n2, string, string2);
            return this;
        }

        private E add(int n2, String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("Null value");
            }
            for (E e : this.entries) {
                if (e.id != n2 && !e.value.equals(string)) continue;
                throw new IllegalArgumentException("Duplicate entry: " + e);
            }
            E e = new E(n2, string, string2);
            this.entries.add(e);
            return e;
        }

        public Builder setDefault(E e) {
            if (e != null && !this.entries.contains(e)) {
                throw new IllegalArgumentException("Default entry must be registered first");
            }
            this.def = e;
            return this;
        }

        public Builder setDefault(int n2) {
            for (E e : this.entries) {
                if (e.id != n2) continue;
                this.def = e;
                return this;
            }
            throw new IllegalArgumentException("Cannot find entry with id " + n2);
        }

        public PropertyTypeSelection build() {
            return new PropertyTypeSelection(this.entries, this.def);
        }
    }

    public static class E {
        int id;
        String value;
        String description;

        E(int n2, String string, String string2) {
            this.id = n2;
            this.value = string;
            this.description = string2;
        }

        public int getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return Strings.ff("%d:%s(%s)", this.id, this.value, this.description);
        }
    }
}

