/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeInteger;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Map;
import java.util.WeakHashMap;

public final class PropertyTypeInteger
implements IPropertyTypeInteger {
    private static Map<PropertyTypeInteger, PropertyTypeInteger> map = new WeakHashMap<PropertyTypeInteger, PropertyTypeInteger>();
    private int min;
    private int max;
    private Integer def;

    public static PropertyTypeInteger create(int n2, int n3, Integer n4) {
        if (n4 == null) {
            throw new RuntimeException("Default value cannot be null");
        }
        if (n4 < n2 || n4 > n3) {
            throw new IllegalArgumentException("Default value is out of range");
        }
        PropertyTypeInteger propertyTypeInteger = new PropertyTypeInteger(n2, n3, n4);
        PropertyTypeInteger propertyTypeInteger2 = map.get(propertyTypeInteger);
        if (propertyTypeInteger2 == null) {
            propertyTypeInteger2 = propertyTypeInteger;
            map.put(propertyTypeInteger2, propertyTypeInteger);
        }
        return propertyTypeInteger2;
    }

    public static PropertyTypeInteger create() {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    }

    public static PropertyTypeInteger create(Integer n2) {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, Integer.MAX_VALUE, n2);
    }

    public static PropertyTypeInteger createPositive(Integer n2) {
        return PropertyTypeInteger.create(1, Integer.MAX_VALUE, n2);
    }

    public static PropertyTypeInteger createPositiveOrZero(Integer n2) {
        return PropertyTypeInteger.create(0, Integer.MAX_VALUE, n2);
    }

    public static PropertyTypeInteger createNegative(Integer n2) {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, -1, n2);
    }

    public static PropertyTypeInteger createNegativeOrZero(Integer n2) {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, 0, n2);
    }

    private PropertyTypeInteger(int n2, int n3, Integer n4) {
        this.min = n2;
        this.max = n3;
        this.def = n4;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public Integer getDefault() {
        return this.def;
    }

    @Override
    public boolean validate(Object object) {
        try {
            int n2 = Integer.parseInt(object.toString());
            return n2 >= this.min && n2 <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object afterRead(IPropertyDefinition iPropertyDefinition, Object object) {
        if (object instanceof Integer) {
            return object;
        }
        if (object instanceof CharSequence) {
            return Integer.parseInt(object.toString());
        }
        return object;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.def == null ? 0 : this.def.hashCode());
        n2 = 31 * n2 + this.max;
        n2 = 31 * n2 + this.min;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyTypeInteger propertyTypeInteger = (PropertyTypeInteger)object;
        if (this.def == null ? propertyTypeInteger.def != null : !this.def.equals(propertyTypeInteger.def)) {
            return false;
        }
        if (this.max != propertyTypeInteger.max) {
            return false;
        }
        return this.min == propertyTypeInteger.min;
    }

    public String toString() {
        String string = this.getName() + "(" + this.getDefault() + ")";
        if (this.min != Integer.MIN_VALUE && this.max != Integer.MAX_VALUE) {
            string = string + Strings.ff("{%d-%d}", this.min, this.max);
        } else if (this.min != Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            string = string + Strings.ff("{%d+}", this.min);
        } else if (this.min == Integer.MIN_VALUE && this.max != Integer.MAX_VALUE) {
            string = string + Strings.ff("{%d-}", this.max);
        }
        return string;
    }
}

