/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.properties.IConfiguration;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.CommonsConfigurationWrapper;
import com.pnfsoftware.jeb.core.properties.impl.PropertyChangeObject;
import com.pnfsoftware.jeb.core.properties.impl.PropertyUtil;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.concurrent.atomic.AtomicInteger;

@SerDisabled
public class PropertyManager
extends EventSource
implements IPropertyManager {
    private static final ILogger logger = GlobalLog.getLogger(PropertyManager.class);
    IPropertyDefinitionManager pdm;
    IConfiguration config;
    IPropertyManager master;
    IEventListener listener;
    private static AtomicInteger gid = new AtomicInteger();
    private int id = gid.getAndIncrement();
    private String ownerName = "PM";

    public PropertyManager(IPropertyDefinitionManager iPropertyDefinitionManager, IConfiguration iConfiguration, IPropertyManager iPropertyManager) {
        this.pdm = iPropertyDefinitionManager;
        this.config = iConfiguration;
        this.master = iPropertyManager;
        if (iPropertyManager != null) {
            this.listener = EventSource.relay(iPropertyManager, this);
        }
    }

    public PropertyManager(IPropertyDefinitionManager iPropertyDefinitionManager, IConfiguration iConfiguration) {
        this(iPropertyDefinitionManager, iConfiguration, null);
    }

    public PropertyManager(IPropertyDefinitionManager iPropertyDefinitionManager, IPropertyManager iPropertyManager) {
        this(iPropertyDefinitionManager, null, iPropertyManager);
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            this.master.removeListener(this.listener);
        }
    }

    @Override
    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        return this.pdm;
    }

    @Override
    public IConfiguration getConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        return this.master.getConfiguration();
    }

    @Override
    public Object getValue(String string) {
        return this.getValue(string, 3, true, true);
    }

    @Override
    public Object getValue(String string, int n2, boolean bl, boolean bl2) {
        IPropertyDefinition iPropertyDefinition;
        String string2 = this.genFqn(string);
        if (string2 == null) {
            return null;
        }
        Object object = null;
        if (this.config != null) {
            object = this.config.getProperty(string2);
        }
        if (object == null && this.master != null && n2 >= 2) {
            object = this.master.getValue(string2, n2, false, bl2);
        }
        IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition = this.pdm == null ? null : PropertyUtil.getDefinition(this.pdm, string2);
        if (iPropertyDefinition != null) {
            String string3;
            IPropertyDefinitionManager iPropertyDefinitionManager;
            if (object == null && n2 >= 3 && (iPropertyDefinitionManager = iPropertyDefinition.getManager()) != null && (iPropertyDefinitionManager.getFlags() & 1) != 0 && (string3 = PropertyUtil.levelUp(string2)) != null) {
                object = this.getValue(string3, n2, bl, bl2);
            }
            if (object == null && bl) {
                object = iPropertyDefinition.getType().getDefault();
            }
            if (object != null && bl2) {
                if (!iPropertyDefinition.getType().validate(object)) {
                    return null;
                }
                object = iPropertyDefinition.getType().afterRead(iPropertyDefinition, object);
            }
        }
        return object;
    }

    @Override
    public boolean setValue(String string, Object object) {
        return this.setValue(string, object, true, null);
    }

    @Override
    public boolean setValue(String string, Object object, boolean bl, PropertyChangeObject propertyChangeObject) {
        String string2 = this.genFqn(string);
        if (string2 == null) {
            return false;
        }
        if (this.config != null) {
            IPropertyDefinition iPropertyDefinition;
            IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition = this.pdm == null ? null : PropertyUtil.getDefinition(this.pdm, string2);
            if (object == null) {
                if (propertyChangeObject == null) {
                    this.config.clearProperty(string2);
                    this.notifyListeners(new JebEvent(J.PropertyChange, new PropertyChangeNotification(string2, null, iPropertyDefinition)));
                } else {
                    propertyChangeObject.add(this, string2, null, iPropertyDefinition);
                }
                return true;
            }
            if (iPropertyDefinition != null) {
                if (bl && !iPropertyDefinition.getType().validate(object)) {
                    (new Object[1])[0] = iPropertyDefinition;
                    return false;
                }
                object = iPropertyDefinition.getType().beforeWrite(iPropertyDefinition, object);
            }
            if (propertyChangeObject == null) {
                this.config.setProperty(string2, object);
                this.notifyListeners(new JebEvent(J.PropertyChange, new PropertyChangeNotification(string2, object, iPropertyDefinition)));
                if (this.config instanceof CommonsConfigurationWrapper) {
                    this.config.setProperty("", "");
                }
            } else {
                propertyChangeObject.add(this, string2, object, iPropertyDefinition);
            }
            return true;
        }
        if (this.master != null) {
            return this.master.setValue(string2, object, bl, propertyChangeObject);
        }
        return false;
    }

    private String genFqn(String string) {
        if (string.startsWith(".")) {
            return string;
        }
        if (this.pdm == null) {
            return null;
        }
        return this.pdm.getNamespace() + "." + string;
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        Object object = this.getValue(string);
        if (object == null) {
            (new Object[1])[0] = string;
            return bl;
        }
        return Boolean.parseBoolean(object.toString());
    }

    @Override
    public Boolean getBooleanUnsafe(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            (new Object[1])[0] = string;
            return null;
        }
        return Boolean.parseBoolean(object.toString());
    }

    @Override
    public boolean setBoolean(String string, Boolean bl) {
        return this.setBoolean(string, bl, null);
    }

    @Override
    public boolean setBoolean(String string, Boolean bl, PropertyChangeObject propertyChangeObject) {
        return this.setValue(string, bl, true, propertyChangeObject);
    }

    @Override
    public int getInteger(String string) {
        return this.getInteger(string, 0);
    }

    @Override
    public int getInteger(String string, int n2) {
        Object object = this.getValue(string);
        if (object == null) {
            (new Object[1])[0] = string;
            return n2;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    @Override
    public Integer getIntegerUnsafe(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            (new Object[1])[0] = string;
            return null;
        }
        return Integer.parseInt(object.toString());
    }

    @Override
    public boolean setInteger(String string, Integer n2) {
        return this.setInteger(string, n2, null);
    }

    @Override
    public boolean setInteger(String string, Integer n2, PropertyChangeObject propertyChangeObject) {
        return this.setValue(string, n2, true, propertyChangeObject);
    }

    @Override
    public String getString(String string) {
        return this.getString(string, "");
    }

    @Override
    public String getString(String string, String string2) {
        Object object = this.getValue(string);
        if (object == null) {
            (new Object[1])[0] = string;
            return string2;
        }
        return object.toString();
    }

    @Override
    public String getStringUnsafe(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            (new Object[1])[0] = string;
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setString(String string, String string2) {
        return this.setValue(string, string2, true, null);
    }

    @Override
    public boolean setString(String string, String string2, PropertyChangeObject propertyChangeObject) {
        return this.setValue(string, string2, true, propertyChangeObject);
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String toString() {
        String string = "PM_" + this.id;
        if (this.master != null) {
            IPropertyManager iPropertyManager = this.master;
            while (iPropertyManager instanceof PropertyManager) {
                string = string + ">" + ((PropertyManager)iPropertyManager).id;
                iPropertyManager = ((PropertyManager)iPropertyManager).master;
            }
        }
        if (this.pdm != null) {
            string = string + "|PDM:" + this.pdm.getRegion();
        }
        if (this.ownerName != null) {
            string = string + "|" + this.ownerName;
        }
        return string;
    }
}

