/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionGroup;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyType;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinition;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PropertyDefinitionManager
implements IPropertyDefinitionManager {
    private static final ILogger logger = GlobalLog.getLogger(PropertyDefinitionManager.class);
    private int flags;
    private String description;
    private String region;
    private IPropertyDefinitionManager parent;
    private Map<String, IPropertyDefinitionManager> children = new LinkedHashMap<String, IPropertyDefinitionManager>();
    private Map<String, IPropertyDefinition> definitions = new LinkedHashMap<String, IPropertyDefinition>();
    private Map<String, IPropertyDefinitionGroup> groups = new LinkedHashMap<String, IPropertyDefinitionGroup>();

    public PropertyDefinitionManager(String string, IPropertyDefinitionManager iPropertyDefinitionManager, String string2, int n2) {
        if (string != null && !PropertyDefinitionManager.isValidRegionName(string)) {
            throw new IllegalArgumentException(string + " is an invalid region name: it must be a valid Java identifier name");
        }
        if (string == null) {
            string = "";
        }
        this.region = string;
        this.description = string2;
        this.flags = n2;
        if (iPropertyDefinitionManager != null) {
            this.attachToParent(iPropertyDefinitionManager);
        }
        this.groups.put("", new Group());
    }

    public PropertyDefinitionManager(String string, IPropertyDefinitionManager iPropertyDefinitionManager) {
        this(string, iPropertyDefinitionManager, null, 0);
    }

    public PropertyDefinitionManager(String string) {
        this(string, null);
    }

    public PropertyDefinitionManager() {
        this(null, null);
    }

    @Override
    public void attachToParent(IPropertyDefinitionManager iPropertyDefinitionManager) {
        if (iPropertyDefinitionManager == null || iPropertyDefinitionManager == this) {
            throw new IllegalArgumentException("Invalid parent");
        }
        if (this.parent != null) {
            throw new IllegalStateException("PDM already has a parent");
        }
        if (this.region == null) {
            throw new IllegalStateException("A root PDM cannot have a parent");
        }
        if (!iPropertyDefinitionManager.registerChild(this)) {
            throw new RuntimeException("Could not be registered as a child of the provided parent");
        }
        this.parent = iPropertyDefinitionManager;
    }

    @Override
    public boolean registerChild(IPropertyDefinitionManager iPropertyDefinitionManager) {
        if (this.children.containsKey(iPropertyDefinitionManager.getRegion())) {
            return false;
        }
        this.children.put(iPropertyDefinitionManager.getRegion(), iPropertyDefinitionManager);
        return true;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public boolean isRoot() {
        return this.region.length() == 0;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IPropertyDefinitionManager getParent() {
        return this.parent;
    }

    @Override
    public String getNamespace() {
        if (this.parent == null) {
            if (this.region.isEmpty()) {
                return this.region;
            }
            return "." + this.region;
        }
        return this.parent.getNamespace() + "." + this.region;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public Collection<IPropertyDefinitionManager> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    @Override
    public IPropertyDefinitionManager getChild(String string) {
        return this.children.get(string);
    }

    @Override
    public boolean hasDefinitions() {
        return !this.definitions.isEmpty();
    }

    @Override
    public IPropertyDefinition getDefinition(String string) {
        return this.definitions.get(string);
    }

    @Override
    public Collection<IPropertyDefinition> getDefinitions() {
        return Collections.unmodifiableCollection(this.definitions.values());
    }

    @Override
    public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2) {
        return this.addDefinition(string, iPropertyType, string2, 0, true, null);
    }

    @Override
    public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2, int n2) {
        return this.addDefinition(string, iPropertyType, string2, n2, true, null);
    }

    @Override
    public IPropertyDefinition addInternalDefinition(String string, IPropertyType iPropertyType) {
        return this.addDefinition(string, iPropertyType, null, 1, true, null);
    }

    @Override
    public IPropertyDefinition addInternalDefinition(String string, IPropertyType iPropertyType, String string2) {
        return this.addDefinition(string, iPropertyType, string2, 1, true, null);
    }

    IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2, int n2, boolean bl, String string3) {
        IPropertyDefinition iPropertyDefinition = this.definitions.get(string = this.simplifyName(string));
        if (iPropertyDefinition != null && !bl) {
            throw new RuntimeException("A property definition with that name already exists.");
        }
        if (!PropertyDefinitionManager.isValidPropertyName(string)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        if (string2 == null && iPropertyDefinition != null) {
            string2 = iPropertyDefinition.getDescription();
        }
        PropertyDefinition propertyDefinition = new PropertyDefinition(this, string, string2, iPropertyType, n2);
        this.definitions.put(string, propertyDefinition);
        if (string3 == null) {
            string3 = "";
        }
        ((Group)this.groups.get((Object)string3)).defs.add(propertyDefinition);
        return propertyDefinition;
    }

    private String simplifyName(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return string;
        }
        String string2 = string.substring(n2 + 1);
        String string3 = this.getNamespace() + "." + string2;
        if (!string.equals(string3)) {
            String string4 = Strings.ff("Inconsistent fully-qualified name for property definition: %s (expected: %s)", string, string3);
            logger.warn(string4, new Object[0]);
        }
        return string2;
    }

    @Override
    public void removeDefinition(String string) {
        string = this.simplifyName(string);
        this.definitions.remove(string);
        for (IPropertyDefinitionGroup iPropertyDefinitionGroup : this.groups.values()) {
            iPropertyDefinitionGroup.removeDefinition(string);
        }
    }

    private static boolean isValidRegionName(String string) {
        if (string.length() <= 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPropertyName(String string) {
        if (string.length() <= 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Strings.ff("PDM:%s:%d", Strings.safe2(this.region, "<root>"), this.children.size());
    }

    @Override
    public IPropertyDefinitionGroup addGroup(String string) {
        if (this.groups.containsKey(string)) {
            throw new IllegalArgumentException("Group already exists: " + string);
        }
        Group group = new Group(string);
        this.groups.put(string, group);
        return group;
    }

    @Override
    public Collection<IPropertyDefinitionGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public IPropertyDefinitionGroup getGroup(String string) {
        return this.groups.get(string);
    }

    @Override
    public boolean removeGroup(String string) {
        if (Strings.isBlank(string)) {
            return false;
        }
        IPropertyDefinitionGroup iPropertyDefinitionGroup = this.groups.remove(string);
        if (iPropertyDefinitionGroup == null) {
            return false;
        }
        Group group = (Group)this.groups.get("");
        for (IPropertyDefinition iPropertyDefinition : iPropertyDefinitionGroup.getDefinitions()) {
            group.defs.add(iPropertyDefinition);
        }
        return true;
    }

    class Group
    implements IPropertyDefinitionGroup {
        String grpname;
        List<IPropertyDefinition> defs = new ArrayList<IPropertyDefinition>();

        Group() {
            this.grpname = "";
        }

        Group(String string) {
            if (Strings.isBlank(string)) {
                throw new IllegalArgumentException("Illegal group name: " + string);
            }
            this.grpname = string;
        }

        @Override
        public String getName() {
            return this.grpname;
        }

        @Override
        public List<IPropertyDefinition> getDefinitions() {
            return Collections.unmodifiableList(this.defs);
        }

        @Override
        public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2, int n2) {
            return PropertyDefinitionManager.this.addDefinition(string, iPropertyType, string2, n2, true, this.grpname);
        }

        @Override
        public void removeDefinition(String string) {
            Iterator<IPropertyDefinition> iterator = this.defs.iterator();
            while (iterator.hasNext()) {
                if (!Strings.equals(string, iterator.next().getName())) continue;
                iterator.remove();
            }
        }
    }
}

