/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.properties.IConfiguration;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.CommonsConfigurationWrapper;
import com.pnfsoftware.jeb.util.collect.Maps;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class PropertyChangeObject {
    private Map<String, Object> entries = new HashMap<String, Object>();
    private Map<IPropertyManager, List<Entry>> map = new IdentityHashMap<IPropertyManager, List<Entry>>();

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean has(String string) {
        return this.entries.containsKey(string);
    }

    public Object get(String string) {
        return this.entries.get(string);
    }

    public Entry add(IPropertyManager iPropertyManager, String string, Object object, IPropertyDefinition iPropertyDefinition) {
        if (iPropertyManager == null || string == null || iPropertyDefinition == null) {
            throw new IllegalArgumentException();
        }
        Entry entry = new Entry();
        entry.fqname = string;
        entry.value = object;
        entry.pd = iPropertyDefinition;
        if (this.entries.put(string, object) != null) {
            List<Entry> list = this.map.get(iPropertyManager);
            int n2 = 0;
            for (Entry entry2 : list) {
                if (entry2.fqname.equals(string)) break;
                ++n2;
            }
            if (n2 < list.size()) {
                list.remove(n2);
            }
        }
        Maps.putMulti(this.map, iPropertyManager, entry);
        return entry;
    }

    public void commit() {
        this.commit(true);
    }

    public void commit(boolean bl) {
        for (IPropertyManager iPropertyManager : this.map.keySet()) {
            IConfiguration iConfiguration = iPropertyManager.getConfiguration();
            PropertyChangeNotification propertyChangeNotification = new PropertyChangeNotification();
            for (Entry entry : this.map.get(iPropertyManager)) {
                if (entry.value == null) {
                    iConfiguration.clearProperty(entry.fqname);
                } else {
                    iConfiguration.setProperty(entry.fqname, entry.value.toString());
                }
                propertyChangeNotification.add(entry.fqname, entry.value, entry.pd);
            }
            if (iConfiguration instanceof CommonsConfigurationWrapper) {
                iConfiguration.setProperty("", "");
            }
            iPropertyManager.notifyListeners(new JebEvent(J.PropertyChange, propertyChangeNotification));
        }
        this.map.clear();
        this.entries.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IPropertyManager iPropertyManager : this.map.keySet()) {
            for (Entry entry : this.map.get(iPropertyManager)) {
                stringBuilder.append(entry.fqname).append(",");
            }
        }
        return stringBuilder.toString();
    }

    public static class Entry {
        String fqname;
        Object value;
        IPropertyDefinition pd;
    }
}

