/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IConfiguration;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Ser
public class ConfigurationMemoryMap
implements IConfiguration {
    @SerId(value=1)
    private Map<String, Object> map = new HashMap<String, Object>();

    public ConfigurationMemoryMap() {
    }

    public ConfigurationMemoryMap(IConfiguration iConfiguration) {
        for (String string : iConfiguration.getAllPropertyKeys()) {
            if (Strings.isBlank(string)) continue;
            this.map.put(string, iConfiguration.getProperty(string));
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        this.map.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.map.get(string);
    }

    @Override
    public void clearProperty(String string) {
        this.map.remove(string);
    }

    @Override
    public Set<String> getAllPropertyKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public String toString() {
        return Strings.ff("cfg:size=%d,keys=%s", this.map.size(), this.map.keySet());
    }
}

