/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.tree.impl;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.core.output.tree.impl.NodeCoordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@Ser
public abstract class AbstractTreeDocument
extends EventSource
implements ITreeDocument {
    @Override
    public void dispose() {
    }

    @Override
    public IPropertyManager getPropertyManager() {
        return null;
    }

    @Override
    public List<String> getColumnLabels() {
        return null;
    }

    @Override
    public int getInitialExpansionLevel() {
        return 0;
    }

    @Override
    public String coordinatesToAddress(INodeCoordinates iNodeCoordinates) {
        if (iNodeCoordinates == null) {
            return null;
        }
        return AbstractTreeDocument.formatIntegerList(iNodeCoordinates.getPath());
    }

    @Override
    public INodeCoordinates addressToCoordinates(String string) {
        if (string == null) {
            return null;
        }
        List<Integer> list = AbstractTreeDocument.parseIntegerList(string);
        if (list == null) {
            return null;
        }
        return new NodeCoordinates(list);
    }

    static String formatIntegerList(List<Integer> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : list) {
            if (n2 >= 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(n3);
            ++n2;
        }
        return stringBuilder.toString();
    }

    static List<Integer> parseIntegerList(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : string.split(",")) {
            try {
                int n2 = Integer.parseInt(string2.trim());
                arrayList.add(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return arrayList;
    }

    public String coordinatesToAddress(INodeCoordinates iNodeCoordinates, Function<List<INode>, String> function) {
        if (iNodeCoordinates == null || iNodeCoordinates.getPath() == null || iNodeCoordinates.getPath().isEmpty()) {
            return null;
        }
        ArrayList<INode> arrayList = new ArrayList<INode>();
        INode iNode = this.getRoots().get(0);
        arrayList.add(iNode);
        if (iNode == null) {
            return function.apply(arrayList);
        }
        for (int i = 1; i < iNodeCoordinates.getPath().size(); ++i) {
            int n2 = iNodeCoordinates.getPath().get(i);
            if (n2 < 0 || n2 >= iNode.getChildren().size()) {
                return function.apply(arrayList);
            }
            iNode = iNode.getChildren().get(n2);
            arrayList.add(iNode);
            if (iNode != null) continue;
            return function.apply(arrayList);
        }
        return function.apply(arrayList);
    }
}

