/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.tree;

import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPackage;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CodeNodeUtil {
    public static final int IS_ARTIFICIAL = 16;
    public static final int IS_INTERNAL = 256;
    public static final int IS_PACKAGE = 32768;
    public static final int IS_TYPE = 65536;
    public static final int IS_CLASS = 131072;
    public static final int IS_FIELD = 262144;
    public static final int IS_METHOD = 524288;

    public static boolean meetsConditions(ICodeNode iCodeNode, int n2, int n3) {
        ICodeItem iCodeItem = iCodeNode.getObject();
        int n4 = 0;
        if (iCodeItem instanceof ICodePackage) {
            n4 |= 0x8000;
        }
        if (iCodeItem instanceof ICodeType) {
            n4 |= 0x10000;
        }
        if (iCodeItem instanceof ICodeClass) {
            n4 |= 0x20000;
        }
        if (iCodeItem instanceof ICodeField) {
            n4 |= 0x40000;
        }
        if (iCodeItem instanceof ICodeMethod) {
            n4 |= 0x80000;
        }
        if ((iCodeItem.getGenericFlags() & Integer.MIN_VALUE) != 0) {
            n4 |= 0x100;
        }
        if ((iCodeItem.getGenericFlags() & 0x40000000) != 0) {
            n4 |= 0x10;
        }
        return (n4 & n2) == n2 && (n4 & n3) == 0;
    }

    public static boolean mustBe(ICodeNode iCodeNode, int n2) {
        return CodeNodeUtil.meetsConditions(iCodeNode, n2, 0);
    }

    public static boolean cannotBe(ICodeNode iCodeNode, int n2) {
        return CodeNodeUtil.meetsConditions(iCodeNode, 0, n2);
    }

    public static List<ICodeNode> getChildren(ICodeNode iCodeNode, int n2, int n3) {
        ArrayList<ICodeNode> arrayList = new ArrayList<ICodeNode>(iCodeNode.getChildren());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICodeNode iCodeNode2 = (ICodeNode)iterator.next();
            if (CodeNodeUtil.meetsConditions(iCodeNode2, n2, n3)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public static boolean hasChildren(ICodeNode iCodeNode, int n2, int n3) {
        ArrayList<? extends ICodeNode> arrayList = new ArrayList<ICodeNode>(iCodeNode.getChildren());
        for (ICodeNode iCodeNode2 : arrayList) {
            if (!CodeNodeUtil.meetsConditions(iCodeNode2, n2, n3)) continue;
            return true;
        }
        return false;
    }

    public static String getPackageNameFromHierarchy(ICodeNode iCodeNode) {
        String string;
        String string2 = CodeNodeUtil.getPackageItemName(iCodeNode);
        if (string2 == null) {
            return null;
        }
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        arrayDeque.push(string2);
        for (ICodeNode iCodeNode2 = iCodeNode.getParent(); iCodeNode2 != null && (string = CodeNodeUtil.getPackageItemName(iCodeNode2)) != null; iCodeNode2 = iCodeNode2.getParent()) {
            arrayDeque.push(string);
        }
        if (arrayDeque.size() > 1) {
            return Strings.joinv("::", arrayDeque.toArray());
        }
        return string2;
    }

    private static String getPackageItemName(ICodeNode iCodeNode) {
        if (iCodeNode == null) {
            return null;
        }
        ICodeItem iCodeItem = iCodeNode.getObject();
        if (!(iCodeItem instanceof IPackage)) {
            return null;
        }
        return iCodeItem.getName();
    }
}

