/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class StaticTextDocument
extends AbstractTextDocument {
    @SerId(value=1)
    private List<ILine> lines;

    public StaticTextDocument(List<ILine> list) {
        this.lines = new ArrayList<ILine>(list);
    }

    public StaticTextDocument(String string) {
        this.lines = new ArrayList<ILine>();
        for (String string2 : Strings.splitLines(string)) {
            this.lines.add(new Line(string2));
        }
    }

    @Override
    public long getAnchorCount() {
        return this.lines.size();
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n2, int n3) {
        long l3;
        long l4 = l2 - (long)n3;
        if (l4 < 0L) {
            l4 = 0L;
        }
        if ((l3 = l2 + (long)n2) > (long)this.lines.size()) {
            l3 = this.lines.size();
        }
        int n4 = 0;
        ArrayList<IAnchor> arrayList = new ArrayList<IAnchor>();
        for (l2 = l4; l2 < l3; ++l2) {
            arrayList.add(new Anchor(l2, n4));
            ++n4;
        }
        List<ILine> list = this.lines.subList((int)l4, (int)l3);
        return new TextDocumentPart(list, arrayList);
    }

    @Override
    protected boolean useLineDelta() {
        return false;
    }

    @Override
    protected boolean useDisplayLineNumber() {
        return super.useDisplayLineNumber();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ILine iLine : this.lines) {
            stringBuilder.append(iLine.toString());
        }
        return stringBuilder.toString();
    }
}

