/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.output.text.impl.TextMark;
import com.pnfsoftware.jeb.util.format.CharSequences;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Ser
public class Line
implements ILine {
    @SerId(value=1)
    private CharSequence text;
    @SerId(value=2)
    private List<TextItem> items;
    @SerId(value=3)
    private List<TextMark> marks;

    public Line(CharSequence charSequence) {
        this(charSequence, null, null);
    }

    public Line(CharSequence charSequence, List<TextItem> list) {
        this(charSequence, list, null);
    }

    public Line(CharSequence charSequence, List<TextItem> list, List<TextMark> list2) {
        this.setText(charSequence);
        if (list == null) {
            list = Collections.emptyList();
        }
        this.items = list;
        for (TextItem textItem : list) {
            textItem.setLine(this);
        }
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.marks = list2;
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence charSequence) {
        if (charSequence == null) {
            throw new IllegalArgumentException("Line cannot be null");
        }
        if (CharSequences.indexOf2(charSequence, '\r', '\n') >= 0) {
            throw new IllegalArgumentException("Line cannot contain new-line characters");
        }
        this.text = charSequence;
    }

    public List<TextItem> getItems() {
        return this.items;
    }

    public void addItem(TextItem textItem) {
        if (textItem == null) {
            throw new IllegalArgumentException("Null item");
        }
        if (this.items == Collections.EMPTY_LIST) {
            this.items = new ArrayList<TextItem>();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (textItem.getOffset() >= this.items.get(i).getOffset()) continue;
            this.items.add(i, textItem);
            return;
        }
        this.items.add(textItem);
        textItem.setLine(this);
    }

    public List<TextMark> getMarks() {
        return this.marks;
    }

    public void addMark(TextMark textMark) {
        if (textMark == null) {
            throw new IllegalArgumentException("Null mark");
        }
        if (this.marks == Collections.EMPTY_LIST) {
            this.marks = new ArrayList<TextMark>();
        }
        this.marks.add(textMark);
    }

    public String toString() {
        return Strings.ff("text=%s|items=%s|marks=%s", this.getText(), Strings.joinList(this.getItems()), Strings.joinList(this.getMarks()));
    }
}

