/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.input.FileInputRegionInformation;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.IInputLocation;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Characters;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;

@SerDisabled
public class HexDumpDocument
extends AbstractTextDocument {
    private static final ILogger logger = GlobalLog.getLogger(HexDumpDocument.class);
    private static int bytesPerAnchor = 16;
    private static int bytesPerLine = 16;
    private IInput input;
    private IUnit unit;
    private long docsize;
    private int addrCharLen;
    private long anchorRange;
    private SeekableByteChannel channel;
    private ByteBuffer tempBuffer = ByteBuffer.allocate(1);

    public HexDumpDocument(IInput iInput, IUnit iUnit) {
        this.input = iInput;
        this.unit = iUnit;
        this.docsize = iInput.getCurrentSize();
        this.addrCharLen = this.docsize <= Integer.MAX_VALUE ? 8 : 16;
        this.anchorRange = (this.docsize + (long)bytesPerLine - 1L) / (long)bytesPerLine;
        if (this.anchorRange == 0L) {
            this.anchorRange = 1L;
        }
        try {
            this.channel = iInput.getChannel();
        }
        catch (IOException iOException) {
            logger.error("Hex.dump: Cannot read input: %s", iOException.getMessage());
        }
    }

    public HexDumpDocument(IInput iInput) {
        this(iInput, null);
    }

    @Override
    public void dispose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
            this.channel = null;
        }
    }

    public IInput getInput() {
        return this.input;
    }

    private byte readByte(long l2) throws InterruptedException {
        return this.readByte(l2, true);
    }

    private byte readByte(long l2, boolean bl) throws InterruptedException {
        if (this.channel == null) {
            return 0;
        }
        try {
            this.channel.position(l2);
            this.tempBuffer.clear();
            this.channel.read(this.tempBuffer);
            return this.tempBuffer.get(0);
        }
        catch (IOException iOException) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Thread is interrupted");
            }
            if (bl) {
                try {
                    this.channel = this.input.getChannel();
                }
                catch (IOException iOException2) {
                    logger.error("Input is no more readable. Was it deleted or moved?", new Object[0]);
                    logger.catching(iOException2);
                    throw new InterruptedException("Input can not be found anymore");
                }
                return this.readByte(l2, false);
            }
            (new Object[1])[0] = l2;
            logger.catching(iOException);
            return 0;
        }
    }

    @Override
    public long getAnchorCount() {
        return this.anchorRange;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n2, int n3) {
        long l3;
        long l4;
        if (n3 < 100) {
            n3 = 100;
        }
        if (n2 < 600) {
            n2 = 600;
        }
        if ((l4 = l2 - (long)n3) < 0L) {
            l4 = 0L;
        }
        if ((l3 = l2 + (long)n2) > this.anchorRange) {
            l3 = this.anchorRange;
        }
        ArrayList<ILine> arrayList = new ArrayList<ILine>();
        ArrayList<IAnchor> arrayList2 = new ArrayList<IAnchor>();
        while (l4 < l3) {
            int n4;
            long l5 = l4 * (long)bytesPerLine;
            int n5 = bytesPerLine;
            if (l5 > this.docsize) {
                arrayList2.add(new Anchor(l4, arrayList.size()));
                arrayList.add(new Line(""));
                ++l4;
                continue;
            }
            if (l5 + (long)n5 > this.docsize) {
                n5 = (int)(this.docsize - l5);
            }
            ArrayList<TextItem> arrayList3 = new ArrayList<TextItem>();
            StringBuilder stringBuilder = new StringBuilder();
            arrayList3.add(new TextItem(stringBuilder.length(), this.addrCharLen, ItemClassIdentifiers.ADDRESS));
            if (this.addrCharLen == 8) {
                stringBuilder.append(Formatter.toHexString(l5, true, 8)).append("  ");
            } else if (this.addrCharLen == 16) {
                stringBuilder.append(Formatter.toHexString(l5, true, 16)).append("  ");
            } else if (this.addrCharLen == 17) {
                stringBuilder.append(Formatter.toHexString(l5 >> 32 & 0xFFFFFFFFFFFFFFFFL, true, 8)).append("'");
                stringBuilder.append(Formatter.toHexString(l5 & 0xFFFFFFFFFFFFFFFFL, true, 8)).append("  ");
            } else {
                throw new RuntimeException();
            }
            byte[] byArray = new byte[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                try {
                    byArray[n4] = this.readByte(l5 + (long)n4);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                arrayList3.add(new TextItem(stringBuilder.length(), 2, ItemClassIdentifiers.TYPE_BYTE));
                stringBuilder.append(Formatter.toHexString(byArray[n4] & 0xFF, true, 2)).append(" ");
            }
            int n6 = n4;
            while (n4 < 16) {
                stringBuilder.append("   ");
                ++n4;
            }
            stringBuilder.append(" ");
            for (n4 = 0; n4 < n6; ++n4) {
                arrayList3.add(new TextItem(stringBuilder.length(), 1, ItemClassIdentifiers.TYPE_BYTE));
                if (Characters.isAsciiChar(byArray[n4])) {
                    stringBuilder.append((char)byArray[n4]);
                    continue;
                }
                stringBuilder.append(".");
            }
            String string = stringBuilder.toString();
            arrayList2.add(new Anchor(l4, arrayList.size()));
            arrayList.add(new Line(string, arrayList3));
            ++l4;
        }
        return new TextDocumentPart(arrayList, arrayList2);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        long l2;
        long l3 = iCoordinates.getAnchorId() * (long)bytesPerAnchor + (long)(iCoordinates.getLineDelta() * bytesPerLine);
        int n2 = iCoordinates.getColumnOffset();
        if (n2 < this.addrCharLen + 2 || n2 >= this.addrCharLen + 67 || n2 == this.addrCharLen + 50) {
            return null;
        }
        if (n2 >= this.addrCharLen + 51) {
            l2 = l3 + (long)(n2 - (this.addrCharLen + 51));
        } else {
            int n3 = (n2 - (this.addrCharLen + 2)) % 3;
            if (n3 == 2) {
                return null;
            }
            l2 = l3 + (long)((n2 - (this.addrCharLen + 2)) / 3);
        }
        if (l2 > this.docsize) {
            l2 = this.docsize;
        }
        return Strings.ff("@%Xh", l2);
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        IInputLocation iInputLocation;
        if (string == null || string.isEmpty()) {
            return null;
        }
        long l2 = -1L;
        if (string.charAt(0) != '@' && this.unit instanceof IInteractiveUnit && (iInputLocation = ((IInteractiveUnit)this.unit).addressToLocation(string)) instanceof FileInputRegionInformation) {
            l2 = ((FileInputRegionInformation)iInputLocation).getOffset();
        }
        if (l2 == -1L) {
            if (string.charAt(0) == '@') {
                string = string.substring(1);
            }
            l2 = Conversion.stringToLong(string, -1L);
        }
        if (l2 < 0L || l2 > this.docsize) {
            return null;
        }
        return new Coordinates(l2 / (long)bytesPerLine, 0, (int)((long)(this.addrCharLen + 2) + 3L * (l2 % (long)bytesPerLine)));
    }
}

