/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Characters;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

@SerDisabled
public class AsciiDocument
extends AbstractTextDocument {
    private static final ILogger logger = GlobalLog.getLogger(AsciiDocument.class);
    private IInput input;
    private List<Long> lineStarts;
    private long anchorRange;
    private long totalSize;

    public AsciiDocument(IInput iInput) {
        this.input = iInput;
        this.lineStarts = new ArrayList<Long>();
        this.lineStarts.add(0L);
        long l2 = 0L;
        try (InputStream inputStream = iInput.getStream();){
            int n2;
            byte[] byArray = new byte[16384];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                for (int i = 0; i < n2; ++i) {
                    byte by = byArray[i];
                    if (by != 10 && (by != 13 || i + 1 < n2 && byArray[i + 1] == 10)) continue;
                    this.lineStarts.add(l2 + (long)i + 1L);
                }
                l2 += (long)n2;
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException);
        }
        this.anchorRange = this.lineStarts.size();
        this.totalSize = l2;
    }

    @Override
    public long getAnchorCount() {
        return this.anchorRange;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n2, int n3) {
        long l3;
        if (l2 > Integer.MAX_VALUE) {
            throw new RuntimeException("");
        }
        int n4 = (int)l2 - n3;
        if (n4 < 0) {
            n4 = 0;
        }
        if ((l3 = l2 + (long)n2) > this.anchorRange) {
            l3 = this.anchorRange;
        }
        ArrayList<ILine> arrayList = new ArrayList<ILine>();
        ArrayList<IAnchor> arrayList2 = new ArrayList<IAnchor>();
        ByteBuffer byteBuffer = ByteBuffer.allocate(81920);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if ((long)n4 < l3) {
            try (SeekableByteChannel seekableByteChannel = this.input.getChannel();){
                seekableByteChannel.position(this.lineStarts.get(n4));
                while ((long)n4 < l3) {
                    int n5;
                    long l4 = this.lineStarts.get(n4);
                    long l5 = n4 + 1 >= this.lineStarts.size() ? this.totalSize : this.lineStarts.get(n4 + 1);
                    int n6 = (int)(l5 - l4);
                    if (n6 < 0) {
                        break;
                    }
                    if (n6 > byteBuffer.capacity()) {
                        n5 = (n6 & 0xFFFFF000) + 4096;
                        byteBuffer = ByteBuffer.allocate(n5);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    byteBuffer.position(0);
                    byteBuffer.limit(n6);
                    n5 = seekableByteChannel.read(byteBuffer);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < n5; ++i) {
                        byte by = byteBuffer.get(i);
                        if (Characters.isAsciiChar(by) || by == 9) {
                            stringBuilder.append((char)by);
                            continue;
                        }
                        if (by == 10 || by == 13) break;
                        Strings.ff(stringBuilder, "\\x%02X", by & 0xFF);
                    }
                    arrayList2.add(new Anchor(n4, arrayList.size()));
                    arrayList.add(new Line(stringBuilder));
                    ++n4;
                }
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
        }
        return new TextDocumentPart(arrayList, arrayList2);
    }

    @Override
    protected boolean useLineDelta() {
        return false;
    }

    @Override
    protected boolean useDisplayLineNumber() {
        return true;
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        String string = super.coordinatesToAddress(iCoordinates, addressConversionPrecision);
        if (string == null) {
            return null;
        }
        return "@" + string;
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        if (string == null || string.isEmpty() || string.charAt(0) != '@') {
            return null;
        }
        return super.addressToCoordinates(string.substring(1), coordinatesConversionPrecision);
    }
}

