/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.exceptions.NotImplementedException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextDocumentUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.ArrayList;
import java.util.List;

@Ser
public abstract class AbstractTextDocument
extends EventSource
implements ITextDocument {
    @Override
    public void dispose() {
    }

    @Override
    public IPropertyManager getPropertyManager() {
        return null;
    }

    @Override
    public long getInitialAnchor() {
        return this.getFirstAnchor();
    }

    @Override
    public long getFirstAnchor() {
        return 0L;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n2) {
        return this.getDocumentPart(l2, n2, 0);
    }

    @Override
    public ITextDocumentPart getDocumentPart2(long l2, long l3) throws NotImplementedException {
        throw new NotImplementedException("getDocumentPart2() is not implemented in this document object: " + this.getClass().getSimpleName());
    }

    protected boolean useLineDelta() {
        return true;
    }

    protected boolean useDisplayLineNumber() {
        return false;
    }

    private int getAnchorDelta() {
        return this.useDisplayLineNumber() ? 1 : 0;
    }

    @Override
    public final String coordinatesToAddress(ICoordinates iCoordinates) {
        return this.coordinatesToAddress(iCoordinates, AddressConversionPrecision.DEFAULT);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        if (iCoordinates == null) {
            return null;
        }
        if (!this.useLineDelta()) {
            return Strings.ff("%d,%d", iCoordinates.getAnchorId() + (long)this.getAnchorDelta(), iCoordinates.getColumnOffset());
        }
        return Strings.ff("%d,%d,%d", iCoordinates.getAnchorId() + (long)this.getAnchorDelta(), iCoordinates.getLineDelta(), iCoordinates.getColumnOffset());
    }

    @Override
    public final ICoordinates addressToCoordinates(String string) {
        return this.addressToCoordinates(string, CoordinatesConversionPrecision.BEST);
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        if (string == null) {
            return null;
        }
        List<Long> list = AbstractTextDocument.parseLongList(string);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return new Coordinates(list.get(0) - (long)this.getAnchorDelta());
        }
        if (list.size() == 2) {
            if (!this.useLineDelta()) {
                return new Coordinates(list.get(0) - (long)this.getAnchorDelta(), 0, list.get(1).intValue());
            }
            return new Coordinates(list.get(0) - (long)this.getAnchorDelta(), list.get(1).intValue());
        }
        if (list.size() == 3) {
            return new Coordinates(list.get(0) - (long)this.getAnchorDelta(), list.get(1).intValue(), list.get(2).intValue());
        }
        return null;
    }

    private static List<Long> parseLongList(String string) {
        if ((string = string.trim()).startsWith("@")) {
            string = string.substring(1).trim();
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            string = string.substring(1, string.length() - 1).trim();
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (String string2 : string.split(",")) {
            try {
                long l2 = Long.parseLong(string2.trim());
                arrayList.add(l2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return arrayList;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public String format() {
        return TextDocumentUtil.getText(this);
    }
}

