/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text;

import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.IObjectLocation;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.CharSequenceList;
import com.pnfsoftware.jeb.util.format.CharSequences;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextPartUtil {
    private static final ILogger logger = GlobalLog.getLogger(TextPartUtil.class);

    public static void verifyPart(ITextDocumentPart iTextDocumentPart) {
        Object object;
        int n2;
        List<? extends IAnchor> list = iTextDocumentPart.getAnchors();
        int n3 = list.size();
        List<? extends ILine> list2 = iTextDocumentPart.getLines();
        int n4 = list2.size();
        if (n3 == 0) {
            throw new RuntimeException("Part without anchor");
        }
        Object object2 = list.get(0);
        if (object2.getLineIndex() != 0) {
            throw new RuntimeException("The first anchor in the part does not reference first line in the part: " + object2.getLineIndex());
        }
        for (n2 = 1; n2 < n3; ++n2) {
            object = list.get(n2);
            if (object.getIdentifier() <= object2.getIdentifier() || object.getLineIndex() <= object2.getLineIndex()) {
                throw new RuntimeException(Strings.ff("Non strictly ascending anchors: (%d,%d) vs (%d,%d) ", object2.getIdentifier(), object2.getLineIndex(), object.getIdentifier(), object.getLineIndex()));
            }
            if (object.getLineIndex() > n4) {
                throw new RuntimeException(Strings.ff("Invalid line index: %d vs %d", n4, object.getLineIndex()));
            }
            object2 = object;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            object = iTextDocumentPart.getLines().get(n2);
            CharSequence charSequence = object.getText();
            if (CharSequences.indexOf2(charSequence, '\r', '\n') >= 0) {
                throw new RuntimeException(String.format("Lines within a document part must not contain new-line characters @[%d]", n2));
            }
            int n5 = 0;
            for (ITextItem iTextItem : object.getItems()) {
                int n6 = iTextItem.getOffset();
                if (n6 < n5) {
                    throw new RuntimeException(Strings.ff("Items in a document part must not overlap or be out-of-bound @[%d , %d]", n2, n6));
                }
                int n7 = iTextItem.getLength();
                int n8 = n6 + n7;
                if (n8 > charSequence.length()) {
                    logger.debug("Item out of bound @[%d , %d]", n2, n6);
                    throw new RuntimeException(String.format("Items in a document part must not be out-of-bound @[%d , %d]", n2, n6));
                }
                n5 = n8;
            }
        }
    }

    public static IAnchor getFirstAnchor(ITextDocumentPart iTextDocumentPart) {
        if (iTextDocumentPart == null) {
            return null;
        }
        int n2 = iTextDocumentPart.getAnchors().size();
        if (n2 == 0) {
            return null;
        }
        return iTextDocumentPart.getAnchors().get(0);
    }

    public static long getFirstAnchorId(ITextDocumentPart iTextDocumentPart) {
        int n2 = iTextDocumentPart.getAnchors().size();
        if (n2 == 0) {
            return -1L;
        }
        return iTextDocumentPart.getAnchors().get(0).getIdentifier();
    }

    public static IAnchor getLastAnchor(ITextDocumentPart iTextDocumentPart) {
        if (iTextDocumentPart == null) {
            return null;
        }
        int n2 = iTextDocumentPart.getAnchors().size();
        if (n2 == 0) {
            return null;
        }
        IAnchor iAnchor = iTextDocumentPart.getAnchors().get(n2 - 1);
        if (iAnchor.getLineIndex() == iTextDocumentPart.getLines().size()) {
            if (n2 == 1) {
                return null;
            }
            iAnchor = iTextDocumentPart.getAnchors().get(n2 - 2);
        }
        return iAnchor;
    }

    public static long getLastAnchorId(ITextDocumentPart iTextDocumentPart) {
        IAnchor iAnchor = TextPartUtil.getLastAnchor(iTextDocumentPart);
        if (iAnchor == null) {
            return -1L;
        }
        return iAnchor.getIdentifier();
    }

    public static long getNextAnchorId(ITextDocumentPart iTextDocumentPart) {
        int n2 = iTextDocumentPart.getAnchors().size();
        if (n2 == 0) {
            return -1L;
        }
        IAnchor iAnchor = iTextDocumentPart.getAnchors().get(n2 - 1);
        if (iAnchor.getLineIndex() == iTextDocumentPart.getLines().size()) {
            return iAnchor.getIdentifier();
        }
        return iAnchor.getIdentifier() + 1L;
    }

    public static List<ITextItem> getItems(ITextDocumentPart iTextDocumentPart) {
        ArrayList<ITextItem> arrayList = new ArrayList<ITextItem>();
        for (ILine iLine : iTextDocumentPart.getLines()) {
            arrayList.addAll(iLine.getItems());
        }
        return arrayList;
    }

    public static ITextItem getItemAt(ITextDocumentPart iTextDocumentPart, int n2, int n3) {
        if (n2 < 0 || n2 >= iTextDocumentPart.getLines().size()) {
            return null;
        }
        return TextPartUtil.getItemAt(iTextDocumentPart.getLines().get(n2), n3);
    }

    public static ITextItem getItemAt(ILine iLine, int n2) {
        ITextItem iTextItem;
        int n3;
        Iterator<? extends ITextItem> iterator = iLine.getItems().iterator();
        while (iterator.hasNext() && n2 >= (n3 = (iTextItem = iterator.next()).getOffset())) {
            if (n2 >= n3 + iTextItem.getLength()) continue;
            return iTextItem;
        }
        return null;
    }

    public static String buildRawTextFromPart(ITextDocumentPart iTextDocumentPart) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (ILine iLine : iTextDocumentPart.getLines()) {
            CharSequence charSequence = iLine.getText();
            arrayList.add(charSequence);
        }
        return new CharSequenceList(arrayList).toString();
    }

    public static String buildRawTextFromPartInterruptibly(ITextDocumentPart iTextDocumentPart) throws InterruptedException {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n2 = 0;
        for (ILine iLine : iTextDocumentPart.getLines()) {
            CharSequence charSequence = iLine.getText();
            arrayList.add(charSequence);
            if (++n2 % 1000 != 0 || !Thread.interrupted()) continue;
            throw new InterruptedException("The text part generation was interrupted");
        }
        return new CharSequenceList(arrayList).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static List<? extends ILine> getLinesOfAnchor(ITextDocumentPart iTextDocumentPart, long l2) {
        void var6_9;
        List<? extends IAnchor> list = iTextDocumentPart.getAnchors();
        int n2 = 0;
        for (IAnchor iAnchor : list) {
            if (iAnchor.getIdentifier() == l2) break;
            ++n2;
        }
        if (n2 >= list.size()) {
            return null;
        }
        int n3 = list.get(n2).getLineIndex();
        if (n2 + 1 >= list.size()) {
            int n4 = iTextDocumentPart.getLines().size();
        } else {
            int n4 = list.get(n2 + 1).getLineIndex();
        }
        return iTextDocumentPart.getLines().subList(n3, (int)var6_9);
    }

    public static ILine getLineAt(ITextDocumentPart iTextDocumentPart, ICoordinates iCoordinates) {
        List<? extends ILine> list = TextPartUtil.getLinesOfAnchor(iTextDocumentPart, iCoordinates.getAnchorId());
        if (list != null && iCoordinates.getLineDelta() < list.size()) {
            return list.get(iCoordinates.getLineDelta());
        }
        return null;
    }

    public static IAnchor getAnchorAtLine(ITextDocumentPart iTextDocumentPart, int n2) {
        IAnchor iAnchor = null;
        for (IAnchor iAnchor2 : iTextDocumentPart.getAnchors()) {
            if (n2 < iAnchor2.getLineIndex()) break;
            iAnchor = iAnchor2;
        }
        return iAnchor;
    }

    public static boolean isInsidePart(ITextDocumentPart iTextDocumentPart, ICoordinates iCoordinates) {
        IAnchor iAnchor = TextPartUtil.getAnchorById(iTextDocumentPart, iCoordinates.getAnchorId());
        if (iAnchor == null) {
            return false;
        }
        int n2 = iAnchor.getLineIndex() + iCoordinates.getLineDelta();
        if (n2 < 0 || n2 >= iTextDocumentPart.getLines().size()) {
            return false;
        }
        ILine iLine = iTextDocumentPart.getLines().get(n2);
        int n3 = iCoordinates.getColumnOffset();
        return n3 >= 0 && n3 <= iLine.getText().length();
    }

    public static int coordinatesToLineIndex(ITextDocumentPart iTextDocumentPart, ICoordinates iCoordinates) {
        int n2;
        if (iCoordinates == null) {
            return -1;
        }
        IAnchor iAnchor = TextPartUtil.getAnchorById(iTextDocumentPart, iCoordinates.getAnchorId());
        if (iAnchor == null) {
            if (iCoordinates.getAnchorId() > TextPartUtil.getFirstAnchorId(iTextDocumentPart) && iCoordinates.getAnchorId() < TextPartUtil.getLastAnchorId(iTextDocumentPart)) {
                iAnchor = TextPartUtil.getApproximateAnchorById(iTextDocumentPart, iCoordinates.getAnchorId(), -1);
            } else {
                return -1;
            }
        }
        if ((n2 = iAnchor.getLineIndex() + iCoordinates.getLineDelta()) < 0 || n2 >= iTextDocumentPart.getLines().size()) {
            return -1;
        }
        return n2;
    }

    public static IAnchor getAnchorById(ITextDocumentPart iTextDocumentPart, long l2) {
        for (IAnchor iAnchor : iTextDocumentPart.getAnchors()) {
            long l3 = iAnchor.getIdentifier();
            if (l3 == l2) {
                return iAnchor;
            }
            if (l3 <= l2) continue;
            break;
        }
        return null;
    }

    public static IAnchor getNearestAnchorById(ITextDocumentPart iTextDocumentPart, long l2) {
        return TextPartUtil.getApproximateAnchorById(iTextDocumentPart, l2, 0);
    }

    public static IAnchor getApproximateAnchorById(ITextDocumentPart iTextDocumentPart, long l2, int n2) {
        int n3;
        List<? extends IAnchor> list = iTextDocumentPart.getAnchors();
        IAnchor iAnchor = null;
        long l3 = -1L;
        for (n3 = 0; n3 < list.size() && (l3 = (iAnchor = list.get(n3)).getIdentifier()) < l2; ++n3) {
        }
        if (iAnchor == null) {
            return null;
        }
        if (l3 == l2) {
            return iAnchor;
        }
        if (n3 >= list.size() || n3 == 0) {
            return null;
        }
        if (n2 > 0) {
            return iAnchor;
        }
        IAnchor iAnchor2 = list.get(n3 - 1);
        if (n2 < 0) {
            return iAnchor2;
        }
        long l4 = l3 - l2;
        long l5 = l2 - iAnchor2.getIdentifier();
        if (l4 <= l5) {
            return iAnchor;
        }
        return iAnchor2;
    }

    public static boolean isAnchorDisplayed(ITextDocumentPart iTextDocumentPart, long l2) {
        return TextPartUtil.getAnchorById(iTextDocumentPart, l2) != null;
    }

    public static List<Object> getObjectsAt(ITextDocumentPart iTextDocumentPart, int n2, int n3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IObjectLocation iObjectLocation : iTextDocumentPart.getObjectLocations()) {
            if (n2 >= iObjectLocation.getLineBegin() && n2 <= iObjectLocation.getLineEnd()) {
                if (n2 == iObjectLocation.getLineBegin() && n3 < iObjectLocation.getColumnBegin() || n2 == iObjectLocation.getLineEnd() && n3 >= iObjectLocation.getColumnEnd()) continue;
                arrayList.add(iObjectLocation.getObject());
            }
            if (iObjectLocation.getLineBegin() <= n2) continue;
            break;
        }
        return arrayList;
    }

    public static Iterable<LineInfo> iterateLines(final ITextDocumentPart iTextDocumentPart) {
        return new Iterable<LineInfo>(){

            @Override
            public Iterator<LineInfo> iterator() {
                return new LineIterator(iTextDocumentPart);
            }
        };
    }

    static class LineIterator
    implements Iterator<LineInfo> {
        private List<? extends IAnchor> anchors;
        private int ianchor;
        private int anchorcount;
        private List<? extends ILine> lines;
        private int iline;
        private int linecount;
        private long currentAnchorId;
        private int currentAnchorLineStart;
        private int nextAnchorLineStart;

        LineIterator(ITextDocumentPart iTextDocumentPart) {
            this.anchors = iTextDocumentPart.getAnchors();
            this.ianchor = 0;
            this.anchorcount = this.anchors.size();
            this.lines = iTextDocumentPart.getLines();
            this.iline = 0;
            this.linecount = this.lines.size();
            if (this.anchorcount >= 1) {
                this.currentAnchorId = this.anchors.get(0).getIdentifier();
                this.currentAnchorLineStart = this.anchors.get(0).getLineIndex();
                Assert.a(this.anchors.get(0).getLineIndex() == 0);
                this.nextAnchorLineStart = this.anchorcount >= 2 ? this.anchors.get(1).getLineIndex() : -1;
            } else {
                Assert.a(this.linecount == 0);
                this.currentAnchorId = 0L;
                this.nextAnchorLineStart = -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.iline < this.linecount;
        }

        @Override
        public LineInfo next() {
            LineInfo lineInfo = new LineInfo(this.iline, this.currentAnchorId, this.iline - this.currentAnchorLineStart);
            ++this.iline;
            if (this.iline >= this.nextAnchorLineStart) {
                ++this.ianchor;
                if (this.ianchor < this.anchorcount) {
                    this.currentAnchorLineStart = this.nextAnchorLineStart;
                    this.currentAnchorId = this.anchors.get(this.ianchor).getIdentifier();
                    this.nextAnchorLineStart = this.ianchor + 1 < this.anchorcount ? this.anchors.get(this.ianchor + 1).getLineIndex() : -1;
                } else {
                    this.nextAnchorLineStart = -1;
                }
            }
            return lineInfo;
        }
    }

    public static class LineInfo {
        int lineindex;
        long anchorid;
        int anchoredLineindex;

        public LineInfo(int n2, long l2, int n3) {
            this.lineindex = n2;
            this.anchorid = l2;
            this.anchoredLineindex = n3;
        }

        public int getPartLineIndex() {
            return this.lineindex;
        }

        public long getAnchorId() {
            return this.anchorid;
        }

        public int getAnchoredLineIndex() {
            return this.anchoredLineindex;
        }

        public String toString() {
            return Strings.ff("lineIndex=%d {anchorId=%d, anchoredLineindex=%d}", this.lineindex, this.anchorid, this.anchoredLineindex);
        }
    }
}

