/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text;

import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.util.format.Strings;

public class TextDocumentUtil {
    public static String getText(ITextDocument iTextDocument) {
        return TextDocumentUtil.buildText(iTextDocument).toString();
    }

    public static StringBuilder buildText(ITextDocument iTextDocument) {
        return TextDocumentUtil.buildText(iTextDocument, Integer.MAX_VALUE);
    }

    public static StringBuilder buildText(ITextDocument iTextDocument, int n2) {
        long l2 = iTextDocument.getFirstAnchor();
        ITextDocumentPart iTextDocumentPart = iTextDocument.getDocumentPart(l2, n2);
        if (iTextDocumentPart == null) {
            throw new RuntimeException("The part could not be retrieved");
        }
        return TextDocumentUtil.buildText(iTextDocumentPart, n2);
    }

    public static StringBuilder buildText(ITextDocumentPart iTextDocumentPart) {
        return TextDocumentUtil.buildText(iTextDocumentPart, Integer.MAX_VALUE);
    }

    public static StringBuilder buildText(ITextDocumentPart iTextDocumentPart, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (ILine iLine : iTextDocumentPart.getLines()) {
            if (n3 >= n2) break;
            stringBuilder.append(iLine.getText());
            stringBuilder.append(Strings.LINESEP);
            ++n3;
        }
        return stringBuilder;
    }
}

