/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text;

import com.pnfsoftware.jeb.core.output.AbstractHtmlFormatter;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IItemStyleInfoProvider;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.IVisualTextItem;
import com.pnfsoftware.jeb.core.output.text.StyleInfo;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.XmlBuilder;
import java.util.HashSet;
import java.util.Set;

public class HtmlTextDocumentFormatter
extends AbstractHtmlFormatter<ItemClassIdentifiers> {
    private IItemStyleInfoProvider styleprv;
    private Set<ItemClassIdentifiers> styleLessids = new HashSet<ItemClassIdentifiers>();
    private static final int defaultForegroundColor = 0;
    private static final int defaultBackgroundColor = 0xFFFFFF;

    public HtmlTextDocumentFormatter(IItemStyleInfoProvider iItemStyleInfoProvider, String string, boolean bl) {
        super(string, new StringBuilder("div {\n  display: inline-block;\n  margin:0;\n  padding:0;\n  border:0;\n}\n"), bl);
        this.styleprv = iItemStyleInfoProvider;
    }

    public String generate(ITextDocument iTextDocument) {
        ITextDocumentPart iTextDocumentPart = iTextDocument.getDocumentPart(iTextDocument.getFirstAnchor(), Integer.MAX_VALUE);
        return this.generate(iTextDocumentPart);
    }

    public String generate(ITextDocumentPart iTextDocumentPart) {
        StringBuilder stringBuilder = new StringBuilder("<pre>\n");
        for (ILine iLine : iTextDocumentPart.getLines()) {
            CharSequence charSequence = iLine.getText();
            int n2 = 0;
            String string = null;
            for (ITextItem iTextItem : iLine.getItems()) {
                String string2;
                int n3 = iTextItem.getOffset();
                int n4 = iTextItem.getOffsetEnd();
                CharSequence charSequence2 = "";
                if (n3 > n2) {
                    charSequence2 = XmlBuilder.escapeAll(charSequence.subSequence(n2, n3));
                    stringBuilder.append(charSequence2);
                    n2 = n3;
                }
                if (Strings.isBlank(string2 = this.generateCssDivStyle(iTextItem))) {
                    stringBuilder.append(XmlBuilder.escapeAll(charSequence.subSequence(n2, n4)));
                } else if (string2.equals(string)) {
                    stringBuilder.delete(stringBuilder.length() - charSequence2.length() - 6, stringBuilder.length() - charSequence2.length());
                    stringBuilder.append(XmlBuilder.escapeAll(charSequence.subSequence(n2, n4))).append("</div>");
                } else {
                    stringBuilder.append("<div class=\"").append(string2).append("\">");
                    stringBuilder.append(XmlBuilder.escapeAll(charSequence.subSequence(n2, n4))).append("</div>");
                }
                n2 = n4;
                string = string2;
            }
            if (n2 < charSequence.length()) {
                stringBuilder.append(XmlBuilder.escapeAll(charSequence.subSequence(n2, charSequence.length())));
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("</pre>\n");
        return this.generate(stringBuilder);
    }

    @Override
    private String generateCssDivStyle(ITextItem iTextItem) {
        ItemClassIdentifiers itemClassIdentifiers = ItemClassIdentifiers.DEFAULT;
        if (iTextItem instanceof IVisualTextItem) {
            itemClassIdentifiers = ((IVisualTextItem)iTextItem).getClassId();
        }
        if (this.styleLessids.contains((Object)itemClassIdentifiers)) {
            return null;
        }
        return super.generateCssDivStyle(itemClassIdentifiers);
    }

    @Override
    protected CharSequence generateCssBlock(ItemClassIdentifiers itemClassIdentifiers, String string) {
        StyleInfo styleInfo = this.styleprv.getStyle(itemClassIdentifiers);
        if (styleInfo == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder().append(".").append(string).append(" {\n");
        boolean bl = true;
        if (styleInfo.getForegroundColor() != null) {
            stringBuilder.append("  color: #").append(Formatter.toHexString(styleInfo.getForegroundColor(), true, 6)).append(";\n");
            if (styleInfo.getForegroundColor() != 0) {
                bl = false;
            }
        }
        if (styleInfo.getBackgroundColor() != null) {
            stringBuilder.append("  background-color: #").append(Formatter.toHexString(styleInfo.getBackgroundColor(), true, 6)).append(";\n");
            if (styleInfo.getBackgroundColor() != 0xFFFFFF) {
                bl = false;
            }
        }
        if (Boolean.TRUE.equals(styleInfo.getBold())) {
            stringBuilder.append("  font-weight: bold;\n");
            bl = false;
        }
        if (Boolean.TRUE.equals(styleInfo.getItalic())) {
            stringBuilder.append("  font-style: italic;\n");
            bl = false;
        }
        stringBuilder.append("}\n");
        if (bl) {
            this.styleLessids.add(itemClassIdentifiers);
            return null;
        }
        return stringBuilder;
    }
}

