/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IItemStyleInfoProvider;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.IVisualTextItem;
import com.pnfsoftware.jeb.core.output.text.StyleInfo;
import java.util.HashMap;
import java.util.Map;

public class HtmlFormatter {
    private ITextDocument doc;
    private IItemStyleInfoProvider styleprv;
    private String titledata;
    private String bodytitledata;
    private String commentdata;
    private StringBuilder cssdata;
    private Map<ItemClassIdentifiers, String> styleidToDivclassname = new HashMap<ItemClassIdentifiers, String>();

    public HtmlFormatter(ITextDocument iTextDocument, IItemStyleInfoProvider iItemStyleInfoProvider, String string, boolean bl) {
        this.doc = iTextDocument;
        this.styleprv = iItemStyleInfoProvider;
        this.titledata = this.replaceHtmlChars(string);
        this.commentdata = String.format("Generated by JEB v%s - %s", AbstractContext.app_ver, "https://www.pnfsoftware.com");
        this.bodytitledata = "";
        if (bl) {
            this.bodytitledata = String.format("<h4>Generated by <a href=\"%s\">JEB</a> v%s</h4>", "https://www.pnfsoftware.com", AbstractContext.app_ver);
        }
        this.cssdata = new StringBuilder("div {\n  display: inline-block;\n  margin:0;\n  padding:0;\n  border:0;\n}\n");
    }

    public String generate() {
        StringBuilder stringBuilder = new StringBuilder("<pre>\n");
        ITextDocumentPart iTextDocumentPart = this.doc.getDocumentPart(this.doc.getFirstAnchor(), Integer.MAX_VALUE);
        for (ILine iLine : iTextDocumentPart.getLines()) {
            CharSequence charSequence = iLine.getText();
            int n2 = 0;
            for (ITextItem iTextItem : iLine.getItems()) {
                int n3 = iTextItem.getOffset();
                int n4 = iTextItem.getOffsetEnd();
                if (n3 > n2) {
                    stringBuilder.append(this.replaceHtmlChars(charSequence.subSequence(n2, n3)));
                    n2 = n3;
                }
                stringBuilder.append(String.format("<div class=\"%s\">%s</div>", this.generateCssDivStyle(iTextItem), this.replaceHtmlChars(charSequence.subSequence(n2, n4))));
                n2 = n4;
            }
            if (n2 < charSequence.length()) {
                stringBuilder.append(this.replaceHtmlChars(charSequence.subSequence(n2, charSequence.length())));
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("</pre>\n");
        String string = String.format("<html>\n\n<head>\n<title>%s</title>\n<style type=\"text/css\">\n%s</style>\n</head>\n\n<body>\n%s\n%s\n</body>\n\n<!-- %s -->\n</html>\n", this.titledata, this.cssdata, this.bodytitledata, stringBuilder, this.commentdata);
        return string;
    }

    private String generateCssDivStyle(ITextItem iTextItem) {
        String string;
        ItemClassIdentifiers itemClassIdentifiers = ItemClassIdentifiers.DEFAULT;
        if (iTextItem instanceof IVisualTextItem) {
            itemClassIdentifiers = ((IVisualTextItem)iTextItem).getClassId();
        }
        if ((string = this.styleidToDivclassname.get((Object)itemClassIdentifiers)) != null) {
            return string;
        }
        StyleInfo styleInfo = this.styleprv.getStyle(itemClassIdentifiers);
        if (styleInfo == null) {
            return "";
        }
        String string2 = "s_" + itemClassIdentifiers.toString().toLowerCase();
        StringBuilder stringBuilder = new StringBuilder(String.format(".%s {\n", string2));
        if (styleInfo.getForegroundColor() != null) {
            stringBuilder.append(String.format("  color: #%06X;\n", styleInfo.getForegroundColor()));
        }
        if (styleInfo.getBackgroundColor() != null) {
            stringBuilder.append(String.format("  background-color: #%06X;\n", styleInfo.getBackgroundColor()));
        }
        if (Boolean.TRUE.equals(styleInfo.getBold())) {
            stringBuilder.append("  font-weight: bold;\n");
        }
        if (Boolean.TRUE.equals(styleInfo.getItalic())) {
            stringBuilder.append("  font-style: italic;\n");
        }
        stringBuilder.append("}\n");
        this.cssdata.append((CharSequence)stringBuilder);
        this.styleidToDivclassname.put(itemClassIdentifiers, string2);
        return string2;
    }

    private String replaceHtmlChars(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c2 == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c2 == '\'') {
                stringBuilder.append("&#039;");
                continue;
            }
            if (c2 == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

