/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code.coordinates;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class IdentifierCoordinates {
    @SerId(value=1)
    private ICodeCoordinates base;
    @SerId(value=2)
    private int varindex;

    public IdentifierCoordinates(ICodeCoordinates iCodeCoordinates, int n2) {
        if (!(iCodeCoordinates instanceof InstructionCoordinates) && !(iCodeCoordinates instanceof MethodCoordinates)) {
            throw new IllegalArgumentException();
        }
        this.base = iCodeCoordinates;
        this.varindex = n2;
    }

    public ICodeCoordinates getBase() {
        return this.base;
    }

    public int getMethodIndex() {
        if (this.base instanceof InstructionCoordinates) {
            return ((InstructionCoordinates)this.base).getMethodId();
        }
        return ((MethodCoordinates)this.base).getMethodId();
    }

    public int getMethodOffset() {
        if (this.base instanceof InstructionCoordinates) {
            return ((InstructionCoordinates)this.base).getOffset();
        }
        return -1;
    }

    public int getVariableIndex() {
        return this.varindex;
    }

    public boolean isVirtual() {
        return this.varindex >= 65536;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.base == null ? 0 : this.base.hashCode());
        n2 = 31 * n2 + this.varindex;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IdentifierCoordinates identifierCoordinates = (IdentifierCoordinates)object;
        if (this.base == null ? identifierCoordinates.base != null : !this.base.equals(identifierCoordinates.base)) {
            return false;
        }
        return this.varindex == identifierCoordinates.varindex;
    }

    public String toString() {
        return Strings.ff("ident:[%s],%s%d", this.base, this.isVirtual() ? "x" : "", this.varindex);
    }
}

