/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code.coordinates;

import com.pnfsoftware.jeb.core.output.code.coordinates.ClassCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.FieldCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;

public class CodeCoordinatesUtil {
    public static Integer getBaseObjectIndex(ICodeCoordinates iCodeCoordinates) {
        if (iCodeCoordinates instanceof ClassCoordinates) {
            return ((ClassCoordinates)iCodeCoordinates).getClassId();
        }
        if (iCodeCoordinates instanceof FieldCoordinates) {
            return ((FieldCoordinates)iCodeCoordinates).getFieldId();
        }
        if (iCodeCoordinates instanceof MethodCoordinates) {
            return ((MethodCoordinates)iCodeCoordinates).getMethodId();
        }
        if (iCodeCoordinates instanceof InstructionCoordinates) {
            return ((InstructionCoordinates)iCodeCoordinates).getMethodId();
        }
        return null;
    }

    public static Integer getMethodObjectIndex(ICodeCoordinates iCodeCoordinates) {
        if (iCodeCoordinates instanceof MethodCoordinates) {
            return ((MethodCoordinates)iCodeCoordinates).getMethodId();
        }
        if (iCodeCoordinates instanceof InstructionCoordinates) {
            return ((InstructionCoordinates)iCodeCoordinates).getMethodId();
        }
        return null;
    }

    public static int distance(ICodeCoordinates iCodeCoordinates, ICodeCoordinates iCodeCoordinates2) {
        if (iCodeCoordinates instanceof MethodCoordinates) {
            iCodeCoordinates = new InstructionCoordinates(((MethodCoordinates)iCodeCoordinates).getMethodId(), 0);
        }
        if (iCodeCoordinates2 instanceof MethodCoordinates) {
            iCodeCoordinates2 = new InstructionCoordinates(((MethodCoordinates)iCodeCoordinates2).getMethodId(), 0);
        }
        if (iCodeCoordinates instanceof InstructionCoordinates && iCodeCoordinates2 instanceof InstructionCoordinates) {
            InstructionCoordinates instructionCoordinates = (InstructionCoordinates)iCodeCoordinates;
            InstructionCoordinates instructionCoordinates2 = (InstructionCoordinates)iCodeCoordinates2;
            if (instructionCoordinates.getMethodId() == instructionCoordinates2.getMethodId()) {
                return Math.abs(instructionCoordinates.getOffset() - instructionCoordinates2.getOffset());
            }
        }
        return Integer.MAX_VALUE;
    }

    public static ICodeCoordinates getMostAccurate(ICodeCoordinates iCodeCoordinates, ICodeCoordinates iCodeCoordinates2) {
        if (iCodeCoordinates instanceof MethodCoordinates) {
            iCodeCoordinates = new InstructionCoordinates(((MethodCoordinates)iCodeCoordinates).getMethodId(), 0);
        }
        if (iCodeCoordinates2 instanceof MethodCoordinates) {
            iCodeCoordinates2 = new InstructionCoordinates(((MethodCoordinates)iCodeCoordinates2).getMethodId(), 0);
        }
        if (iCodeCoordinates instanceof InstructionCoordinates && iCodeCoordinates2 instanceof InstructionCoordinates) {
            InstructionCoordinates instructionCoordinates = (InstructionCoordinates)iCodeCoordinates;
            InstructionCoordinates instructionCoordinates2 = (InstructionCoordinates)iCodeCoordinates2;
            if (instructionCoordinates.getOffset() < 0 && instructionCoordinates2.getOffset() >= 0) {
                return instructionCoordinates2;
            }
        }
        return iCodeCoordinates;
    }
}

