/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Arrays;
import java.util.List;

public class CppLikeDocumentPart
extends CodeDocumentPart {
    protected String commentBlockBegin = "/*";
    protected String commentBlockEnd = "*/";
    protected String commentInline = "//";
    private ICodeCoordinates eol_coord;
    private String eol_comment;
    private boolean eol_comment_is_auto;

    public CppLikeDocumentPart(long l2) {
        super(l2);
    }

    public void setEolCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.eol_coord = iCodeCoordinates;
    }

    public ICodeCoordinates getEolCoordinates() {
        return this.eol_coord;
    }

    public void setEolComment(String string) {
        this.eol_comment = string;
        this.eol_comment_is_auto = false;
    }

    public void setEolComment(String string, boolean bl) {
        this.eol_comment = string;
        this.eol_comment_is_auto = bl;
    }

    public String getEolComment() {
        return this.eol_comment;
    }

    public void onEolAddComment(String string) {
        this.eol_comment = this.eol_comment == null ? string : this.eol_comment + " / " + string;
    }

    @Override
    public final void eol() {
        this.eol(this.eol_coord);
    }

    @Override
    public final void eol(ICodeCoordinates iCodeCoordinates) {
        this.eol_coord = null;
        if (this.eol_comment != null) {
            String string = this.eol_comment;
            this.eol_comment = null;
            this.eolComment(string, iCodeCoordinates, false, this.eol_comment_is_auto);
        }
        super.eol(iCodeCoordinates);
    }

    private void eolComment(String object, ICodeCoordinates iCodeCoordinates, boolean bl, boolean bl2) {
        String string = this.commentInline + " ";
        if (bl) {
            this.space(2);
            object = string + ((String)object).replace("\r\n", " / ").replace("\r", "").replace("\n", " / ");
            this.appendComment((String)object, bl2);
            return;
        }
        int n2 = this.getCurrentLineLength() - this.getCurrentMarginLength();
        List<String> list = bl2 ? Formatter.wordWrap((String)object, 80, 1) : Arrays.asList(Strings.splitLines((String)object));
        int n3 = 0;
        for (String string2 : list) {
            Object object2 = "";
            if (n3 > 0) {
                super.eol(iCodeCoordinates);
                object2 = Strings.spaces(n2);
            }
            this.space(2);
            object2 = (String)object2 + string + string2;
            this.appendComment((String)object2, bl2);
            ++n3;
        }
    }

    public void appendMultiLineCommentAuto(String string, boolean bl, boolean bl2) {
        this.appendMultiLineComment(string, true, bl, bl2);
    }

    public void appendMultiLineComment(String string, boolean bl, boolean bl2) {
        this.appendMultiLineComment(string, false, bl, bl2);
    }

    private void appendMultiLineComment(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string == null || string.isEmpty()) {
            return;
        }
        ItemClassIdentifiers itemClassIdentifiers = bl ? ItemClassIdentifiers.COMMENT_AUTO : ItemClassIdentifiers.COMMENT;
        int n2 = this.getCurrentLineLength() - this.getCurrentMarginLength();
        String[] stringArray = Strings.splitLines(string);
        this.eol_comment = null;
        if (bl2 && stringArray.length > 1) {
            this.appendAndRecord(this.commentBlockBegin, itemClassIdentifiers);
            for (String string2 : stringArray) {
                this.eolSaveCoord();
                this.space(n2);
                this.appendAndRecord(string2, itemClassIdentifiers);
            }
            this.eolSaveCoord();
            this.space(n2);
            this.appendAndRecord(this.commentBlockEnd, itemClassIdentifiers);
        } else {
            int n3 = 0;
            for (String string3 : stringArray) {
                if (n3 >= 1) {
                    ICodeCoordinates iCodeCoordinates = this.eol_coord;
                    this.eolSaveCoord();
                    this.eol_coord = iCodeCoordinates;
                    this.space(n2);
                }
                this.appendAndRecord(this.commentInline + " " + string3, itemClassIdentifiers);
                ++n3;
            }
        }
        if (bl3) {
            this.eol();
        }
    }

    private void eolSaveCoord() {
        ICodeCoordinates iCodeCoordinates = this.eol_coord;
        this.eol();
        this.eol_coord = iCodeCoordinates;
    }

    @Override
    public void validate() {
        super.validate();
    }
}

