/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code;

import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.units.impl.Comment;
import com.pnfsoftware.jeb.core.units.impl.MetaComment;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Collection;
import java.util.stream.Collectors;

public class CommentGenerator {
    private CodeDocumentPart out;
    private String pfx;
    private String pfxInline;
    private int margin;
    private int i;
    private int actualMargin;

    public CommentGenerator(CodeDocumentPart codeDocumentPart, String string) {
        this(codeDocumentPart, string, 2, 1);
    }

    public CommentGenerator(CodeDocumentPart codeDocumentPart, String string, int n2, int n3) {
        if (codeDocumentPart == null || string == null || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.out = codeDocumentPart;
        this.pfx = string + Strings.spaces(n3);
        this.pfxInline = Strings.spaces(n2) + this.pfx;
    }

    public void setMargin(int n2) {
        this.margin = n2;
    }

    public int getMargin() {
        return this.margin;
    }

    public void reset() {
        this.margin = 0;
        this.i = 0;
        this.actualMargin = 0;
    }

    public boolean genInline(ICodeCoordinates iCodeCoordinates, String string, boolean bl) {
        Assert.a(this.i == 0);
        if (string != null && !string.isEmpty()) {
            this.ac(iCodeCoordinates, string, true, bl);
        }
        return this.i > 0;
    }

    public boolean genInline(ICodeCoordinates iCodeCoordinates, Comment comment, int n2, int n3, String string) {
        Assert.a(this.i == 0);
        if (comment != null) {
            Collection<MetaComment> collection;
            String string2 = comment.getInline();
            if (string2 != null) {
                this.ac(iCodeCoordinates, string2, true, false);
            }
            if (!(collection = comment.getMetaComments(n2, n3)).isEmpty()) {
                string2 = Strings.join("\n", collection.stream().map(metaComment -> metaComment.toString()).collect(Collectors.toList()));
                this.ac(iCodeCoordinates, string2, true, true);
            }
        }
        if (string != null && !string.isEmpty()) {
            this.ac(iCodeCoordinates, string, true, true);
        }
        return this.i > 0;
    }

    public boolean genPre(ICodeCoordinates iCodeCoordinates, Comment comment, String string) {
        String string2;
        Assert.a(this.i == 0);
        if (comment != null && (string2 = comment.getPre()) != null) {
            this.ac(iCodeCoordinates, comment.getPre(), false, false);
        }
        if (string != null && !string.isEmpty()) {
            this.ac(iCodeCoordinates, string, true, true);
        }
        if (this.i <= 0) {
            return false;
        }
        this.out.eol();
        return true;
    }

    private void ac(ICodeCoordinates iCodeCoordinates, String string, boolean bl, boolean bl2) {
        if (this.i == 0) {
            int n2;
            if (this.margin > 0 && (n2 = this.margin - this.out.getCurrentLineLength()) > 0) {
                this.out.space(n2);
            }
            this.actualMargin = this.out.getCurrentLineLength();
        }
        for (String string2 : Strings.splitLines(string)) {
            if (this.i >= 1) {
                this.out.eol(iCodeCoordinates);
                this.out.space(this.actualMargin);
            }
            this.out.appendComment((bl ? this.pfxInline : this.pfx) + string2, bl2);
            ++this.i;
        }
    }
}

