/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.AssemblyItem;
import com.pnfsoftware.jeb.core.output.code.CodeAnchor;
import com.pnfsoftware.jeb.core.output.code.CodeLine;
import com.pnfsoftware.jeb.core.output.code.ICodeDocument;
import com.pnfsoftware.jeb.core.output.code.coordinates.CodeCoordinatesUtil;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ObjectLocation;
import com.pnfsoftware.jeb.core.output.text.impl.TextMark;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CodeDocumentPart
implements ICodeDocument,
ITextDocumentPart {
    private List<CodeLine> lines;
    private List<CodeAnchor> anchors;
    private long currentAnchorId;
    private boolean padding;
    protected String paddingString;
    private int indentLevel;
    protected String indentString;
    private Deque<ICodeCoordinates> linecoordstack = new ArrayDeque<ICodeCoordinates>();
    private Deque<ICodeCoordinates> coordstack = new ArrayDeque<ICodeCoordinates>();
    private int sepCounter = 0;
    private Deque<Couple<Long, Character>> sepStack = new ArrayDeque<Couple<Long, Character>>();
    private String parameterSeparator = ", ";
    private List<String> keywords = new ArrayList<String>();
    static boolean tokenFlatteningEnabled;
    private static final Set<Character> noEscape;
    private List<ObjectLocation> objlist = new ArrayList<ObjectLocation>();

    public CodeDocumentPart(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Invalid anchor identifier: " + l2);
        }
        this.padding = false;
        this.paddingString = "          ";
        this.indentLevel = 0;
        this.indentString = "    ";
        this.lines = new ArrayList<CodeLine>();
        this.lines.add(new CodeLine());
        this.anchors = new ArrayList<CodeAnchor>();
        this.currentAnchorId = l2;
    }

    public List<CodeLine> getLines() {
        return this.lines.subList(0, this.lines.size() - 1);
    }

    @Override
    public CodeLine getLine(int n2) {
        if (n2 < 0 || n2 + 1 >= this.lines.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.lines.get(n2);
    }

    public List<CodeAnchor> getAnchors() {
        return this.anchors;
    }

    private boolean canRegisterAnchor(long l2, int n2) {
        if (l2 < 0L || n2 < 0) {
            throw new IllegalArgumentException(Strings.ff("Can not register anchor id %d with line index %d: need positive values.", l2, n2));
        }
        if (!this.anchors.isEmpty()) {
            CodeAnchor codeAnchor = this.anchors.get(this.anchors.size() - 1);
            if (codeAnchor.getIdentifier() >= l2) {
                return false;
            }
            if (codeAnchor.getLineIndex() >= n2) {
                return false;
            }
        }
        return true;
    }

    public boolean registerAnchor(String string) {
        int n2 = this.getCurrentLineIndex();
        if (!this.canRegisterAnchor(this.currentAnchorId, n2)) {
            return false;
        }
        this.anchors.add(new CodeAnchor(this.currentAnchorId, n2, string));
        ++this.currentAnchorId;
        return true;
    }

    public boolean registerAnchor(long l2, String string) {
        int n2 = this.getCurrentLineIndex();
        if (!this.canRegisterAnchor(l2, n2)) {
            return false;
        }
        this.anchors.add(new CodeAnchor(l2, n2, string));
        this.currentAnchorId = l2 + 1L;
        return true;
    }

    public CodeAnchor getCurrentAnchor() {
        return this.anchors.get(this.anchors.size() - 1);
    }

    public int getLineCount() {
        return this.lines.size() - 1;
    }

    public int getCurrentLineIndex() {
        return this.lines.size() - 1;
    }

    public int getLastLineIndex() {
        return this.lines.size() - 2;
    }

    public CodeLine getCurrentLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public int getCurrentLineLength() {
        return this.getCurrentLine().getText().length();
    }

    public boolean isCurrentLineEmpty() {
        return this.getCurrentLine().isEmpty();
    }

    public void setIndentationString(String string) {
        this.indentString = string;
    }

    public String getIndentationString() {
        return this.indentString;
    }

    public void setPaddingString(String string) {
        this.paddingString = string;
    }

    public void resetPaddingString() {
        this.paddingString = "";
    }

    public void enablePadding() {
        this.padding = true;
    }

    public void disablePadding() {
        this.padding = false;
    }

    public void indentReset() {
        this.indentLevel = 0;
    }

    public int getIndentationLevel() {
        return this.indentLevel;
    }

    public void setIndentationLevel(int n2) {
        this.indentLevel = n2;
    }

    public void incrementIndentationLevel() {
        ++this.indentLevel;
    }

    public void decrementIndentationLevel() {
        --this.indentLevel;
    }

    public int getCurrentMarginLength() {
        int n2 = 0;
        if (this.padding && this.paddingString != null) {
            n2 += this.paddingString.length();
        }
        if (this.indentLevel > 0 && this.indentString != null) {
            n2 += this.indentLevel * this.indentString.length();
        }
        return n2;
    }

    public static boolean enableTokenFlattening(boolean bl) {
        boolean bl2 = tokenFlatteningEnabled;
        tokenFlatteningEnabled = bl;
        return bl2;
    }

    public void append(String string, int[] nArray) {
        CodeLine codeLine;
        string = Strings.replaceNewLines(string, "/");
        if (tokenFlatteningEnabled) {
            string = Formatter.escapeString(string, 0, true, noEscape);
        }
        if ((codeLine = this.getCurrentLine()).isEmpty()) {
            if (this.padding) {
                codeLine.append(this.paddingString);
            }
            for (int i = 0; i < this.indentLevel; ++i) {
                codeLine.append(this.indentString);
            }
        }
        if (nArray != null) {
            nArray[0] = codeLine.length();
        }
        codeLine.append(string);
    }

    @Override
    public void append(String string) {
        this.append(string, (int[])null);
    }

    @Override
    public void append(String string, ItemClassIdentifiers itemClassIdentifiers) {
        this.appendAndRecord(string, itemClassIdentifiers);
    }

    private void appendSafe(CharSequence charSequence) {
        CodeLine codeLine = this.getCurrentLine();
        if (codeLine.isEmpty()) {
            if (this.padding) {
                codeLine.append(this.paddingString);
            }
            for (int i = 0; i < this.indentLevel; ++i) {
                codeLine.append(this.indentString);
            }
        }
        codeLine.append(charSequence);
    }

    public void appendMulti(String string) {
        int n2 = 0;
        for (String string2 : Strings.splitLines(string)) {
            if (n2 >= 1) {
                this.eol();
            }
            this.append(string2);
            ++n2;
        }
    }

    public void space() {
        this.appendSafe(" ");
    }

    public void space(int n2) {
        switch (n2) {
            case 1: {
                this.appendSafe(" ");
                break;
            }
            case 2: {
                this.appendSafe("  ");
                break;
            }
            case 3: {
                this.appendSafe("   ");
                break;
            }
            case 4: {
                this.appendSafe("    ");
                break;
            }
            case 8: {
                this.appendSafe("        ");
                break;
            }
            case 10: {
                this.appendSafe("          ");
                break;
            }
            default: {
                if (n2 <= 0) break;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append(' ');
                }
                this.appendSafe(stringBuilder);
            }
        }
    }

    public void setParameterSeparator(String string) {
        this.parameterSeparator = Strings.replaceNewLines(string, "/");
    }

    public void appendParameterSeparator() {
        this.appendSafe(this.parameterSeparator);
    }

    protected int registerKeyword(String string) {
        String string2 = Strings.replaceNewLines(string, "/");
        this.keywords.add(string2);
        return this.keywords.size() - 1;
    }

    protected void appendKeyword(int n2) {
        this.appendSafe(this.keywords.get(n2));
    }

    public void eol(ICodeCoordinates iCodeCoordinates) {
        if (iCodeCoordinates != null) {
            this.lines.get(this.lines.size() - 1).setLineCoordinates(iCodeCoordinates);
        }
        this.lines.add(new CodeLine());
        this.registerCurrentCoordinates();
    }

    public void eol() {
        this.eol(null);
    }

    long sep(char c2) {
        long l2 = 0xFFEE000000000000L | (long)this.sepCounter;
        ++this.sepCounter;
        this.appendAndRecord("" + c2, ItemClassIdentifiers.SEPARATOR, l2);
        this.sepStack.push(new Couple<Long, Character>(l2, Character.valueOf(c2)));
        return l2;
    }

    void sepClose(char c2) {
        Couple<Long, Character> couple = this.sepStack.pop();
        long l2 = couple.getFirst();
        this.appendAndRecord("" + c2, ItemClassIdentifiers.SEPARATOR, l2);
    }

    @Override
    public void paren() {
        this.sep('(');
    }

    @Override
    public void parenClose() {
        this.sepClose(')');
    }

    @Override
    public void brace() {
        this.sep('{');
    }

    @Override
    public void braceClose() {
        this.sepClose('}');
    }

    @Override
    public void bracket() {
        this.sep('[');
    }

    @Override
    public void bracketClose() {
        this.sepClose(']');
    }

    public void appendAndRecord(String string, ItemClassIdentifiers itemClassIdentifiers) {
        this.appendAndRecord(string, itemClassIdentifiers, 0L, 0);
    }

    public void appendAndRecord(String string, ItemClassIdentifiers itemClassIdentifiers, long l2) {
        this.appendAndRecord(string, itemClassIdentifiers, l2, 0);
    }

    public void appendAndRecord(String string, ItemClassIdentifiers itemClassIdentifiers, long l2, int n2) {
        if (string == null) {
            string = Strings.safe(string);
        }
        int[] nArray = new int[1];
        this.append(string, nArray);
        int n3 = nArray[0];
        CodeLine codeLine = this.getCurrentLine();
        int n4 = codeLine.getText().length() - n3;
        AssemblyItem assemblyItem = new AssemblyItem(n3, n4, itemClassIdentifiers, l2, n2);
        codeLine.addItem(assemblyItem);
    }

    @Override
    public void appendKeyword(String string) {
        this.appendAndRecord(string, ItemClassIdentifiers.KEYWORD);
    }

    public void appendKeyword(String string, long l2) {
        this.appendAndRecord(string, ItemClassIdentifiers.KEYWORD, l2);
    }

    public void appendComment(String string) {
        this.appendAndRecord(string, ItemClassIdentifiers.COMMENT);
    }

    public void appendComment(String string, boolean bl) {
        this.appendAndRecord(string, bl ? ItemClassIdentifiers.COMMENT_AUTO : ItemClassIdentifiers.COMMENT);
    }

    public void appendCommentAuto(String string) {
        this.appendAndRecord(string, ItemClassIdentifiers.COMMENT_AUTO);
    }

    public void recordLineCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.linecoordstack.push(iCodeCoordinates);
    }

    public void unrecordLineCoordinates() {
        this.linecoordstack.pop();
    }

    public ICodeCoordinates getCurrentLineCoordinates() {
        return this.linecoordstack.peek();
    }

    public ICodeCoordinates getCurrentMostPreciseCodeCoordinates() {
        ICodeCoordinates iCodeCoordinates = this.getCurrentLineCoordinates();
        ICodeCoordinates iCodeCoordinates2 = this.getCurrentCoordinates();
        return CodeCoordinatesUtil.getMostAccurate(iCodeCoordinates, iCodeCoordinates2);
    }

    public void recordCurrentCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.coordstack.push(iCodeCoordinates);
        this.registerCurrentCoordinates();
    }

    public void unrecordCurrentCoordinates() {
        this.coordstack.pop();
        this.registerCurrentCoordinates();
    }

    public ICodeCoordinates getCurrentCoordinates() {
        return this.coordstack.peek();
    }

    private void registerCurrentCoordinates() {
    }

    public void validate() {
        if (!this.coordstack.isEmpty()) {
            throw new JebRuntimeException("Invalid coords at anchor " + this.currentAnchorId);
        }
        if (!this.isCurrentLineEmpty()) {
            throw new JebRuntimeException("Current line is not empty at anchor " + this.currentAnchorId);
        }
    }

    public void prependCodePart(CodeDocumentPart codeDocumentPart) {
        Long l2 = Long.MAX_VALUE;
        if (!this.anchors.isEmpty()) {
            l2 = this.anchors.get(0).getIdentifier();
        }
        ArrayList<CodeAnchor> arrayList = new ArrayList<CodeAnchor>(codeDocumentPart.anchors.size());
        for (CodeAnchor object2 : codeDocumentPart.anchors) {
            if (object2.getIdentifier() >= l2) continue;
            arrayList.add(object2);
        }
        int n2 = codeDocumentPart.getLineCount();
        for (CodeAnchor codeAnchor : this.anchors) {
            codeAnchor.adjustLineindex(n2);
        }
        arrayList.addAll(this.anchors);
        this.anchors = arrayList;
        ArrayList<CodeLine> arrayList2 = new ArrayList<CodeLine>(codeDocumentPart.lines.subList(0, codeDocumentPart.lines.size() - 1));
        arrayList2.addAll(this.lines);
        this.lines = arrayList2;
    }

    public boolean moveLine(int n2, int n3) {
        if (this.getLineCount() <= 1) {
            return false;
        }
        int n4 = this.getCurrentLineIndex();
        if (n2 == n3 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4) {
            return false;
        }
        CodeLine codeLine = this.lines.remove(n2);
        if (n3 < n2) {
            this.lines.add(n3, codeLine);
        } else {
            this.lines.add(n3 - 1, codeLine);
        }
        if (n3 < n2) {
            for (ObjectLocation objectLocation : this.objlist) {
                if (objectLocation.lineBegin >= n3 && objectLocation.lineBegin < n2) {
                    ++objectLocation.lineBegin;
                }
                if (objectLocation.lineEnd < n3 || objectLocation.lineEnd >= n2) continue;
                ++objectLocation.lineEnd;
            }
        } else {
            for (ObjectLocation objectLocation : this.objlist) {
                if (objectLocation.lineBegin > n2 && objectLocation.lineBegin <= n3) {
                    --objectLocation.lineBegin;
                }
                if (objectLocation.lineEnd <= n2 || objectLocation.lineEnd > n3) continue;
                --objectLocation.lineEnd;
            }
        }
        return true;
    }

    public boolean moveLastLine(int n2) {
        return this.moveLine(this.getLastLineIndex(), n2);
    }

    public void markCurrentPosition(String string, Object object) {
        this.getCurrentLine().addMark(new TextMark(this.getCurrentLineLength(), string, object));
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CodeLine codeLine : this.lines) {
            stringBuilder.append(codeLine.getText());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void recordObjectLocation(Object object, boolean bl, int n2) {
        if (this.objlist == null) {
            return;
        }
        if (bl) {
            ObjectLocation objectLocation = new ObjectLocation();
            objectLocation.object = object;
            objectLocation.depth = n2;
            objectLocation.lineBegin = this.getCurrentLineIndex();
            objectLocation.columnBegin = this.getCurrentLineLength();
            this.objlist.add(objectLocation);
        } else {
            for (int i = this.objlist.size() - 1; i >= 0; --i) {
                ObjectLocation objectLocation = this.objlist.get(i);
                if (objectLocation.object != object || objectLocation.depth != n2 || objectLocation.lineEnd != -1) continue;
                objectLocation.lineEnd = this.getCurrentLineIndex();
                objectLocation.columnEnd = this.getCurrentLineLength();
                return;
            }
            this.objlist = null;
            RuntimeException runtimeException = new RuntimeException(Strings.ff("Missing start element for entry: object=%s, depth=%d", object, n2));
            JebCoreService.notifySilentExceptionToClient(runtimeException);
        }
    }

    public List<ObjectLocation> getObjectLocations() {
        if (this.objlist == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.objlist);
    }

    public String toString() {
        return Strings.ff("Lines:%d,Current:\"%s\"", this.getLineCount(), this.getCurrentLine().getText());
    }

    static {
        noEscape = new HashSet<Character>();
        noEscape.add(Character.valueOf('\''));
        noEscape.add(Character.valueOf('\"'));
        noEscape.add(Character.valueOf('\\'));
    }
}

