/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output;

import com.pnfsoftware.jeb.util.format.HtmlFormatter;
import com.pnfsoftware.jeb.util.format.XmlBuilder;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractHtmlFormatter<StyleObject> {
    private CharSequence titledata;
    private boolean insertCopyright;
    private StringBuilder cssdata;
    private Map<StyleObject, String> styleidToDivclassname = new HashMap<StyleObject, String>();
    private Map<CharSequence, StyleObject> cssToStyleId = new HashMap<CharSequence, StyleObject>();

    public AbstractHtmlFormatter(String string, StringBuilder stringBuilder, boolean bl) {
        this.titledata = XmlBuilder.escapeAll(string);
        this.cssdata = stringBuilder;
        this.insertCopyright = bl;
    }

    protected String generate(CharSequence charSequence) {
        return HtmlFormatter.generate(this.titledata, (CharSequence)this.cssdata, charSequence, this.insertCopyright).toString();
    }

    protected String generateCssDivStyle(StyleObject StyleObject) {
        String string = this.styleidToDivclassname.get(StyleObject);
        if (string != null) {
            return string;
        }
        String string2 = this.getClassname(StyleObject);
        CharSequence charSequence = this.generateCssBlock(StyleObject, string2);
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        CharSequence charSequence2 = charSequence.subSequence(string2.length() + 2, charSequence.length());
        if (this.cssToStyleId.containsKey(charSequence2)) {
            StyleObject StyleObject2 = this.cssToStyleId.get(charSequence2);
            string2 = this.styleidToDivclassname.get(StyleObject2);
        } else {
            this.cssdata.append(charSequence);
            this.cssToStyleId.put(charSequence.subSequence(string2.length() + 2, charSequence.length()), StyleObject);
        }
        this.styleidToDivclassname.put(StyleObject, string2);
        return string2;
    }

    protected abstract CharSequence generateCssBlock(StyleObject var1, String var2);

    protected String getClassname(StyleObject StyleObject) {
        Object object = StyleObject.toString().toLowerCase().substring(0, 1);
        if (((String)object).isEmpty() || ((String)object).charAt(0) < 'a' || ((String)object).charAt(0) > 'z') {
            object = "z";
        }
        if (this.styleidToDivclassname.containsValue(object)) {
            for (char c2 = 'z'; c2 >= 'a'; c2 = (char)(c2 - '\u0001')) {
                object = Character.toString(c2);
                if (this.styleidToDivclassname.containsValue(object)) continue;
                return object;
            }
        }
        String string = StyleObject.toString().toLowerCase().substring(0, 1);
        int n2 = 0;
        while (this.styleidToDivclassname.containsValue(object)) {
            object = string.substring(0, 1) + n2;
            ++n2;
        }
        return object;
    }
}

