/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.io.SubSeekableByteChannel;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;

@Ser
public class SubInput
implements IInput {
    @SerId(value=1)
    private IInput masterInput;
    @SerId(value=2)
    private long base;
    @SerId(value=3)
    private long maxsize;
    @SerTransient
    private ByteBuffer hdr;

    @SerCustomInitPostGraph
    private void init() {
        try {
            this.setup(this.masterInput, this.base, this.maxsize);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public SubInput(IInput iInput, long l2, long l3) throws IOException {
        this.setup(iInput, l2, l3);
    }

    private void setup(IInput iInput, long l2, long l3) throws IOException {
        if (l2 < 0L || l3 < 0L || l2 + l3 > iInput.getCurrentSize()) {
            throw new IllegalArgumentException();
        }
        this.masterInput = iInput;
        this.base = l2;
        this.maxsize = l3;
        try (SeekableByteChannel seekableByteChannel = null;){
            seekableByteChannel = iInput.getChannel();
            this.hdr = ByteBuffer.allocate(512);
            int n2 = seekableByteChannel.position(l2).read(this.hdr);
            if (n2 < 0) {
                throw new IOException("Unexpected end of stream");
            }
            this.hdr.position(0);
            this.hdr.limit(n2);
        }
    }

    IInput getMasterInput() {
        return this.masterInput;
    }

    @Override
    public String getName() {
        String string = this.masterInput.getName();
        if (string == null) {
            return null;
        }
        return "Sub of " + string;
    }

    @Override
    public boolean canRead() {
        return this.masterInput.canRead();
    }

    @Override
    public void close() {
    }

    @Override
    public long getCurrentSize() {
        return this.maxsize;
    }

    @Override
    public ByteBuffer getHeader() {
        return this.hdr.asReadOnlyBuffer();
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        return new SubSeekableByteChannel(this.masterInput.getChannel(), this.base, this.maxsize);
    }

    @Override
    public InputStream getStream() throws IOException {
        return Channels.newInputStream(this.getChannel());
    }
}

