/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.IInputLocation;
import com.pnfsoftware.jeb.util.format.Strings;

public class FileInputRegionInformation
implements IInputLocation {
    private long offset;
    private long size;
    private IInput input;

    public FileInputRegionInformation(long l2) {
        this(l2, 0L);
    }

    public FileInputRegionInformation(long l2, long l3) {
        this(l2, l3, null);
    }

    public FileInputRegionInformation(long l2, long l3, IInput iInput) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(Strings.ff("Offset cannot be negative (%d)", l2));
        }
        this.offset = l2;
        this.size = l3;
        this.input = iInput;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public IInput getInput() {
        return this.input;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "@%X", this.offset);
        if (this.size > 0L) {
            Strings.ff(stringBuilder, ",+%X", this.size);
        } else if (this.size < 0L) {
            Strings.ff(stringBuilder, ",-%X", -this.size);
        }
        if (this.input != null && (string = this.input.getName()) != null) {
            Strings.ff(stringBuilder, "[%s]", string);
        }
        return stringBuilder.toString();
    }
}

