/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.encoding.zip.ZipBrowser;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

@Ser
@SerVersion(value=1)
public final class FileInput
implements IInput {
    private static final ILogger logger = GlobalLog.getLogger(FileInput.class);
    public static final int SER_FLAG_FULL_PERSISTENCE = 1;
    @SerId(value=1)
    private String path;
    @SerId(value=2)
    private byte[] sha256hash;
    @SerId(value=3)
    private byte[] fulldata;
    @SerTransient
    private String pathbase;
    @SerTransient
    private File file;
    @SerTransient
    private ByteBuffer hdr;
    @SerTransient
    private List<InputStream> inputStreams = new ArrayList<InputStream>();

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        if ((serializerHelper.getFlags() & 1) != 0 && this.fulldata == null && this.file != null && this.file.isFile() && this.file.canRead()) {
            try {
                this.fulldata = IO.readFile(this.file);
                this.sha256hash = Hash.calculateSHA256(this.fulldata);
            }
            catch (IOException iOException) {}
        }
        serializerHelper.saveStandard();
        this.fulldata = null;
    }

    @SerCustomRead
    private void load(DeserializerHelper deserializerHelper) throws IOException {
        if (deserializerHelper.getSerializedVersion() == 0) {
            this.path = (String)deserializerHelper.read();
        } else {
            deserializerHelper.loadStandard();
        }
    }

    @SerCustomInitPostGraph
    private void init() throws IOException {
        this.inputStreams = new ArrayList<InputStream>();
        this.setup(false);
    }

    public FileInput(File file) throws IOException {
        this(file, true);
    }

    private FileInput(File file, boolean bl) throws IOException {
        this(file.getPath(), bl);
    }

    public FileInput(String string) throws IOException {
        this(string, true);
    }

    private FileInput(String string, boolean bl) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Null file path");
        }
        this.path = string;
        this.setup(bl);
    }

    private boolean setup(boolean bl) throws IOException {
        try {
            this.file = this.processInput(this.getPath(), 0);
        }
        catch (IOException iOException) {
            if (bl) {
                throw iOException;
            }
            return false;
        }
        try (FileInputStream fileInputStream = new FileInputStream(this.file);
             FileChannel fileChannel = fileInputStream.getChannel();){
            this.hdr = ByteBuffer.allocate(512);
            int n2 = fileChannel.read(this.hdr);
            this.hdr.limit(Math.max(0, n2));
            this.hdr.position(0);
        }
        return true;
    }

    private File processInput(String string, int n2) throws IOException {
        File file = new File(string);
        boolean bl = false;
        if (!file.isFile()) {
            if (n2 == 0 && this.fulldata != null) {
                logger.debug("Restoring missing artifact file from full data (sha256: %s)", Formatter.byteArrayToHex(this.sha256hash));
                String string2 = Formatter.byteArrayToHex(this.sha256hash) + "_" + IO.splitPath(file.getPath())[1];
                file = IO.createTempFile(string2);
                IO.writeFile(file, this.fulldata);
                return file;
            }
            bl = true;
        }
        if (!bl && !file.canRead()) {
            throw new IOException("Cannot read input file: " + file);
        }
        if (bl) {
            string = file.getPath();
            int n3 = string.lastIndexOf(33);
            if (n3 < 0) {
                throw new IOException("Cannot process input file: " + file);
            }
            String string3 = string.substring(0, n3);
            String string4 = string.substring(n3 + 1).replace('\\', '/');
            File file2 = this.processInput(string3, n2 + 1);
            try (ZipBrowser zipBrowser = new ZipBrowser(file2);
                 InputStream inputStream = zipBrowser.getEntryStream(string4);){
                String string5 = string4.substring(string4.lastIndexOf(47) + 1);
                file = IO.createTempFileNumbered(string5 + ".EXT");
                file.deleteOnExit();
                IO.writeFile(file, IO.readInputStream(inputStream));
            }
        }
        if (n2 > 0 && IO.getFirstShortLE(file.getAbsolutePath()) != 19280) {
            throw new IOException("Expected a zip");
        }
        return file;
    }

    @Override
    public String getName() {
        int n2;
        String string = this.getPath();
        if (string != null && (n2 = Strings.lastIndexOf2(string, '/', '\\')) >= 0) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public File getFile() {
        return this.file;
    }

    @Deprecated
    public String getOriginalPath() {
        return this.getPath();
    }

    public String getPath() {
        if (this.path == null) {
            return null;
        }
        if (this.pathbase != null) {
            return this.pathbase + File.separatorChar + this.path;
        }
        return this.path;
    }

    public String getPersistedPath() {
        return this.path;
    }

    public String getPathBase() {
        return this.pathbase;
    }

    public boolean rebase(String string) {
        if (this.pathbase != null || new File(this.path).isAbsolute()) {
            return false;
        }
        this.pathbase = string;
        try {
            if (!this.setup(false)) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean setBase(String string) {
        int n2;
        int n3;
        if (this.file == null) {
            return false;
        }
        if (string == null) {
            this.pathbase = null;
            this.path = this.file.getPath();
            return true;
        }
        String string2 = IO.simplifyPath(this.file.getAbsolutePath());
        String string3 = IO.simplifyPath(string);
        String[] stringArray = string3.split("[\\\\//]");
        String[] stringArray2 = string2.split("[\\\\//]");
        for (n3 = 0; n3 < stringArray.length && n3 < stringArray2.length && stringArray[n3].equals(stringArray2[n3]); ++n3) {
        }
        int n4 = stringArray.length - n3;
        Object object = "";
        for (n2 = 0; n2 < n4; ++n2) {
            object = (String)object + ".." + File.separatorChar;
        }
        for (n2 = n3; n2 < stringArray2.length; ++n2) {
            object = (String)object + stringArray2[n2] + File.separatorChar;
        }
        object = ((String)object).substring(0, ((String)object).length() - 1);
        try {
            if (!this.file.getCanonicalFile().equals(new File(string3 + File.separatorChar + (String)object).getCanonicalFile())) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        this.pathbase = string3;
        this.path = object;
        return true;
    }

    public void setFile(File file) throws IOException {
        if (this.file != null) {
            throw new IOException("A file is already connected to this input object");
        }
        String string = this.pathbase;
        this.pathbase = null;
        this.path = file.getPath();
        this.setup(true);
        if (string != null) {
            this.setBase(string);
        }
    }

    @Override
    public boolean canRead() {
        return this.file != null && this.file.canRead();
    }

    @Override
    public void close() {
        for (InputStream inputStream : this.inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long getCurrentSize() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    public ByteBuffer getHeader() {
        if (this.file == null) {
            return null;
        }
        return this.hdr.asReadOnlyBuffer();
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        if (this.file == null) {
            throw new IOException("The file does not exist: " + this.file);
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.inputStreams.add(fileInputStream);
        return fileInputStream.getChannel();
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.file == null) {
            throw new IOException("The file does not exist: " + this.file);
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.inputStreams.add(fileInputStream);
        return fileInputStream;
    }

    public String toString() {
        return "" + this.file;
    }
}

