/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.io.ArraySeekableByteChannel;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

@Ser
public class BytesInput
implements IInput {
    @SerId(value=1)
    private byte[] data;
    @SerId(value=2)
    private int offset;
    @SerId(value=3)
    private int length;
    @SerId(value=4)
    private String name;
    @SerTransient
    private ByteBuffer buffer;

    @SerCustomInitPostGraph
    private void init() {
        if (this.offset == 0 && this.length == 0) {
            this.length = this.data.length;
        }
        this.buffer = ByteBuffer.wrap(this.data, this.offset, this.length);
    }

    public BytesInput(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public BytesInput(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, null);
    }

    public BytesInput(byte[] byArray, int n2, int n3, String string) {
        this.buffer = ByteBuffer.wrap(byArray, n2, n3);
        this.data = byArray;
        this.offset = n2;
        this.length = n3;
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public long getCurrentSize() {
        return this.length;
    }

    @Override
    public ByteBuffer getHeader() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public SeekableByteChannel getChannel() {
        return new ArraySeekableByteChannel(this.data, this.offset, this.length);
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }
}

