/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.events;

import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.events.IEventSource;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Ser
public class JebEventSource
implements IEventSource {
    private static final ILogger logger = GlobalLog.getLogger(JebEventSource.class);
    @SerTransient
    private List<IEventListener> listeners;
    @SerTransient
    private volatile IEventSource parentSource;

    @SerCustomInit
    private void init() {
        this.listeners = new CopyOnWriteArrayList<IEventListener>();
    }

    public JebEventSource() {
        this(null);
    }

    public JebEventSource(IEventSource iEventSource) {
        this.parentSource = iEventSource;
        this.init();
    }

    @Override
    public void setParentSource(IEventSource iEventSource) {
        this.parentSource = iEventSource;
    }

    @Override
    public IEventSource getParentSource() {
        return this.parentSource;
    }

    @Override
    public int countListeners() {
        return this.listeners.size();
    }

    public List<IEventListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addListener(IEventListener iEventListener) {
        if (iEventListener != null) {
            this.listeners.add(iEventListener);
        }
    }

    @Override
    public void insertListener(int n2, IEventListener iEventListener) {
        if (iEventListener != null) {
            this.listeners.add(n2, iEventListener);
        }
    }

    @Override
    public void removeListener(IEventListener iEventListener) {
        if (iEventListener != null) {
            this.listeners.remove(iEventListener);
        }
    }

    @Override
    public void notifyListeners(IEvent iEvent) {
        if (!(iEvent instanceof JebEvent)) {
            for (IEventListener iEventListener : this.listeners) {
                iEventListener.onEvent(iEvent);
            }
        } else {
            this.notifyListeners((JebEvent)iEvent);
        }
    }

    public void notifyListeners(JebEvent jebEvent) {
        this.notifyListeners(jebEvent, true);
    }

    public void notifyListeners(JebEvent jebEvent, boolean bl) {
        if (jebEvent.getSource() == null) {
            jebEvent.setSource(this);
        }
        if (bl && this.parentSource != null && this.parentSource != this && jebEvent.getSource() != this.parentSource && !jebEvent.notifiedParents.contains(this.parentSource)) {
            jebEvent.notifiedParents.add(this.parentSource);
            this.parentSource.notifyListeners(jebEvent);
        }
        for (IEventListener iEventListener : this.listeners) {
            if (jebEvent.getSource() == iEventListener || jebEvent.notifiedListeners.contains(iEventListener)) continue;
            jebEvent.notifiedListeners.add(iEventListener);
            iEventListener.onEvent(jebEvent);
            if (!jebEvent.shouldStopPropagation()) continue;
            break;
        }
    }
}

